# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest
import datetime

import lilt
from lilt.models.create_converter_config_parameters import CreateConverterConfigParameters  # noqa: E501
from lilt.rest import ApiException

class TestCreateConverterConfigParameters(unittest.TestCase):
    """CreateConverterConfigParameters unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional):
        """Test CreateConverterConfigParameters
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # model = lilt.models.create_converter_config_parameters.CreateConverterConfigParameters()  # noqa: E501
        if include_optional :
            return CreateConverterConfigParameters(
                config_json = '{"registry": {".md": {"type": "OkapiFprm", "version": 1, "filterName": "okf_markdown", "filterConfig": "#v1\nuseCodeFinder.b=false\ntranslateUrls.b=true\nurlToTranslatePattern=.+\ntranslateCodeBlocks.b=false\ntranslateInlineCodeBlocks.b=true\ntranslateHeaderMetadata.b=true\ntranslateImageAltText.b=true\nuseLinkSubflow.b=true\ncodeFinderRules.count.i=1\ncodeFinderRules.rule0=\\{\\{[^}]+\\}\\}\ncodeFinderRules.sample={{#test}} handle bar test {{/test}}$0a${{stand-alone handle bar}}$0a$\ncodeFinderRules.useAllRulesWhenTesting.b=true\n", "extractAllTags": true, "exportReplacements": {"patterns": [], "replacements": []}, "importReplacements": {"patterns": [], "replacements": []}}}', 
                config_name = 'my_config', 
                config_description = 'config for custom markdown escaping'
            )
        else :
            return CreateConverterConfigParameters(
                config_json = '{"registry": {".md": {"type": "OkapiFprm", "version": 1, "filterName": "okf_markdown", "filterConfig": "#v1\nuseCodeFinder.b=false\ntranslateUrls.b=true\nurlToTranslatePattern=.+\ntranslateCodeBlocks.b=false\ntranslateInlineCodeBlocks.b=true\ntranslateHeaderMetadata.b=true\ntranslateImageAltText.b=true\nuseLinkSubflow.b=true\ncodeFinderRules.count.i=1\ncodeFinderRules.rule0=\\{\\{[^}]+\\}\\}\ncodeFinderRules.sample={{#test}} handle bar test {{/test}}$0a${{stand-alone handle bar}}$0a$\ncodeFinderRules.useAllRulesWhenTesting.b=true\n", "extractAllTags": true, "exportReplacements": {"patterns": [], "replacements": []}, "importReplacements": {"patterns": [], "replacements": []}}}',
                config_name = 'my_config',
                config_description = 'config for custom markdown escaping',
        )

    def testCreateConverterConfigParameters(self):
        """Test CreateConverterConfigParameters"""
        inst_req_only = self.make_instance(include_optional=False)
        inst_req_and_optional = self.make_instance(include_optional=True)


if __name__ == '__main__':
    unittest.main()
