# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest

import lilt
from lilt.api.workflows_api import WorkflowsApi  # noqa: E501
from lilt.rest import ApiException


class TestWorkflowsApi(unittest.TestCase):
    """WorkflowsApi unit test stubs"""

    def setUp(self):
        self.api = lilt.api.workflows_api.WorkflowsApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_advance_workflow_stage(self):
        """Test case for advance_workflow_stage

        Advance workflow to the next stage  # noqa: E501
        """
        pass

    def test_get_document_workflow(self):
        """Test case for get_document_workflow

        Retrieve document Workflow metadata  # noqa: E501
        """
        pass

    def test_get_workflow_templates(self):
        """Test case for get_workflow_templates

        Retrieve workflow templates  # noqa: E501
        """
        pass

    def test_reject_workflow_stage(self):
        """Test case for reject_workflow_stage

        Move workflow to the previous stage  # noqa: E501
        """
        pass

    def test_set_document_stage(self):
        """Test case for set_document_stage

        Set Workflow stage for a document  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
