from enum import Enum


class ReasonCode(Enum):
    """
    Enum of the available reason codes

    Values:
        GENERAL_ERROR (int)
        SESSION_ERROR (int)
        SESSION_REGISTRATION_ERROR (int)
        SESSION_AUTHENTICATION_FAILED (int)
        SESSION_UNREGISTER_FAILED (int)
        SESSION_INVALID_ACTION_FOR_STATE (int)
        SESSION_NEGOTIATION_TIMEOUT (int)
        SESSION_NEGOTIATION_INVALID_OPTIONS (int)
        SESSION_INVALID_SESSION_MODE_REQUESTED (int)
        VALIDATION_ERROR (int)
        VALIDATION_EMPTY_DOCUMENT (int)
        VALIDATION_INVALID_RESOURCE (int)
        VALIDATION_INVALID_STATUS (int)
        VALIDATION_INVALID_IDENTITY (int)
        VALIDATION_INVALID_RECIPIENTS (int)
        VALIDATION_INVALID_METHOD (int)
        VALIDATION_INVALID_URI (int)
        AUTHORIZATION_ERROR (int)
        AUTHORIZATION_UNAUTHORIZED_SENDER (int)
        AUTHORIZATION_DESTINATION_ACCOUNT_NOT_FOUND (int)
        AUTHORIZATION_QUOTA_THRESHOLD_EXCEEDED (int)
        AUTHORIZATION_PERMISSION_REQUIRED (int)
        ROUTING_ERROR (int)
        ROUTING_DESTINATION_NOT_FOUND (int)
        ROUTING_GATEWAY_NOT_FOUND (int)
        ROUTING_ROUTE_NOT_FOUND (int)
        DISPATCH_ERROR (int)
        COMMAND_PROCESSING_ERROR (int)
        COMMAND_RESOURCE_NOT_SUPPORTED (int)
        COMMAND_METHOD_NOT_SUPPORTED (int)
        COMMAND_INVALID_ARGUMENT (int)
        COMMAND_INVALID_SESSION_MODE (int)
        COMMAND_NOT_ALLOWED (int)
        COMMAND_RESOURCE_NOT_FOUND (int)
        MESSAGE_PROCESSING_ERROR (int)
        MESSAGE_UNSUPPORTED_CONTENT_TYPE (int)
        GATEWAY_ERROR (int)
        GATEWAY_CONTENT_TYPE_NOT_SUPPORTED (int)
        GATEWAY_DESTINATION_NOT_FOUND (int)
        GATEWAY_NOT_SUPPORTED (int)
        GATEWAY_REQUEST_LIMIT_REACHED (int)
        GATEWAY_OPERATION_TIMED_OUT (int)
        GATEWAY_UNAUTHORIZED_SENDER (int)
        APPLICATION_ERROR (int)
        INVALID_LIST_IDENTIFIER (int)
    """

    GENERAL_ERROR = 1
    SESSION_ERROR = 11
    SESSION_REGISTRATION_ERROR = 12
    SESSION_AUTHENTICATION_FAILED = 13
    SESSION_UNREGISTER_FAILED = 14
    SESSION_INVALID_ACTION_FOR_STATE = 15
    SESSION_NEGOTIATION_TIMEOUT = 16
    SESSION_NEGOTIATION_INVALID_OPTIONS = 17
    SESSION_INVALID_SESSION_MODE_REQUESTED = 18
    VALIDATION_ERROR = 21
    VALIDATION_EMPTY_DOCUMENT = 22
    VALIDATION_INVALID_RESOURCE = 23
    VALIDATION_INVALID_STATUS = 24
    VALIDATION_INVALID_IDENTITY = 25
    VALIDATION_INVALID_RECIPIENTS = 26
    VALIDATION_INVALID_METHOD = 27
    VALIDATION_INVALID_URI = 27
    AUTHORIZATION_ERROR = 31
    AUTHORIZATION_UNAUTHORIZED_SENDER = 32
    AUTHORIZATION_DESTINATION_ACCOUNT_NOT_FOUND = 33
    AUTHORIZATION_QUOTA_THRESHOLD_EXCEEDED = 34
    AUTHORIZATION_PERMISSION_REQUIRED = 35
    ROUTING_ERROR = 41
    ROUTING_DESTINATION_NOT_FOUND = 42
    ROUTING_GATEWAY_NOT_FOUND = 43
    ROUTING_ROUTE_NOT_FOUND = 44
    DISPATCH_ERROR = 51
    COMMAND_PROCESSING_ERROR = 61
    COMMAND_RESOURCE_NOT_SUPPORTED = 62
    COMMAND_METHOD_NOT_SUPPORTED = 63
    COMMAND_INVALID_ARGUMENT = 64
    COMMAND_INVALID_SESSION_MODE = 65
    COMMAND_NOT_ALLOWED = 66
    COMMAND_RESOURCE_NOT_FOUND = 67
    MESSAGE_PROCESSING_ERROR = 61
    MESSAGE_UNSUPPORTED_CONTENT_TYPE = 71
    GATEWAY_ERROR = 81
    GATEWAY_CONTENT_TYPE_NOT_SUPPORTED = 82
    GATEWAY_DESTINATION_NOT_FOUND = 83
    GATEWAY_NOT_SUPPORTED = 84
    GATEWAY_REQUEST_LIMIT_REACHED = 85
    GATEWAY_OPERATION_TIMED_OUT = 86
    GATEWAY_UNAUTHORIZED_SENDER = 87
    APPLICATION_ERROR = 101
    INVALID_LIST_IDENTIFIER = 60
