# coding: utf-8

"""
    Authenticate API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: auth
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ApplicationProfileResponse(BaseModel):
    """
    Represents Linnworks.net application subscription profile
    """ # noqa: E501
    plan_tag: Optional[StrictStr] = Field(default=None, description="Plan Tag as defined in your Application Configuration", alias="PlanTag")
    plan_name: Optional[StrictStr] = Field(default=None, description="Plan Name as defined in your application Configuration", alias="PlanName")
    activation_date: Optional[datetime] = Field(default=None, description="Date when the profile was signed up for, or resubscribed", alias="ActivationDate")
    last_payment_date: Optional[datetime] = Field(default=None, description="Last Payment date", alias="LastPaymentDate")
    next_payment_date: Optional[datetime] = Field(default=None, description="Next payment date", alias="NextPaymentDate")
    profile_expires: Optional[datetime] = Field(default=None, description="When profile is due to expire", alias="ProfileExpires")
    is_profile_active: Optional[StrictBool] = Field(default=None, description="Indicates whether the payment profile is active for the application, if this is set to false it means the customer canceled the profile but the profile is still active due last payment made in the last month.", alias="IsProfileActive")
    __properties: ClassVar[List[str]] = ["PlanTag", "PlanName", "ActivationDate", "LastPaymentDate", "NextPaymentDate", "ProfileExpires", "IsProfileActive"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApplicationProfileResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApplicationProfileResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PlanTag": obj.get("PlanTag"),
            "PlanName": obj.get("PlanName"),
            "ActivationDate": obj.get("ActivationDate"),
            "LastPaymentDate": obj.get("LastPaymentDate"),
            "NextPaymentDate": obj.get("NextPaymentDate"),
            "ProfileExpires": obj.get("ProfileExpires"),
            "IsProfileActive": obj.get("IsProfileActive")
        })
        return _obj


