# coding: utf-8

"""
    Email API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: email
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.email.models.template_tag import TemplateTag
from typing import Optional, Set
from typing_extensions import Self

class EmailTemplateType(BaseModel):
    """
    EmailTemplateType
    """ # noqa: E501
    attached_file_name: Optional[StrictStr] = Field(default=None, alias="AttachedFileName")
    attachment_help_text: Optional[StrictStr] = Field(default=None, alias="AttachmentHelpText")
    type: Optional[StrictStr] = Field(default=None, alias="Type")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    is_adhoc: Optional[StrictBool] = Field(default=None, alias="IsAdhoc")
    is_designer_visible: Optional[StrictBool] = Field(default=None, alias="IsDesignerVisible")
    parsable_creator: Optional[Dict[str, Any]] = Field(default=None, alias="ParsableCreator")
    tags: Optional[List[TemplateTag]] = Field(default=None, alias="Tags")
    attach_pdf_available: Optional[StrictBool] = Field(default=None, alias="AttachPDFAvailable")
    printing_template_type: Optional[StrictStr] = Field(default=None, alias="PrintingTemplateType")
    __properties: ClassVar[List[str]] = ["AttachedFileName", "AttachmentHelpText", "Type", "Name", "IsAdhoc", "IsDesignerVisible", "ParsableCreator", "Tags", "AttachPDFAvailable", "PrintingTemplateType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailTemplateType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "tags",
            "attach_pdf_available",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['Tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailTemplateType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AttachedFileName": obj.get("AttachedFileName"),
            "AttachmentHelpText": obj.get("AttachmentHelpText"),
            "Type": obj.get("Type"),
            "Name": obj.get("Name"),
            "IsAdhoc": obj.get("IsAdhoc"),
            "IsDesignerVisible": obj.get("IsDesignerVisible"),
            "ParsableCreator": obj.get("ParsableCreator"),
            "Tags": [TemplateTag.from_dict(_item) for _item in obj["Tags"]] if obj.get("Tags") is not None else None,
            "AttachPDFAvailable": obj.get("AttachPDFAvailable"),
            "PrintingTemplateType": obj.get("PrintingTemplateType")
        })
        return _obj


