# coding: utf-8

"""
    Import and Export API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: importexport
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.importexport.models.boolean_filter import BooleanFilter
from linnworks_api.generated.importexport.models.date_range_filter import DateRangeFilter
from linnworks_api.generated.importexport.models.numeric_filter import NumericFilter
from linnworks_api.generated.importexport.models.string_filter import StringFilter
from typing import Optional, Set
from typing_extensions import Self

class Filters(BaseModel):
    """
    Filters
    """ # noqa: E501
    numeric_filters: Optional[List[NumericFilter]] = Field(default=None, alias="NumericFilters")
    boolean_filter: Optional[BooleanFilter] = Field(default=None, alias="BooleanFilter")
    date_range_filters: Optional[List[DateRangeFilter]] = Field(default=None, alias="DateRangeFilters")
    string_filters: Optional[List[StringFilter]] = Field(default=None, alias="StringFilters")
    __properties: ClassVar[List[str]] = ["NumericFilters", "BooleanFilter", "DateRangeFilters", "StringFilters"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Filters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in numeric_filters (list)
        _items = []
        if self.numeric_filters:
            for _item_numeric_filters in self.numeric_filters:
                if _item_numeric_filters:
                    _items.append(_item_numeric_filters.to_dict())
            _dict['NumericFilters'] = _items
        # override the default output from pydantic by calling `to_dict()` of boolean_filter
        if self.boolean_filter:
            _dict['BooleanFilter'] = self.boolean_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in date_range_filters (list)
        _items = []
        if self.date_range_filters:
            for _item_date_range_filters in self.date_range_filters:
                if _item_date_range_filters:
                    _items.append(_item_date_range_filters.to_dict())
            _dict['DateRangeFilters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in string_filters (list)
        _items = []
        if self.string_filters:
            for _item_string_filters in self.string_filters:
                if _item_string_filters:
                    _items.append(_item_string_filters.to_dict())
            _dict['StringFilters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Filters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "NumericFilters": [NumericFilter.from_dict(_item) for _item in obj["NumericFilters"]] if obj.get("NumericFilters") is not None else None,
            "BooleanFilter": BooleanFilter.from_dict(obj["BooleanFilter"]) if obj.get("BooleanFilter") is not None else None,
            "DateRangeFilters": [DateRangeFilter.from_dict(_item) for _item in obj["DateRangeFilters"]] if obj.get("DateRangeFilters") is not None else None,
            "StringFilters": [StringFilter.from_dict(_item) for _item in obj["StringFilters"]] if obj.get("StringFilters") is not None else None
        })
        return _obj


