# coding: utf-8

"""
    Import and Export API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: importexport
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.importexport.models.schedule_configuration import ScheduleConfiguration
from typing import Optional, Set
from typing_extensions import Self

class Schedule(BaseModel):
    """
    Schedule
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, alias="Id")
    order: Optional[StrictInt] = Field(default=None, alias="Order")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    owner_id: Optional[StrictInt] = Field(default=None, alias="OwnerId")
    migrated: Optional[StrictInt] = Field(default=None, alias="Migrated")
    schedule_xml: Optional[StrictStr] = Field(default=None, alias="ScheduleXML")
    configuration: Optional[ScheduleConfiguration] = Field(default=None, alias="Configuration")
    __properties: ClassVar[List[str]] = ["Id", "Order", "Name", "OwnerId", "Migrated", "ScheduleXML", "Configuration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Schedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of configuration
        if self.configuration:
            _dict['Configuration'] = self.configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Schedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Id": obj.get("Id"),
            "Order": obj.get("Order"),
            "Name": obj.get("Name"),
            "OwnerId": obj.get("OwnerId"),
            "Migrated": obj.get("Migrated"),
            "ScheduleXML": obj.get("ScheduleXML"),
            "Configuration": ScheduleConfiguration.from_dict(obj["Configuration"]) if obj.get("Configuration") is not None else None
        })
        return _obj


