# coding: utf-8

"""
    Import and Export API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: importexport
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.importexport.models.execution_option import ExecutionOption
from linnworks_api.generated.importexport.models.import_column import ImportColumn
from linnworks_api.generated.importexport.models.import_generic_feed import ImportGenericFeed
from typing import Optional, Set
from typing_extensions import Self

class SpecificationImportGenericFeedImportColumn(BaseModel):
    """
    SpecificationImportGenericFeedImportColumn
    """ # noqa: E501
    feed: Optional[ImportGenericFeed] = Field(default=None, alias="Feed")
    column_mappings: Optional[List[ImportColumn]] = Field(default=None, alias="ColumnMappings")
    execution_options: Optional[List[ExecutionOption]] = Field(default=None, alias="ExecutionOptions")
    __properties: ClassVar[List[str]] = ["Feed", "ColumnMappings", "ExecutionOptions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpecificationImportGenericFeedImportColumn from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of feed
        if self.feed:
            _dict['Feed'] = self.feed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in column_mappings (list)
        _items = []
        if self.column_mappings:
            for _item_column_mappings in self.column_mappings:
                if _item_column_mappings:
                    _items.append(_item_column_mappings.to_dict())
            _dict['ColumnMappings'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in execution_options (list)
        _items = []
        if self.execution_options:
            for _item_execution_options in self.execution_options:
                if _item_execution_options:
                    _items.append(_item_execution_options.to_dict())
            _dict['ExecutionOptions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpecificationImportGenericFeedImportColumn from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Feed": ImportGenericFeed.from_dict(obj["Feed"]) if obj.get("Feed") is not None else None,
            "ColumnMappings": [ImportColumn.from_dict(_item) for _item in obj["ColumnMappings"]] if obj.get("ColumnMappings") is not None else None,
            "ExecutionOptions": [ExecutionOption.from_dict(_item) for _item in obj["ExecutionOptions"]] if obj.get("ExecutionOptions") is not None else None
        })
        return _obj


