# linnworks_api.generated.inventory.InventoryApi

All URIs are relative to *https://eu-ext.linnworks.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**add_image_to_inventory_item**](InventoryApi.md#add_image_to_inventory_item) | **POST** /api/Inventory/AddImageToInventoryItem | AddImageToInventoryItem
[**add_inventory_item**](InventoryApi.md#add_inventory_item) | **POST** /api/Inventory/AddInventoryItem | AddInventoryItem
[**add_inventory_item_bulk**](InventoryApi.md#add_inventory_item_bulk) | **POST** /api/Inventory/AddInventoryItemBulk | AddInventoryItemBulk
[**add_item_locations**](InventoryApi.md#add_item_locations) | **POST** /api/Inventory/AddItemLocations | AddItemLocations
[**add_product_identifiers**](InventoryApi.md#add_product_identifiers) | **POST** /api/Inventory/AddProductIdentifiers | AddProductIdentifiers
[**add_scrap_categories**](InventoryApi.md#add_scrap_categories) | **POST** /api/Inventory/AddScrapCategories | AddScrapCategories
[**add_scrap_item**](InventoryApi.md#add_scrap_item) | **POST** /api/Inventory/AddScrapItem | AddScrapItem
[**add_supplier**](InventoryApi.md#add_supplier) | **POST** /api/Inventory/AddSupplier | AddSupplier
[**adjust_templates_instant**](InventoryApi.md#adjust_templates_instant) | **POST** /api/Inventory/AdjustTemplatesInstant | AdjustTemplatesInstant
[**archive_inventory_items**](InventoryApi.md#archive_inventory_items) | **POST** /api/Inventory/ArchiveInventoryItems | ArchiveInventoryItems
[**batch_get_inventory_item_channel_skus**](InventoryApi.md#batch_get_inventory_item_channel_skus) | **POST** /api/Inventory/BatchGetInventoryItemChannelSKUs | BatchGetInventoryItemChannelSKUs
[**bulk_scrap_batched_items**](InventoryApi.md#bulk_scrap_batched_items) | **POST** /api/Inventory/BulkScrapBatchedItems | BulkScrapBatchedItems
[**create_batches**](InventoryApi.md#create_batches) | **POST** /api/Inventory/CreateBatches | CreateBatches
[**create_category**](InventoryApi.md#create_category) | **POST** /api/Inventory/CreateCategory | CreateCategory
[**create_countries**](InventoryApi.md#create_countries) | **POST** /api/Inventory/CreateCountries | CreateCountries
[**create_country_regions**](InventoryApi.md#create_country_regions) | **POST** /api/Inventory/CreateCountryRegions | CreateCountryRegions
[**create_inventory_item_channel_skus**](InventoryApi.md#create_inventory_item_channel_skus) | **POST** /api/Inventory/CreateInventoryItemChannelSKUs | CreateInventoryItemChannelSKUs
[**create_inventory_item_compositions**](InventoryApi.md#create_inventory_item_compositions) | **POST** /api/Inventory/CreateInventoryItemCompositions | CreateInventoryItemCompositions
[**create_inventory_item_descriptions**](InventoryApi.md#create_inventory_item_descriptions) | **POST** /api/Inventory/CreateInventoryItemDescriptions | CreateInventoryItemDescriptions
[**create_inventory_item_extended_properties**](InventoryApi.md#create_inventory_item_extended_properties) | **POST** /api/Inventory/CreateInventoryItemExtendedProperties | CreateInventoryItemExtendedProperties
[**create_inventory_item_prices**](InventoryApi.md#create_inventory_item_prices) | **POST** /api/Inventory/CreateInventoryItemPrices | CreateInventoryItemPrices
[**create_inventory_item_pricing_rules**](InventoryApi.md#create_inventory_item_pricing_rules) | **POST** /api/Inventory/CreateInventoryItemPricingRules | CreateInventoryItemPricingRules
[**create_inventory_item_titles**](InventoryApi.md#create_inventory_item_titles) | **POST** /api/Inventory/CreateInventoryItemTitles | CreateInventoryItemTitles
[**create_stock_supplier_stat**](InventoryApi.md#create_stock_supplier_stat) | **POST** /api/Inventory/CreateStockSupplierStat | CreateStockSupplierStat
[**create_user_specific_view**](InventoryApi.md#create_user_specific_view) | **POST** /api/Inventory/CreateUserSpecificView | CreateUserSpecificView
[**delete_batch_inventory_in_bulk**](InventoryApi.md#delete_batch_inventory_in_bulk) | **POST** /api/Inventory/DeleteBatchInventoryInBulk | DeleteBatchInventoryInBulk
[**delete_batches_by_stock_item_id**](InventoryApi.md#delete_batches_by_stock_item_id) | **POST** /api/Inventory/DeleteBatchesByStockItemId | DeleteBatchesByStockItemId
[**delete_category_by_id**](InventoryApi.md#delete_category_by_id) | **POST** /api/Inventory/DeleteCategoryById | DeleteCategoryById
[**delete_countries**](InventoryApi.md#delete_countries) | **POST** /api/Inventory/DeleteCountries | DeleteCountries
[**delete_ebay_compatibility_list**](InventoryApi.md#delete_ebay_compatibility_list) | **POST** /api/Inventory/DeleteEbayCompatibilityList | DeleteEbayCompatibilityList
[**delete_images_from_inventory_item**](InventoryApi.md#delete_images_from_inventory_item) | **POST** /api/Inventory/DeleteImagesFromInventoryItem | DeleteImagesFromInventoryItem
[**delete_inventory_item_bulk**](InventoryApi.md#delete_inventory_item_bulk) | **POST** /api/Inventory/DeleteInventoryItemBulk | DeleteInventoryItemBulk
[**delete_inventory_item_channel_skus**](InventoryApi.md#delete_inventory_item_channel_skus) | **POST** /api/Inventory/DeleteInventoryItemChannelSKUs | DeleteInventoryItemChannelSKUs
[**delete_inventory_item_compositions**](InventoryApi.md#delete_inventory_item_compositions) | **POST** /api/Inventory/DeleteInventoryItemCompositions | DeleteInventoryItemCompositions
[**delete_inventory_item_descriptions**](InventoryApi.md#delete_inventory_item_descriptions) | **POST** /api/Inventory/DeleteInventoryItemDescriptions | DeleteInventoryItemDescriptions
[**delete_inventory_item_extended_properties**](InventoryApi.md#delete_inventory_item_extended_properties) | **POST** /api/Inventory/DeleteInventoryItemExtendedProperties | DeleteInventoryItemExtendedProperties
[**delete_inventory_item_image_bulk**](InventoryApi.md#delete_inventory_item_image_bulk) | **POST** /api/Inventory/DeleteInventoryItemImageBulk | DeleteInventoryItemImageBulk
[**delete_inventory_item_prices**](InventoryApi.md#delete_inventory_item_prices) | **POST** /api/Inventory/DeleteInventoryItemPrices | DeleteInventoryItemPrices
[**delete_inventory_item_pricing_rules**](InventoryApi.md#delete_inventory_item_pricing_rules) | **POST** /api/Inventory/DeleteInventoryItemPricingRules | DeleteInventoryItemPricingRules
[**delete_inventory_item_titles**](InventoryApi.md#delete_inventory_item_titles) | **POST** /api/Inventory/DeleteInventoryItemTitles | DeleteInventoryItemTitles
[**delete_inventory_items**](InventoryApi.md#delete_inventory_items) | **POST** /api/Inventory/DeleteInventoryItems | DeleteInventoryItems
[**delete_item_locations**](InventoryApi.md#delete_item_locations) | **POST** /api/Inventory/DeleteItemLocations | DeleteItemLocations
[**delete_product_identifiers**](InventoryApi.md#delete_product_identifiers) | **POST** /api/Inventory/DeleteProductIdentifiers | DeleteProductIdentifiers
[**delete_scrap_categories**](InventoryApi.md#delete_scrap_categories) | **POST** /api/Inventory/DeleteScrapCategories | DeleteScrapCategories
[**delete_stock_supplier_stat**](InventoryApi.md#delete_stock_supplier_stat) | **POST** /api/Inventory/DeleteStockSupplierStat | DeleteStockSupplierStat
[**delete_suppliers**](InventoryApi.md#delete_suppliers) | **POST** /api/Inventory/DeleteSuppliers | DeleteSuppliers
[**delete_user_specific_view**](InventoryApi.md#delete_user_specific_view) | **POST** /api/Inventory/DeleteUserSpecificView | DeleteUserSpecificView
[**duplicate_inventory_item**](InventoryApi.md#duplicate_inventory_item) | **POST** /api/Inventory/DuplicateInventoryItem | DuplicateInventoryItem
[**get_all_extended_property_names**](InventoryApi.md#get_all_extended_property_names) | **GET** /api/Inventory/GetAllExtendedPropertyNames | GetAllExtendedPropertyNames
[**get_batch_audit**](InventoryApi.md#get_batch_audit) | **POST** /api/Inventory/GetBatchAudit | GetBatchAudit
[**get_batch_inventory_by_id**](InventoryApi.md#get_batch_inventory_by_id) | **POST** /api/Inventory/GetBatchInventoryById | GetBatchInventoryById
[**get_batches_by_stock_item_id**](InventoryApi.md#get_batches_by_stock_item_id) | **GET** /api/Inventory/GetBatchesByStockItemId | GetBatchesByStockItemId
[**get_categories**](InventoryApi.md#get_categories) | **GET** /api/Inventory/GetCategories | GetCategories
[**get_channels**](InventoryApi.md#get_channels) | **GET** /api/Inventory/GetChannels | GetChannels
[**get_channels_by_source**](InventoryApi.md#get_channels_by_source) | **GET** /api/Inventory/GetChannelsBySource | GetChannelsBySource
[**get_countries**](InventoryApi.md#get_countries) | **GET** /api/Inventory/GetCountries | GetCountries
[**get_country_codes**](InventoryApi.md#get_country_codes) | **GET** /api/Inventory/GetCountryCodes | GetCountryCodes
[**get_ebay_compatibility_list**](InventoryApi.md#get_ebay_compatibility_list) | **GET** /api/Inventory/GetEbayCompatibilityList | GetEbayCompatibilityList
[**get_extended_property_names**](InventoryApi.md#get_extended_property_names) | **GET** /api/Inventory/GetExtendedPropertyNames | GetExtendedPropertyNames
[**get_extended_property_types**](InventoryApi.md#get_extended_property_types) | **GET** /api/Inventory/GetExtendedPropertyTypes | GetExtendedPropertyTypes
[**get_images_in_bulk**](InventoryApi.md#get_images_in_bulk) | **POST** /api/Inventory/GetImagesInBulk | GetImagesInBulk
[**get_inventory_batch_types**](InventoryApi.md#get_inventory_batch_types) | **GET** /api/Inventory/GetInventoryBatchTypes | GetInventoryBatchTypes
[**get_inventory_item_audit_trail**](InventoryApi.md#get_inventory_item_audit_trail) | **GET** /api/Inventory/GetInventoryItemAuditTrail | GetInventoryItemAuditTrail
[**get_inventory_item_audit_trail_paged**](InventoryApi.md#get_inventory_item_audit_trail_paged) | **POST** /api/Inventory/GetInventoryItemAuditTrailPaged | GetInventoryItemAuditTrailPaged
[**get_inventory_item_batch_information**](InventoryApi.md#get_inventory_item_batch_information) | **POST** /api/Inventory/GetInventoryItemBatchInformation | GetInventoryItemBatchInformation
[**get_inventory_item_batch_information_by_ids**](InventoryApi.md#get_inventory_item_batch_information_by_ids) | **POST** /api/Inventory/GetInventoryItemBatchInformationByIds | GetInventoryItemBatchInformationByIds
[**get_inventory_item_by_id**](InventoryApi.md#get_inventory_item_by_id) | **GET** /api/Inventory/GetInventoryItemById | GetInventoryItemById
[**get_inventory_item_channel_skus**](InventoryApi.md#get_inventory_item_channel_skus) | **GET** /api/Inventory/GetInventoryItemChannelSKUs | GetInventoryItemChannelSKUs
[**get_inventory_item_channel_skus_with_location**](InventoryApi.md#get_inventory_item_channel_skus_with_location) | **GET** /api/Inventory/GetInventoryItemChannelSKUsWithLocation | GetInventoryItemChannelSKUsWithLocation
[**get_inventory_item_compositions**](InventoryApi.md#get_inventory_item_compositions) | **GET** /api/Inventory/GetInventoryItemCompositions | GetInventoryItemCompositions
[**get_inventory_item_descriptions**](InventoryApi.md#get_inventory_item_descriptions) | **GET** /api/Inventory/GetInventoryItemDescriptions | GetInventoryItemDescriptions
[**get_inventory_item_extended_properties**](InventoryApi.md#get_inventory_item_extended_properties) | **POST** /api/Inventory/GetInventoryItemExtendedProperties | GetInventoryItemExtendedProperties
[**get_inventory_item_images**](InventoryApi.md#get_inventory_item_images) | **GET** /api/Inventory/GetInventoryItemImages | GetInventoryItemImages
[**get_inventory_item_locations**](InventoryApi.md#get_inventory_item_locations) | **GET** /api/Inventory/GetInventoryItemLocations | GetInventoryItemLocations
[**get_inventory_item_price_channel_suffixes**](InventoryApi.md#get_inventory_item_price_channel_suffixes) | **GET** /api/Inventory/GetInventoryItemPriceChannelSuffixes | GetInventoryItemPriceChannelSuffixes
[**get_inventory_item_price_rules_by_id**](InventoryApi.md#get_inventory_item_price_rules_by_id) | **GET** /api/Inventory/GetInventoryItemPriceRulesById | GetInventoryItemPriceRulesById
[**get_inventory_item_price_rules_by_source**](InventoryApi.md#get_inventory_item_price_rules_by_source) | **GET** /api/Inventory/GetInventoryItemPriceRulesBySource | GetInventoryItemPriceRulesBySource
[**get_inventory_item_price_tags**](InventoryApi.md#get_inventory_item_price_tags) | **GET** /api/Inventory/GetInventoryItemPriceTags | GetInventoryItemPriceTags
[**get_inventory_item_prices**](InventoryApi.md#get_inventory_item_prices) | **GET** /api/Inventory/GetInventoryItemPrices | GetInventoryItemPrices
[**get_inventory_item_titles**](InventoryApi.md#get_inventory_item_titles) | **GET** /api/Inventory/GetInventoryItemTitles | GetInventoryItemTitles
[**get_inventory_items_composition_by_ids**](InventoryApi.md#get_inventory_items_composition_by_ids) | **POST** /api/Inventory/GetInventoryItemsCompositionByIds | GetInventoryItemsCompositionByIds
[**get_inventory_items_count**](InventoryApi.md#get_inventory_items_count) | **GET** /api/Inventory/GetInventoryItemsCount | GetInventoryItemsCount
[**get_new_item_number**](InventoryApi.md#get_new_item_number) | **GET** /api/Inventory/GetNewItemNumber | GetNewItemNumber
[**get_package_groups**](InventoryApi.md#get_package_groups) | **GET** /api/Inventory/GetPackageGroups | GetPackageGroups
[**get_postal_services**](InventoryApi.md#get_postal_services) | **GET** /api/Inventory/GetPostalServices | GetPostalServices
[**get_pre_defined_views**](InventoryApi.md#get_pre_defined_views) | **GET** /api/Inventory/GetPreDefinedViews | GetPreDefinedViews
[**get_product_identifier_extended_types**](InventoryApi.md#get_product_identifier_extended_types) | **GET** /api/Inventory/GetProductIdentifierExtendedTypes | GetProductIdentifierExtendedTypes
[**get_product_identifier_types**](InventoryApi.md#get_product_identifier_types) | **GET** /api/Inventory/GetProductIdentifierTypes | GetProductIdentifierTypes
[**get_product_identifiers_bulk_by_stock_item_id**](InventoryApi.md#get_product_identifiers_bulk_by_stock_item_id) | **POST** /api/Inventory/GetProductIdentifiersBulkByStockItemId | GetProductIdentifiersBulkByStockItemId
[**get_product_identifiers_by_stock_item_id**](InventoryApi.md#get_product_identifiers_by_stock_item_id) | **POST** /api/Inventory/GetProductIdentifiersByStockItemId | GetProductIdentifiersByStockItemId
[**get_scannable_product_identifiers_by_order_ids**](InventoryApi.md#get_scannable_product_identifiers_by_order_ids) | **POST** /api/Inventory/GetScannableProductIdentifiersByOrderIds | GetScannableProductIdentifiersByOrderIds
[**get_scrap_categories**](InventoryApi.md#get_scrap_categories) | **GET** /api/Inventory/GetScrapCategories | GetScrapCategories
[**get_scrap_history**](InventoryApi.md#get_scrap_history) | **POST** /api/Inventory/GetScrapHistory | GetScrapHistory
[**get_stock_item_batches_by_location**](InventoryApi.md#get_stock_item_batches_by_location) | **POST** /api/Inventory/GetStockItemBatchesByLocation | GetStockItemBatchesByLocation
[**get_stock_item_ids_by_sku**](InventoryApi.md#get_stock_item_ids_by_sku) | **POST** /api/Inventory/GetStockItemIdsBySKU | GetStockItemIdsBySKU
[**get_stock_item_labels**](InventoryApi.md#get_stock_item_labels) | **POST** /api/Inventory/GetStockItemLabels | GetStockItemLabels
[**get_stock_locations**](InventoryApi.md#get_stock_locations) | **GET** /api/Inventory/GetStockLocations | GetStockLocations
[**get_stock_supplier_stat**](InventoryApi.md#get_stock_supplier_stat) | **GET** /api/Inventory/GetStockSupplierStat | GetStockSupplierStat
[**get_stock_supplier_stats_bulk**](InventoryApi.md#get_stock_supplier_stats_bulk) | **GET** /api/Inventory/GetStockSupplierStatsBulk | GetStockSupplierStatsBulk
[**get_supplier_details**](InventoryApi.md#get_supplier_details) | **GET** /api/Inventory/GetSupplierDetails | GetSupplierDetails
[**get_suppliers**](InventoryApi.md#get_suppliers) | **GET** /api/Inventory/GetSuppliers | GetSuppliers
[**get_user_specific_views**](InventoryApi.md#get_user_specific_views) | **GET** /api/Inventory/GetUserSpecificViews | GetUserSpecificViews
[**has_stock_item_batches**](InventoryApi.md#has_stock_item_batches) | **GET** /api/Inventory/HasStockItemBatches | HasStockItemBatches
[**has_stock_item_stock_level**](InventoryApi.md#has_stock_item_stock_level) | **POST** /api/Inventory/HasStockItemStockLevel | HasStockItemStockLevel
[**insert_update_ebay_compatibility_list**](InventoryApi.md#insert_update_ebay_compatibility_list) | **POST** /api/Inventory/InsertUpdateEbayCompatibilityList | InsertUpdateEbayCompatibilityList
[**is_inventory_item_channel_sku_linked**](InventoryApi.md#is_inventory_item_channel_sku_linked) | **GET** /api/Inventory/IsInventoryItemChannelSKULinked | IsInventoryItemChannelSKULinked
[**is_owned_stock_location**](InventoryApi.md#is_owned_stock_location) | **GET** /api/Inventory/IsOwnedStockLocation | IsOwnedStockLocation
[**scrap_batched_item**](InventoryApi.md#scrap_batched_item) | **POST** /api/Inventory/ScrapBatchedItem | ScrapBatchedItem
[**set_inventory_item_image_as_main**](InventoryApi.md#set_inventory_item_image_as_main) | **POST** /api/Inventory/SetInventoryItemImageAsMain | SetInventoryItemImageAsMain
[**unarchive_inventory_items**](InventoryApi.md#unarchive_inventory_items) | **POST** /api/Inventory/UnarchiveInventoryItems | UnarchiveInventoryItems
[**unlink_channel_listing**](InventoryApi.md#unlink_channel_listing) | **POST** /api/Inventory/UnlinkChannelListing | UnlinkChannelListing
[**update_batch_dates**](InventoryApi.md#update_batch_dates) | **POST** /api/Inventory/UpdateBatchDates | UpdateBatchDates
[**update_batch_details**](InventoryApi.md#update_batch_details) | **POST** /api/Inventory/UpdateBatchDetails | UpdateBatchDetails
[**update_batches_with_inventory**](InventoryApi.md#update_batches_with_inventory) | **POST** /api/Inventory/UpdateBatchesWithInventory | UpdateBatchesWithInventory
[**update_category**](InventoryApi.md#update_category) | **POST** /api/Inventory/UpdateCategory | UpdateCategory
[**update_composite_parent_stock_level**](InventoryApi.md#update_composite_parent_stock_level) | **POST** /api/Inventory/UpdateCompositeParentStockLevel | UpdateCompositeParentStockLevel
[**update_countries**](InventoryApi.md#update_countries) | **POST** /api/Inventory/UpdateCountries | UpdateCountries
[**update_country_regions**](InventoryApi.md#update_country_regions) | **POST** /api/Inventory/UpdateCountryRegions | UpdateCountryRegions
[**update_images**](InventoryApi.md#update_images) | **POST** /api/Inventory/UpdateImages | UpdateImages
[**update_inventory_item**](InventoryApi.md#update_inventory_item) | **POST** /api/Inventory/UpdateInventoryItem | UpdateInventoryItem
[**update_inventory_item_channel_skus**](InventoryApi.md#update_inventory_item_channel_skus) | **POST** /api/Inventory/UpdateInventoryItemChannelSKUs | UpdateInventoryItemChannelSKUs
[**update_inventory_item_channel_skus_with_location**](InventoryApi.md#update_inventory_item_channel_skus_with_location) | **POST** /api/Inventory/UpdateInventoryItemChannelSKUsWithLocation | UpdateInventoryItemChannelSKUsWithLocation
[**update_inventory_item_compositions**](InventoryApi.md#update_inventory_item_compositions) | **POST** /api/Inventory/UpdateInventoryItemCompositions | UpdateInventoryItemCompositions
[**update_inventory_item_descriptions**](InventoryApi.md#update_inventory_item_descriptions) | **POST** /api/Inventory/UpdateInventoryItemDescriptions | UpdateInventoryItemDescriptions
[**update_inventory_item_extended_properties**](InventoryApi.md#update_inventory_item_extended_properties) | **POST** /api/Inventory/UpdateInventoryItemExtendedProperties | UpdateInventoryItemExtendedProperties
[**update_inventory_item_field**](InventoryApi.md#update_inventory_item_field) | **POST** /api/Inventory/UpdateInventoryItemField | UpdateInventoryItemField
[**update_inventory_item_levels**](InventoryApi.md#update_inventory_item_levels) | **POST** /api/Inventory/UpdateInventoryItemLevels | UpdateInventoryItemLevels
[**update_inventory_item_location_field**](InventoryApi.md#update_inventory_item_location_field) | **POST** /api/Inventory/UpdateInventoryItemLocationField | UpdateInventoryItemLocationField
[**update_inventory_item_prices**](InventoryApi.md#update_inventory_item_prices) | **POST** /api/Inventory/UpdateInventoryItemPrices | UpdateInventoryItemPrices
[**update_inventory_item_pricing_rules**](InventoryApi.md#update_inventory_item_pricing_rules) | **POST** /api/Inventory/UpdateInventoryItemPricingRules | UpdateInventoryItemPricingRules
[**update_inventory_item_stock_field**](InventoryApi.md#update_inventory_item_stock_field) | **POST** /api/Inventory/UpdateInventoryItemStockField | UpdateInventoryItemStockField
[**update_inventory_item_titles**](InventoryApi.md#update_inventory_item_titles) | **POST** /api/Inventory/UpdateInventoryItemTitles | UpdateInventoryItemTitles
[**update_item_locations**](InventoryApi.md#update_item_locations) | **POST** /api/Inventory/UpdateItemLocations | UpdateItemLocations
[**update_product_identifiers**](InventoryApi.md#update_product_identifiers) | **POST** /api/Inventory/UpdateProductIdentifiers | UpdateProductIdentifiers
[**update_scrap_categories**](InventoryApi.md#update_scrap_categories) | **POST** /api/Inventory/UpdateScrapCategories | UpdateScrapCategories
[**update_stock_supplier_stat**](InventoryApi.md#update_stock_supplier_stat) | **POST** /api/Inventory/UpdateStockSupplierStat | UpdateStockSupplierStat
[**update_supplier**](InventoryApi.md#update_supplier) | **POST** /api/Inventory/UpdateSupplier | UpdateSupplier
[**update_user_specific_view**](InventoryApi.md#update_user_specific_view) | **POST** /api/Inventory/UpdateUserSpecificView | UpdateUserSpecificView
[**upload_images_to_inventory_item**](InventoryApi.md#upload_images_to_inventory_item) | **POST** /api/Inventory/UploadImagesToInventoryItem | UploadImagesToInventoryItem


# **add_image_to_inventory_item**
> AddImageToInventoryItemResponse add_image_to_inventory_item(inventory_add_image_to_inventory_item_request)

AddImageToInventoryItem

Adds an image to the stock item <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.add_image_to_inventory_item_response import AddImageToInventoryItemResponse
from linnworks_api.generated.inventory.models.inventory_add_image_to_inventory_item_request import InventoryAddImageToInventoryItemRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_add_image_to_inventory_item_request = linnworks_api.generated.inventory.InventoryAddImageToInventoryItemRequest() # InventoryAddImageToInventoryItemRequest | 

    try:
        # AddImageToInventoryItem
        api_response = api_instance.add_image_to_inventory_item(inventory_add_image_to_inventory_item_request)
        print("The response of InventoryApi->add_image_to_inventory_item:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->add_image_to_inventory_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_add_image_to_inventory_item_request** | [**InventoryAddImageToInventoryItemRequest**](InventoryAddImageToInventoryItemRequest.md)|  | 

### Return type

[**AddImageToInventoryItemResponse**](AddImageToInventoryItemResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_inventory_item**
> add_inventory_item(inventory_add_inventory_item_request)

AddInventoryItem

Use this call to add stock item. <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_add_inventory_item_request import InventoryAddInventoryItemRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_add_inventory_item_request = linnworks_api.generated.inventory.InventoryAddInventoryItemRequest() # InventoryAddInventoryItemRequest | 

    try:
        # AddInventoryItem
        api_instance.add_inventory_item(inventory_add_inventory_item_request)
    except Exception as e:
        print("Exception when calling InventoryApi->add_inventory_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_add_inventory_item_request** | [**InventoryAddInventoryItemRequest**](InventoryAddInventoryItemRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_inventory_item_bulk**
> BatchedAPIResponseGuid add_inventory_item_bulk(inventory_add_inventory_item_bulk_request)

AddInventoryItemBulk

Use this call to add up to 200 stock items. <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.batched_api_response_guid import BatchedAPIResponseGuid
from linnworks_api.generated.inventory.models.inventory_add_inventory_item_bulk_request import InventoryAddInventoryItemBulkRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_add_inventory_item_bulk_request = linnworks_api.generated.inventory.InventoryAddInventoryItemBulkRequest() # InventoryAddInventoryItemBulkRequest | 

    try:
        # AddInventoryItemBulk
        api_response = api_instance.add_inventory_item_bulk(inventory_add_inventory_item_bulk_request)
        print("The response of InventoryApi->add_inventory_item_bulk:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->add_inventory_item_bulk: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_add_inventory_item_bulk_request** | [**InventoryAddInventoryItemBulkRequest**](InventoryAddInventoryItemBulkRequest.md)|  | 

### Return type

[**BatchedAPIResponseGuid**](BatchedAPIResponseGuid.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_item_locations**
> add_item_locations(inventory_add_item_locations_request)

AddItemLocations

Use this call to add stock item locations bin/rack <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemBinRackNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_add_item_locations_request import InventoryAddItemLocationsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_add_item_locations_request = linnworks_api.generated.inventory.InventoryAddItemLocationsRequest() # InventoryAddItemLocationsRequest | 

    try:
        # AddItemLocations
        api_instance.add_item_locations(inventory_add_item_locations_request)
    except Exception as e:
        print("Exception when calling InventoryApi->add_item_locations: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_add_item_locations_request** | [**InventoryAddItemLocationsRequest**](InventoryAddItemLocationsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_product_identifiers**
> BatchedAPIResponseStockItemProductIdentifier add_product_identifiers(inventory_add_product_identifiers_request)

AddProductIdentifiers

Used to add product identifiers <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.batched_api_response_stock_item_product_identifier import BatchedAPIResponseStockItemProductIdentifier
from linnworks_api.generated.inventory.models.inventory_add_product_identifiers_request import InventoryAddProductIdentifiersRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_add_product_identifiers_request = linnworks_api.generated.inventory.InventoryAddProductIdentifiersRequest() # InventoryAddProductIdentifiersRequest | 

    try:
        # AddProductIdentifiers
        api_response = api_instance.add_product_identifiers(inventory_add_product_identifiers_request)
        print("The response of InventoryApi->add_product_identifiers:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->add_product_identifiers: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_add_product_identifiers_request** | [**InventoryAddProductIdentifiersRequest**](InventoryAddProductIdentifiersRequest.md)|  | 

### Return type

[**BatchedAPIResponseStockItemProductIdentifier**](BatchedAPIResponseStockItemProductIdentifier.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_scrap_categories**
> AddScrapCategoriesResponse add_scrap_categories(inventory_add_scrap_categories_request)

AddScrapCategories

Used to add scrap categories <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapCategoriesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.add_scrap_categories_response import AddScrapCategoriesResponse
from linnworks_api.generated.inventory.models.inventory_add_scrap_categories_request import InventoryAddScrapCategoriesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_add_scrap_categories_request = linnworks_api.generated.inventory.InventoryAddScrapCategoriesRequest() # InventoryAddScrapCategoriesRequest | 

    try:
        # AddScrapCategories
        api_response = api_instance.add_scrap_categories(inventory_add_scrap_categories_request)
        print("The response of InventoryApi->add_scrap_categories:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->add_scrap_categories: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_add_scrap_categories_request** | [**InventoryAddScrapCategoriesRequest**](InventoryAddScrapCategoriesRequest.md)|  | 

### Return type

[**AddScrapCategoriesResponse**](AddScrapCategoriesResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_scrap_item**
> AddScrapItemResponse add_scrap_item(inventory_add_scrap_item_request)

AddScrapItem

Used to add scrap item <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapStockNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.add_scrap_item_response import AddScrapItemResponse
from linnworks_api.generated.inventory.models.inventory_add_scrap_item_request import InventoryAddScrapItemRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_add_scrap_item_request = linnworks_api.generated.inventory.InventoryAddScrapItemRequest() # InventoryAddScrapItemRequest | 

    try:
        # AddScrapItem
        api_response = api_instance.add_scrap_item(inventory_add_scrap_item_request)
        print("The response of InventoryApi->add_scrap_item:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->add_scrap_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_add_scrap_item_request** | [**InventoryAddScrapItemRequest**](InventoryAddScrapItemRequest.md)|  | 

### Return type

[**AddScrapItemResponse**](AddScrapItemResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_supplier**
> Supplier add_supplier(inventory_add_supplier_request)

AddSupplier

Use this call to create a new supplier <b>Permissions Required: </b> GlobalPermissions.Inventory.InventorySettings.SuppliersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_add_supplier_request import InventoryAddSupplierRequest
from linnworks_api.generated.inventory.models.supplier import Supplier
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_add_supplier_request = linnworks_api.generated.inventory.InventoryAddSupplierRequest() # InventoryAddSupplierRequest | 

    try:
        # AddSupplier
        api_response = api_instance.add_supplier(inventory_add_supplier_request)
        print("The response of InventoryApi->add_supplier:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->add_supplier: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_add_supplier_request** | [**InventoryAddSupplierRequest**](InventoryAddSupplierRequest.md)|  | 

### Return type

[**Supplier**](Supplier.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **adjust_templates_instant**
> adjust_templates_instant(inventory_adjust_templates_instant_request)

AdjustTemplatesInstant

Use this call to adjust templates <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_adjust_templates_instant_request import InventoryAdjustTemplatesInstantRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_adjust_templates_instant_request = linnworks_api.generated.inventory.InventoryAdjustTemplatesInstantRequest() # InventoryAdjustTemplatesInstantRequest | 

    try:
        # AdjustTemplatesInstant
        api_instance.adjust_templates_instant(inventory_adjust_templates_instant_request)
    except Exception as e:
        print("Exception when calling InventoryApi->adjust_templates_instant: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_adjust_templates_instant_request** | [**InventoryAdjustTemplatesInstantRequest**](InventoryAdjustTemplatesInstantRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **archive_inventory_items**
> archive_inventory_items(inventory_archive_inventory_items_request)

ArchiveInventoryItems

Use this call to archive inventory items. Send only list of IDs and empty list of regions. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_archive_inventory_items_request import InventoryArchiveInventoryItemsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_archive_inventory_items_request = linnworks_api.generated.inventory.InventoryArchiveInventoryItemsRequest() # InventoryArchiveInventoryItemsRequest | 

    try:
        # ArchiveInventoryItems
        api_instance.archive_inventory_items(inventory_archive_inventory_items_request)
    except Exception as e:
        print("Exception when calling InventoryApi->archive_inventory_items: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_archive_inventory_items_request** | [**InventoryArchiveInventoryItemsRequest**](InventoryArchiveInventoryItemsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **batch_get_inventory_item_channel_skus**
> List[StockItemChannelSkuResponse] batch_get_inventory_item_channel_skus(inventory_batch_get_inventory_item_channel_skus_request)

BatchGetInventoryItemChannelSKUs

Use this call to get stock item channel skus for a list of inventory items <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_batch_get_inventory_item_channel_skus_request import InventoryBatchGetInventoryItemChannelSKUsRequest
from linnworks_api.generated.inventory.models.stock_item_channel_sku_response import StockItemChannelSkuResponse
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_batch_get_inventory_item_channel_skus_request = linnworks_api.generated.inventory.InventoryBatchGetInventoryItemChannelSKUsRequest() # InventoryBatchGetInventoryItemChannelSKUsRequest | 

    try:
        # BatchGetInventoryItemChannelSKUs
        api_response = api_instance.batch_get_inventory_item_channel_skus(inventory_batch_get_inventory_item_channel_skus_request)
        print("The response of InventoryApi->batch_get_inventory_item_channel_skus:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->batch_get_inventory_item_channel_skus: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_batch_get_inventory_item_channel_skus_request** | [**InventoryBatchGetInventoryItemChannelSKUsRequest**](InventoryBatchGetInventoryItemChannelSKUsRequest.md)|  | 

### Return type

[**List[StockItemChannelSkuResponse]**](StockItemChannelSkuResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **bulk_scrap_batched_items**
> bulk_scrap_batched_items(request=request)

BulkScrapBatchedItems

Scrap batched items in bulk without consumption <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapStockNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.bulk_scrap_batched_items_request import BulkScrapBatchedItemsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    request = linnworks_api.generated.inventory.BulkScrapBatchedItemsRequest() # BulkScrapBatchedItemsRequest |  (optional)

    try:
        # BulkScrapBatchedItems
        api_instance.bulk_scrap_batched_items(request=request)
    except Exception as e:
        print("Exception when calling InventoryApi->bulk_scrap_batched_items: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**BulkScrapBatchedItemsRequest**](BulkScrapBatchedItemsRequest.md)|  | [optional] 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_batches**
> create_batches(inventory_create_batches_request)

CreateBatches

Used to create new batches <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_batches_request import InventoryCreateBatchesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_batches_request = linnworks_api.generated.inventory.InventoryCreateBatchesRequest() # InventoryCreateBatchesRequest | 

    try:
        # CreateBatches
        api_instance.create_batches(inventory_create_batches_request)
    except Exception as e:
        print("Exception when calling InventoryApi->create_batches: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_batches_request** | [**InventoryCreateBatchesRequest**](InventoryCreateBatchesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_category**
> LinnworksCategory create_category(inventory_create_category_request)

CreateCategory

Use this call to create new category <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_category_request import InventoryCreateCategoryRequest
from linnworks_api.generated.inventory.models.linnworks_category import LinnworksCategory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_category_request = linnworks_api.generated.inventory.InventoryCreateCategoryRequest() # InventoryCreateCategoryRequest | 

    try:
        # CreateCategory
        api_response = api_instance.create_category(inventory_create_category_request)
        print("The response of InventoryApi->create_category:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->create_category: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_category_request** | [**InventoryCreateCategoryRequest**](InventoryCreateCategoryRequest.md)|  | 

### Return type

[**LinnworksCategory**](LinnworksCategory.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_countries**
> create_countries(inventory_create_countries_request)

CreateCountries

Use this call to create new countries <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_countries_request import InventoryCreateCountriesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_countries_request = linnworks_api.generated.inventory.InventoryCreateCountriesRequest() # InventoryCreateCountriesRequest | 

    try:
        # CreateCountries
        api_instance.create_countries(inventory_create_countries_request)
    except Exception as e:
        print("Exception when calling InventoryApi->create_countries: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_countries_request** | [**InventoryCreateCountriesRequest**](InventoryCreateCountriesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_country_regions**
> CreateCountryRegionsResponse create_country_regions(inventory_create_country_regions_request)

CreateCountryRegions

Create regions for country <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.create_country_regions_response import CreateCountryRegionsResponse
from linnworks_api.generated.inventory.models.inventory_create_country_regions_request import InventoryCreateCountryRegionsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_country_regions_request = linnworks_api.generated.inventory.InventoryCreateCountryRegionsRequest() # InventoryCreateCountryRegionsRequest | 

    try:
        # CreateCountryRegions
        api_response = api_instance.create_country_regions(inventory_create_country_regions_request)
        print("The response of InventoryApi->create_country_regions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->create_country_regions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_country_regions_request** | [**InventoryCreateCountryRegionsRequest**](InventoryCreateCountryRegionsRequest.md)|  | 

### Return type

[**CreateCountryRegionsResponse**](CreateCountryRegionsResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_inventory_item_channel_skus**
> create_inventory_item_channel_skus(inventory_create_inventory_item_channel_skus_request)

CreateInventoryItemChannelSKUs

Use this call to create stockitem channel skus <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_inventory_item_channel_skus_request import InventoryCreateInventoryItemChannelSKUsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_inventory_item_channel_skus_request = linnworks_api.generated.inventory.InventoryCreateInventoryItemChannelSKUsRequest() # InventoryCreateInventoryItemChannelSKUsRequest | 

    try:
        # CreateInventoryItemChannelSKUs
        api_instance.create_inventory_item_channel_skus(inventory_create_inventory_item_channel_skus_request)
    except Exception as e:
        print("Exception when calling InventoryApi->create_inventory_item_channel_skus: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_inventory_item_channel_skus_request** | [**InventoryCreateInventoryItemChannelSKUsRequest**](InventoryCreateInventoryItemChannelSKUsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_inventory_item_compositions**
> create_inventory_item_compositions(inventory_create_inventory_item_compositions_request)

CreateInventoryItemCompositions

Use this call to create compositions for stockItem <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_inventory_item_compositions_request import InventoryCreateInventoryItemCompositionsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_inventory_item_compositions_request = linnworks_api.generated.inventory.InventoryCreateInventoryItemCompositionsRequest() # InventoryCreateInventoryItemCompositionsRequest | 

    try:
        # CreateInventoryItemCompositions
        api_instance.create_inventory_item_compositions(inventory_create_inventory_item_compositions_request)
    except Exception as e:
        print("Exception when calling InventoryApi->create_inventory_item_compositions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_inventory_item_compositions_request** | [**InventoryCreateInventoryItemCompositionsRequest**](InventoryCreateInventoryItemCompositionsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_inventory_item_descriptions**
> create_inventory_item_descriptions(inventory_create_inventory_item_descriptions_request)

CreateInventoryItemDescriptions

Use this call to create stockitem Descriptions <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_inventory_item_descriptions_request import InventoryCreateInventoryItemDescriptionsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_inventory_item_descriptions_request = linnworks_api.generated.inventory.InventoryCreateInventoryItemDescriptionsRequest() # InventoryCreateInventoryItemDescriptionsRequest | 

    try:
        # CreateInventoryItemDescriptions
        api_instance.create_inventory_item_descriptions(inventory_create_inventory_item_descriptions_request)
    except Exception as e:
        print("Exception when calling InventoryApi->create_inventory_item_descriptions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_inventory_item_descriptions_request** | [**InventoryCreateInventoryItemDescriptionsRequest**](InventoryCreateInventoryItemDescriptionsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_inventory_item_extended_properties**
> create_inventory_item_extended_properties(inventory_create_inventory_item_extended_properties_request)

CreateInventoryItemExtendedProperties

Use this call to create stockitem Extended Properties <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_inventory_item_extended_properties_request import InventoryCreateInventoryItemExtendedPropertiesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_inventory_item_extended_properties_request = linnworks_api.generated.inventory.InventoryCreateInventoryItemExtendedPropertiesRequest() # InventoryCreateInventoryItemExtendedPropertiesRequest | 

    try:
        # CreateInventoryItemExtendedProperties
        api_instance.create_inventory_item_extended_properties(inventory_create_inventory_item_extended_properties_request)
    except Exception as e:
        print("Exception when calling InventoryApi->create_inventory_item_extended_properties: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_inventory_item_extended_properties_request** | [**InventoryCreateInventoryItemExtendedPropertiesRequest**](InventoryCreateInventoryItemExtendedPropertiesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_inventory_item_prices**
> create_inventory_item_prices(inventory_create_inventory_item_prices_request)

CreateInventoryItemPrices

Use this call to create stock item prices for a specific channel <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_inventory_item_prices_request import InventoryCreateInventoryItemPricesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_inventory_item_prices_request = linnworks_api.generated.inventory.InventoryCreateInventoryItemPricesRequest() # InventoryCreateInventoryItemPricesRequest | 

    try:
        # CreateInventoryItemPrices
        api_instance.create_inventory_item_prices(inventory_create_inventory_item_prices_request)
    except Exception as e:
        print("Exception when calling InventoryApi->create_inventory_item_prices: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_inventory_item_prices_request** | [**InventoryCreateInventoryItemPricesRequest**](InventoryCreateInventoryItemPricesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_inventory_item_pricing_rules**
> create_inventory_item_pricing_rules(inventory_create_inventory_item_pricing_rules_request)

CreateInventoryItemPricingRules

Use this call to create stock item price rules <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_inventory_item_pricing_rules_request import InventoryCreateInventoryItemPricingRulesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_inventory_item_pricing_rules_request = linnworks_api.generated.inventory.InventoryCreateInventoryItemPricingRulesRequest() # InventoryCreateInventoryItemPricingRulesRequest | 

    try:
        # CreateInventoryItemPricingRules
        api_instance.create_inventory_item_pricing_rules(inventory_create_inventory_item_pricing_rules_request)
    except Exception as e:
        print("Exception when calling InventoryApi->create_inventory_item_pricing_rules: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_inventory_item_pricing_rules_request** | [**InventoryCreateInventoryItemPricingRulesRequest**](InventoryCreateInventoryItemPricingRulesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_inventory_item_titles**
> create_inventory_item_titles(inventory_create_inventory_item_titles_request)

CreateInventoryItemTitles

Use this call to create stockitem Titles <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_inventory_item_titles_request import InventoryCreateInventoryItemTitlesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_inventory_item_titles_request = linnworks_api.generated.inventory.InventoryCreateInventoryItemTitlesRequest() # InventoryCreateInventoryItemTitlesRequest | 

    try:
        # CreateInventoryItemTitles
        api_instance.create_inventory_item_titles(inventory_create_inventory_item_titles_request)
    except Exception as e:
        print("Exception when calling InventoryApi->create_inventory_item_titles: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_inventory_item_titles_request** | [**InventoryCreateInventoryItemTitlesRequest**](InventoryCreateInventoryItemTitlesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_stock_supplier_stat**
> create_stock_supplier_stat(inventory_create_stock_supplier_stat_request)

CreateStockSupplierStat

Use this call to create item supplier stat <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_stock_supplier_stat_request import InventoryCreateStockSupplierStatRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_stock_supplier_stat_request = linnworks_api.generated.inventory.InventoryCreateStockSupplierStatRequest() # InventoryCreateStockSupplierStatRequest | 

    try:
        # CreateStockSupplierStat
        api_instance.create_stock_supplier_stat(inventory_create_stock_supplier_stat_request)
    except Exception as e:
        print("Exception when calling InventoryApi->create_stock_supplier_stat: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_stock_supplier_stat_request** | [**InventoryCreateStockSupplierStatRequest**](InventoryCreateStockSupplierStatRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_user_specific_view**
> create_user_specific_view(inventory_create_user_specific_view_request)

CreateUserSpecificView

Use this call to create a new user-specific view <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_create_user_specific_view_request import InventoryCreateUserSpecificViewRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_create_user_specific_view_request = linnworks_api.generated.inventory.InventoryCreateUserSpecificViewRequest() # InventoryCreateUserSpecificViewRequest | 

    try:
        # CreateUserSpecificView
        api_instance.create_user_specific_view(inventory_create_user_specific_view_request)
    except Exception as e:
        print("Exception when calling InventoryApi->create_user_specific_view: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_create_user_specific_view_request** | [**InventoryCreateUserSpecificViewRequest**](InventoryCreateUserSpecificViewRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_batch_inventory_in_bulk**
> delete_batch_inventory_in_bulk(inventory_delete_batch_inventory_in_bulk_request)

DeleteBatchInventoryInBulk

Used to delete batch inventory info <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_batch_inventory_in_bulk_request import InventoryDeleteBatchInventoryInBulkRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_batch_inventory_in_bulk_request = linnworks_api.generated.inventory.InventoryDeleteBatchInventoryInBulkRequest() # InventoryDeleteBatchInventoryInBulkRequest | 

    try:
        # DeleteBatchInventoryInBulk
        api_instance.delete_batch_inventory_in_bulk(inventory_delete_batch_inventory_in_bulk_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_batch_inventory_in_bulk: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_batch_inventory_in_bulk_request** | [**InventoryDeleteBatchInventoryInBulkRequest**](InventoryDeleteBatchInventoryInBulkRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_batches_by_stock_item_id**
> delete_batches_by_stock_item_id(inventory_delete_batches_by_stock_item_id_request)

DeleteBatchesByStockItemId

Used to delete batches by stock item id <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_batches_by_stock_item_id_request import InventoryDeleteBatchesByStockItemIdRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_batches_by_stock_item_id_request = linnworks_api.generated.inventory.InventoryDeleteBatchesByStockItemIdRequest() # InventoryDeleteBatchesByStockItemIdRequest | 

    try:
        # DeleteBatchesByStockItemId
        api_instance.delete_batches_by_stock_item_id(inventory_delete_batches_by_stock_item_id_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_batches_by_stock_item_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_batches_by_stock_item_id_request** | [**InventoryDeleteBatchesByStockItemIdRequest**](InventoryDeleteBatchesByStockItemIdRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_category_by_id**
> delete_category_by_id(inventory_delete_category_by_id_request)

DeleteCategoryById

Use this call to delete category by id. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_category_by_id_request import InventoryDeleteCategoryByIdRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_category_by_id_request = linnworks_api.generated.inventory.InventoryDeleteCategoryByIdRequest() # InventoryDeleteCategoryByIdRequest | 

    try:
        # DeleteCategoryById
        api_instance.delete_category_by_id(inventory_delete_category_by_id_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_category_by_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_category_by_id_request** | [**InventoryDeleteCategoryByIdRequest**](InventoryDeleteCategoryByIdRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_countries**
> delete_countries(inventory_delete_countries_request)

DeleteCountries

Use this call to delete countries <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_countries_request import InventoryDeleteCountriesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_countries_request = linnworks_api.generated.inventory.InventoryDeleteCountriesRequest() # InventoryDeleteCountriesRequest | 

    try:
        # DeleteCountries
        api_instance.delete_countries(inventory_delete_countries_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_countries: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_countries_request** | [**InventoryDeleteCountriesRequest**](InventoryDeleteCountriesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_ebay_compatibility_list**
> DeleteEbayCompatibilityListResponse delete_ebay_compatibility_list(inventory_delete_ebay_compatibility_list_request)

DeleteEbayCompatibilityList

Use this call to delete a list of Ebay Compatibility <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.delete_ebay_compatibility_list_response import DeleteEbayCompatibilityListResponse
from linnworks_api.generated.inventory.models.inventory_delete_ebay_compatibility_list_request import InventoryDeleteEbayCompatibilityListRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_ebay_compatibility_list_request = linnworks_api.generated.inventory.InventoryDeleteEbayCompatibilityListRequest() # InventoryDeleteEbayCompatibilityListRequest | 

    try:
        # DeleteEbayCompatibilityList
        api_response = api_instance.delete_ebay_compatibility_list(inventory_delete_ebay_compatibility_list_request)
        print("The response of InventoryApi->delete_ebay_compatibility_list:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_ebay_compatibility_list: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_ebay_compatibility_list_request** | [**InventoryDeleteEbayCompatibilityListRequest**](InventoryDeleteEbayCompatibilityListRequest.md)|  | 

### Return type

[**DeleteEbayCompatibilityListResponse**](DeleteEbayCompatibilityListResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_images_from_inventory_item**
> delete_images_from_inventory_item(inventory_delete_images_from_inventory_item_request)

DeleteImagesFromInventoryItem

Use this call to delete images from inventory items <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_images_from_inventory_item_request import InventoryDeleteImagesFromInventoryItemRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_images_from_inventory_item_request = linnworks_api.generated.inventory.InventoryDeleteImagesFromInventoryItemRequest() # InventoryDeleteImagesFromInventoryItemRequest | 

    try:
        # DeleteImagesFromInventoryItem
        api_instance.delete_images_from_inventory_item(inventory_delete_images_from_inventory_item_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_images_from_inventory_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_images_from_inventory_item_request** | [**InventoryDeleteImagesFromInventoryItemRequest**](InventoryDeleteImagesFromInventoryItemRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_inventory_item_bulk**
> BatchedAPIResponseDeleteInventoryItemBulkResponse delete_inventory_item_bulk(request=request)

DeleteInventoryItemBulk

Use this call to delete inventory items.  All associated information will be unlinked/removed from this stock item. <b>Permissions Required: </b> GlobalPermissions.Inventory.DeleteMyInventoryItems.DeleteItemsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.batched_api_response_delete_inventory_item_bulk_response import BatchedAPIResponseDeleteInventoryItemBulkResponse
from linnworks_api.generated.inventory.models.delete_inventory_item_bulk_request import DeleteInventoryItemBulkRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    request = linnworks_api.generated.inventory.DeleteInventoryItemBulkRequest() # DeleteInventoryItemBulkRequest |  (optional)

    try:
        # DeleteInventoryItemBulk
        api_response = api_instance.delete_inventory_item_bulk(request=request)
        print("The response of InventoryApi->delete_inventory_item_bulk:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_inventory_item_bulk: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**DeleteInventoryItemBulkRequest**](DeleteInventoryItemBulkRequest.md)|  | [optional] 

### Return type

[**BatchedAPIResponseDeleteInventoryItemBulkResponse**](BatchedAPIResponseDeleteInventoryItemBulkResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_inventory_item_channel_skus**
> delete_inventory_item_channel_skus(inventory_delete_inventory_item_channel_skus_request)

DeleteInventoryItemChannelSKUs

Use this call to delete stockitem channel skus <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_inventory_item_channel_skus_request import InventoryDeleteInventoryItemChannelSKUsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_inventory_item_channel_skus_request = linnworks_api.generated.inventory.InventoryDeleteInventoryItemChannelSKUsRequest() # InventoryDeleteInventoryItemChannelSKUsRequest | 

    try:
        # DeleteInventoryItemChannelSKUs
        api_instance.delete_inventory_item_channel_skus(inventory_delete_inventory_item_channel_skus_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_inventory_item_channel_skus: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_inventory_item_channel_skus_request** | [**InventoryDeleteInventoryItemChannelSKUsRequest**](InventoryDeleteInventoryItemChannelSKUsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_inventory_item_compositions**
> delete_inventory_item_compositions(inventory_delete_inventory_item_compositions_request)

DeleteInventoryItemCompositions

Use this call to delete stockItem compositions <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_inventory_item_compositions_request import InventoryDeleteInventoryItemCompositionsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_inventory_item_compositions_request = linnworks_api.generated.inventory.InventoryDeleteInventoryItemCompositionsRequest() # InventoryDeleteInventoryItemCompositionsRequest | 

    try:
        # DeleteInventoryItemCompositions
        api_instance.delete_inventory_item_compositions(inventory_delete_inventory_item_compositions_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_inventory_item_compositions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_inventory_item_compositions_request** | [**InventoryDeleteInventoryItemCompositionsRequest**](InventoryDeleteInventoryItemCompositionsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_inventory_item_descriptions**
> delete_inventory_item_descriptions(inventory_delete_inventory_item_descriptions_request)

DeleteInventoryItemDescriptions

Use this call to delete stockitem Descriptions <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_inventory_item_descriptions_request import InventoryDeleteInventoryItemDescriptionsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_inventory_item_descriptions_request = linnworks_api.generated.inventory.InventoryDeleteInventoryItemDescriptionsRequest() # InventoryDeleteInventoryItemDescriptionsRequest | 

    try:
        # DeleteInventoryItemDescriptions
        api_instance.delete_inventory_item_descriptions(inventory_delete_inventory_item_descriptions_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_inventory_item_descriptions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_inventory_item_descriptions_request** | [**InventoryDeleteInventoryItemDescriptionsRequest**](InventoryDeleteInventoryItemDescriptionsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_inventory_item_extended_properties**
> delete_inventory_item_extended_properties(inventory_delete_inventory_item_extended_properties_request)

DeleteInventoryItemExtendedProperties

Use this call to delete stockitem Extended Properties <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_inventory_item_extended_properties_request import InventoryDeleteInventoryItemExtendedPropertiesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_inventory_item_extended_properties_request = linnworks_api.generated.inventory.InventoryDeleteInventoryItemExtendedPropertiesRequest() # InventoryDeleteInventoryItemExtendedPropertiesRequest | 

    try:
        # DeleteInventoryItemExtendedProperties
        api_instance.delete_inventory_item_extended_properties(inventory_delete_inventory_item_extended_properties_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_inventory_item_extended_properties: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_inventory_item_extended_properties_request** | [**InventoryDeleteInventoryItemExtendedPropertiesRequest**](InventoryDeleteInventoryItemExtendedPropertiesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_inventory_item_image_bulk**
> BatchedAPIResponseDeleteInventoryItemImagesResponse delete_inventory_item_image_bulk(inventory_delete_inventory_item_image_bulk_request)

DeleteInventoryItemImageBulk

Use this call to delete images from inventory items <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.batched_api_response_delete_inventory_item_images_response import BatchedAPIResponseDeleteInventoryItemImagesResponse
from linnworks_api.generated.inventory.models.inventory_delete_inventory_item_image_bulk_request import InventoryDeleteInventoryItemImageBulkRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_inventory_item_image_bulk_request = linnworks_api.generated.inventory.InventoryDeleteInventoryItemImageBulkRequest() # InventoryDeleteInventoryItemImageBulkRequest | 

    try:
        # DeleteInventoryItemImageBulk
        api_response = api_instance.delete_inventory_item_image_bulk(inventory_delete_inventory_item_image_bulk_request)
        print("The response of InventoryApi->delete_inventory_item_image_bulk:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_inventory_item_image_bulk: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_inventory_item_image_bulk_request** | [**InventoryDeleteInventoryItemImageBulkRequest**](InventoryDeleteInventoryItemImageBulkRequest.md)|  | 

### Return type

[**BatchedAPIResponseDeleteInventoryItemImagesResponse**](BatchedAPIResponseDeleteInventoryItemImagesResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_inventory_item_prices**
> delete_inventory_item_prices(inventory_delete_inventory_item_prices_request)

DeleteInventoryItemPrices

Use this call to delete stock item prices <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_inventory_item_prices_request import InventoryDeleteInventoryItemPricesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_inventory_item_prices_request = linnworks_api.generated.inventory.InventoryDeleteInventoryItemPricesRequest() # InventoryDeleteInventoryItemPricesRequest | 

    try:
        # DeleteInventoryItemPrices
        api_instance.delete_inventory_item_prices(inventory_delete_inventory_item_prices_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_inventory_item_prices: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_inventory_item_prices_request** | [**InventoryDeleteInventoryItemPricesRequest**](InventoryDeleteInventoryItemPricesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_inventory_item_pricing_rules**
> delete_inventory_item_pricing_rules(inventory_delete_inventory_item_pricing_rules_request)

DeleteInventoryItemPricingRules

Use this call to update stock item price rules <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_inventory_item_pricing_rules_request import InventoryDeleteInventoryItemPricingRulesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_inventory_item_pricing_rules_request = linnworks_api.generated.inventory.InventoryDeleteInventoryItemPricingRulesRequest() # InventoryDeleteInventoryItemPricingRulesRequest | 

    try:
        # DeleteInventoryItemPricingRules
        api_instance.delete_inventory_item_pricing_rules(inventory_delete_inventory_item_pricing_rules_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_inventory_item_pricing_rules: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_inventory_item_pricing_rules_request** | [**InventoryDeleteInventoryItemPricingRulesRequest**](InventoryDeleteInventoryItemPricingRulesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_inventory_item_titles**
> delete_inventory_item_titles(inventory_delete_inventory_item_titles_request)

DeleteInventoryItemTitles

Use this call to delete stockitem Titles <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_inventory_item_titles_request import InventoryDeleteInventoryItemTitlesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_inventory_item_titles_request = linnworks_api.generated.inventory.InventoryDeleteInventoryItemTitlesRequest() # InventoryDeleteInventoryItemTitlesRequest | 

    try:
        # DeleteInventoryItemTitles
        api_instance.delete_inventory_item_titles(inventory_delete_inventory_item_titles_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_inventory_item_titles: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_inventory_item_titles_request** | [**InventoryDeleteInventoryItemTitlesRequest**](InventoryDeleteInventoryItemTitlesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_inventory_items**
> delete_inventory_items(inventory_delete_inventory_items_request)

DeleteInventoryItems

Use this call to delete inventory item.  All associated information will be unlinked/removed from this stock item. <b>Permissions Required: </b> GlobalPermissions.Inventory.DeleteMyInventoryItems.DeleteItemsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_inventory_items_request import InventoryDeleteInventoryItemsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_inventory_items_request = linnworks_api.generated.inventory.InventoryDeleteInventoryItemsRequest() # InventoryDeleteInventoryItemsRequest | 

    try:
        # DeleteInventoryItems
        api_instance.delete_inventory_items(inventory_delete_inventory_items_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_inventory_items: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_inventory_items_request** | [**InventoryDeleteInventoryItemsRequest**](InventoryDeleteInventoryItemsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_item_locations**
> delete_item_locations(inventory_delete_item_locations_request)

DeleteItemLocations

Use this call to delete stock item locations bin/rack <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemBinRackNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_item_locations_request import InventoryDeleteItemLocationsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_item_locations_request = linnworks_api.generated.inventory.InventoryDeleteItemLocationsRequest() # InventoryDeleteItemLocationsRequest | 

    try:
        # DeleteItemLocations
        api_instance.delete_item_locations(inventory_delete_item_locations_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_item_locations: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_item_locations_request** | [**InventoryDeleteItemLocationsRequest**](InventoryDeleteItemLocationsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_product_identifiers**
> delete_product_identifiers(inventory_delete_product_identifiers_request)

DeleteProductIdentifiers

Used to delete product identifiers <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_product_identifiers_request import InventoryDeleteProductIdentifiersRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_product_identifiers_request = linnworks_api.generated.inventory.InventoryDeleteProductIdentifiersRequest() # InventoryDeleteProductIdentifiersRequest | 

    try:
        # DeleteProductIdentifiers
        api_instance.delete_product_identifiers(inventory_delete_product_identifiers_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_product_identifiers: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_product_identifiers_request** | [**InventoryDeleteProductIdentifiersRequest**](InventoryDeleteProductIdentifiersRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_scrap_categories**
> delete_scrap_categories(inventory_delete_scrap_categories_request)

DeleteScrapCategories

Used to delete scrap categories <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapCategoriesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_scrap_categories_request import InventoryDeleteScrapCategoriesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_scrap_categories_request = linnworks_api.generated.inventory.InventoryDeleteScrapCategoriesRequest() # InventoryDeleteScrapCategoriesRequest | 

    try:
        # DeleteScrapCategories
        api_instance.delete_scrap_categories(inventory_delete_scrap_categories_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_scrap_categories: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_scrap_categories_request** | [**InventoryDeleteScrapCategoriesRequest**](InventoryDeleteScrapCategoriesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_stock_supplier_stat**
> delete_stock_supplier_stat(inventory_delete_stock_supplier_stat_request)

DeleteStockSupplierStat

Use this call to delete item supplier stat <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_stock_supplier_stat_request import InventoryDeleteStockSupplierStatRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_stock_supplier_stat_request = linnworks_api.generated.inventory.InventoryDeleteStockSupplierStatRequest() # InventoryDeleteStockSupplierStatRequest | 

    try:
        # DeleteStockSupplierStat
        api_instance.delete_stock_supplier_stat(inventory_delete_stock_supplier_stat_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_stock_supplier_stat: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_stock_supplier_stat_request** | [**InventoryDeleteStockSupplierStatRequest**](InventoryDeleteStockSupplierStatRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_suppliers**
> delete_suppliers(inventory_delete_suppliers_request)

DeleteSuppliers

Use this call delete Supplied by Id  <param name=\"suppliersIds\">List of Supplier IDs</param> <b>Permissions Required: </b> GlobalPermissions.Inventory.InventorySettings.SuppliersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_suppliers_request import InventoryDeleteSuppliersRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_suppliers_request = linnworks_api.generated.inventory.InventoryDeleteSuppliersRequest() # InventoryDeleteSuppliersRequest | 

    try:
        # DeleteSuppliers
        api_instance.delete_suppliers(inventory_delete_suppliers_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_suppliers: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_suppliers_request** | [**InventoryDeleteSuppliersRequest**](InventoryDeleteSuppliersRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_user_specific_view**
> delete_user_specific_view(inventory_delete_user_specific_view_request)

DeleteUserSpecificView

Use this call to delete user-specific view from database <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_delete_user_specific_view_request import InventoryDeleteUserSpecificViewRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_delete_user_specific_view_request = linnworks_api.generated.inventory.InventoryDeleteUserSpecificViewRequest() # InventoryDeleteUserSpecificViewRequest | 

    try:
        # DeleteUserSpecificView
        api_instance.delete_user_specific_view(inventory_delete_user_specific_view_request)
    except Exception as e:
        print("Exception when calling InventoryApi->delete_user_specific_view: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_delete_user_specific_view_request** | [**InventoryDeleteUserSpecificViewRequest**](InventoryDeleteUserSpecificViewRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **duplicate_inventory_item**
> duplicate_inventory_item(inventory_duplicate_inventory_item_request)

DuplicateInventoryItem

Use this call to add stock item by duplicating existing one <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_duplicate_inventory_item_request import InventoryDuplicateInventoryItemRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_duplicate_inventory_item_request = linnworks_api.generated.inventory.InventoryDuplicateInventoryItemRequest() # InventoryDuplicateInventoryItemRequest | 

    try:
        # DuplicateInventoryItem
        api_instance.duplicate_inventory_item(inventory_duplicate_inventory_item_request)
    except Exception as e:
        print("Exception when calling InventoryApi->duplicate_inventory_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_duplicate_inventory_item_request** | [**InventoryDuplicateInventoryItemRequest**](InventoryDuplicateInventoryItemRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_all_extended_property_names**
> Dict[str, List[str]] get_all_extended_property_names()

GetAllExtendedPropertyNames

Use this call to get extended properties for all types <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetAllExtendedPropertyNames
        api_response = api_instance.get_all_extended_property_names()
        print("The response of InventoryApi->get_all_extended_property_names:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_all_extended_property_names: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**Dict[str, List[str]]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_batch_audit**
> GetBatchAuditResponse get_batch_audit(inventory_get_batch_audit_request)

GetBatchAudit

Get audit trail for batches <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_batch_audit_response import GetBatchAuditResponse
from linnworks_api.generated.inventory.models.inventory_get_batch_audit_request import InventoryGetBatchAuditRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_batch_audit_request = linnworks_api.generated.inventory.InventoryGetBatchAuditRequest() # InventoryGetBatchAuditRequest | 

    try:
        # GetBatchAudit
        api_response = api_instance.get_batch_audit(inventory_get_batch_audit_request)
        print("The response of InventoryApi->get_batch_audit:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_batch_audit: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_batch_audit_request** | [**InventoryGetBatchAuditRequest**](InventoryGetBatchAuditRequest.md)|  | 

### Return type

[**GetBatchAuditResponse**](GetBatchAuditResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_batch_inventory_by_id**
> GetBatchInventoryByIdResponse get_batch_inventory_by_id(request=request)

GetBatchInventoryById

Retruns batch header and only batch inventory for provided batch <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_batch_inventory_by_id_request import GetBatchInventoryByIdRequest
from linnworks_api.generated.inventory.models.get_batch_inventory_by_id_response import GetBatchInventoryByIdResponse
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    request = linnworks_api.generated.inventory.GetBatchInventoryByIdRequest() # GetBatchInventoryByIdRequest |  (optional)

    try:
        # GetBatchInventoryById
        api_response = api_instance.get_batch_inventory_by_id(request=request)
        print("The response of InventoryApi->get_batch_inventory_by_id:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_batch_inventory_by_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**GetBatchInventoryByIdRequest**](GetBatchInventoryByIdRequest.md)|  | [optional] 

### Return type

[**GetBatchInventoryByIdResponse**](GetBatchInventoryByIdResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_batches_by_stock_item_id**
> List[StockItemBatch] get_batches_by_stock_item_id(stock_item_id=stock_item_id, only_available=only_available, stock_location_id=stock_location_id)

GetBatchesByStockItemId

Used to get batch info for stock item for all locations <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_batch import StockItemBatch
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    stock_item_id = 'stock_item_id_example' # str | Item id (optional)
    only_available = True # bool | If true, only available batches will be returned (optional)
    stock_location_id = 'stock_location_id_example' # str |  (optional)

    try:
        # GetBatchesByStockItemId
        api_response = api_instance.get_batches_by_stock_item_id(stock_item_id=stock_item_id, only_available=only_available, stock_location_id=stock_location_id)
        print("The response of InventoryApi->get_batches_by_stock_item_id:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_batches_by_stock_item_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stock_item_id** | **str**| Item id | [optional] 
 **only_available** | **bool**| If true, only available batches will be returned | [optional] 
 **stock_location_id** | **str**|  | [optional] 

### Return type

[**List[StockItemBatch]**](StockItemBatch.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_categories**
> List[LinnworksCategory] get_categories()

GetCategories

Use this call to get categories <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.linnworks_category import LinnworksCategory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetCategories
        api_response = api_instance.get_categories()
        print("The response of InventoryApi->get_categories:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_categories: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[LinnworksCategory]**](LinnworksCategory.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_channels**
> List[AnyConfig] get_channels()

GetChannels

Use this call to get all channels <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.any_config import AnyConfig
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetChannels
        api_response = api_instance.get_channels()
        print("The response of InventoryApi->get_channels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_channels: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[AnyConfig]**](AnyConfig.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_channels_by_source**
> List[HeaderConfig] get_channels_by_source(source=source)

GetChannelsBySource

Use this call to get channels by source <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.header_config import HeaderConfig
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    source = 'source_example' # str | Channel source (optional)

    try:
        # GetChannelsBySource
        api_response = api_instance.get_channels_by_source(source=source)
        print("The response of InventoryApi->get_channels_by_source:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_channels_by_source: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **source** | **str**| Channel source | [optional] 

### Return type

[**List[HeaderConfig]**](HeaderConfig.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_countries**
> List[Country] get_countries()

GetCountries

Use this call to get list of all countries <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.country import Country
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetCountries
        api_response = api_instance.get_countries()
        print("The response of InventoryApi->get_countries:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_countries: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[Country]**](Country.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_country_codes**
> Dict[str, str] get_country_codes()

GetCountryCodes

Use this call to get all country codes from ebay channel <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetCountryCodes
        api_response = api_instance.get_country_codes()
        print("The response of InventoryApi->get_country_codes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_country_codes: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**Dict[str, str]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_ebay_compatibility_list**
> List[StockItemEbayCompatibility] get_ebay_compatibility_list(stock_item_id=stock_item_id)

GetEbayCompatibilityList

Use this call to get a list of Ebay Compatibility <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_ebay_compatibility import StockItemEbayCompatibility
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    stock_item_id = 'stock_item_id_example' # str | Stock Item Id (optional)

    try:
        # GetEbayCompatibilityList
        api_response = api_instance.get_ebay_compatibility_list(stock_item_id=stock_item_id)
        print("The response of InventoryApi->get_ebay_compatibility_list:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_ebay_compatibility_list: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stock_item_id** | **str**| Stock Item Id | [optional] 

### Return type

[**List[StockItemEbayCompatibility]**](StockItemEbayCompatibility.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_extended_property_names**
> List[str] get_extended_property_names(property_type=property_type)

GetExtendedPropertyNames

Use this call to get all available extended property names <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    property_type = 'property_type_example' # str |  (optional)

    try:
        # GetExtendedPropertyNames
        api_response = api_instance.get_extended_property_names(property_type=property_type)
        print("The response of InventoryApi->get_extended_property_names:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_extended_property_names: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **property_type** | **str**|  | [optional] 

### Return type

**List[str]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_extended_property_types**
> List[str] get_extended_property_types()

GetExtendedPropertyTypes

Use this call to get default extended property types <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetExtendedPropertyTypes
        api_response = api_instance.get_extended_property_types()
        print("The response of InventoryApi->get_extended_property_types:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_extended_property_types: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**List[str]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_images_in_bulk**
> GetImagesInBulkResponse get_images_in_bulk(inventory_get_images_in_bulk_request)

GetImagesInBulk

Use this call to Get inventory item images <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockReadNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_images_in_bulk_response import GetImagesInBulkResponse
from linnworks_api.generated.inventory.models.inventory_get_images_in_bulk_request import InventoryGetImagesInBulkRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_images_in_bulk_request = linnworks_api.generated.inventory.InventoryGetImagesInBulkRequest() # InventoryGetImagesInBulkRequest | 

    try:
        # GetImagesInBulk
        api_response = api_instance.get_images_in_bulk(inventory_get_images_in_bulk_request)
        print("The response of InventoryApi->get_images_in_bulk:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_images_in_bulk: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_images_in_bulk_request** | [**InventoryGetImagesInBulkRequest**](InventoryGetImagesInBulkRequest.md)|  | 

### Return type

[**GetImagesInBulkResponse**](GetImagesInBulkResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_batch_types**
> Dict[str, int] get_inventory_batch_types()

GetInventoryBatchTypes

Use this call to get available inventory batch types <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetInventoryBatchTypes
        api_response = api_instance.get_inventory_batch_types()
        print("The response of InventoryApi->get_inventory_batch_types:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_batch_types: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**Dict[str, int]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_audit_trail**
> List[StockItemAuditTrail] get_inventory_item_audit_trail(inventory_item_id=inventory_item_id)

GetInventoryItemAuditTrail

Use this call to get StockItem AuditTrail <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_audit_trail import StockItemAuditTrail
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_item_id = 'inventory_item_id_example' # str | StockItem unique identifier (optional)

    try:
        # GetInventoryItemAuditTrail
        api_response = api_instance.get_inventory_item_audit_trail(inventory_item_id=inventory_item_id)
        print("The response of InventoryApi->get_inventory_item_audit_trail:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_audit_trail: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_item_id** | **str**| StockItem unique identifier | [optional] 

### Return type

[**List[StockItemAuditTrail]**](StockItemAuditTrail.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_audit_trail_paged**
> PagedResultStockItemAuditTrail get_inventory_item_audit_trail_paged(inventory_get_inventory_item_audit_trail_paged_request)

GetInventoryItemAuditTrailPaged

Use this call to retrieve StockItem AuditTrail list by filters <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_get_inventory_item_audit_trail_paged_request import InventoryGetInventoryItemAuditTrailPagedRequest
from linnworks_api.generated.inventory.models.paged_result_stock_item_audit_trail import PagedResultStockItemAuditTrail
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_inventory_item_audit_trail_paged_request = linnworks_api.generated.inventory.InventoryGetInventoryItemAuditTrailPagedRequest() # InventoryGetInventoryItemAuditTrailPagedRequest | 

    try:
        # GetInventoryItemAuditTrailPaged
        api_response = api_instance.get_inventory_item_audit_trail_paged(inventory_get_inventory_item_audit_trail_paged_request)
        print("The response of InventoryApi->get_inventory_item_audit_trail_paged:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_audit_trail_paged: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_inventory_item_audit_trail_paged_request** | [**InventoryGetInventoryItemAuditTrailPagedRequest**](InventoryGetInventoryItemAuditTrailPagedRequest.md)|  | 

### Return type

[**PagedResultStockItemAuditTrail**](PagedResultStockItemAuditTrail.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_batch_information**
> List[StockItemBatch] get_inventory_item_batch_information(inventory_get_inventory_item_batch_information_request)

GetInventoryItemBatchInformation

Used to get the batch information of a specific item <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockReadNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_get_inventory_item_batch_information_request import InventoryGetInventoryItemBatchInformationRequest
from linnworks_api.generated.inventory.models.stock_item_batch import StockItemBatch
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_inventory_item_batch_information_request = linnworks_api.generated.inventory.InventoryGetInventoryItemBatchInformationRequest() # InventoryGetInventoryItemBatchInformationRequest | 

    try:
        # GetInventoryItemBatchInformation
        api_response = api_instance.get_inventory_item_batch_information(inventory_get_inventory_item_batch_information_request)
        print("The response of InventoryApi->get_inventory_item_batch_information:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_batch_information: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_inventory_item_batch_information_request** | [**InventoryGetInventoryItemBatchInformationRequest**](InventoryGetInventoryItemBatchInformationRequest.md)|  | 

### Return type

[**List[StockItemBatch]**](StockItemBatch.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_batch_information_by_ids**
> GetInventoryItemBatchInformationByIdsResponse get_inventory_item_batch_information_by_ids(inventory_get_inventory_item_batch_information_by_ids_request)

GetInventoryItemBatchInformationByIds

 <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockReadNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_inventory_item_batch_information_by_ids_response import GetInventoryItemBatchInformationByIdsResponse
from linnworks_api.generated.inventory.models.inventory_get_inventory_item_batch_information_by_ids_request import InventoryGetInventoryItemBatchInformationByIdsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_inventory_item_batch_information_by_ids_request = linnworks_api.generated.inventory.InventoryGetInventoryItemBatchInformationByIdsRequest() # InventoryGetInventoryItemBatchInformationByIdsRequest | 

    try:
        # GetInventoryItemBatchInformationByIds
        api_response = api_instance.get_inventory_item_batch_information_by_ids(inventory_get_inventory_item_batch_information_by_ids_request)
        print("The response of InventoryApi->get_inventory_item_batch_information_by_ids:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_batch_information_by_ids: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_inventory_item_batch_information_by_ids_request** | [**InventoryGetInventoryItemBatchInformationByIdsRequest**](InventoryGetInventoryItemBatchInformationByIdsRequest.md)|  | 

### Return type

[**GetInventoryItemBatchInformationByIdsResponse**](GetInventoryItemBatchInformationByIdsResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_by_id**
> StockItemInv get_inventory_item_by_id(id=id)

GetInventoryItemById

Use this call to get all product details <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_inv import StockItemInv
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    id = 'id_example' # str |  (optional)

    try:
        # GetInventoryItemById
        api_response = api_instance.get_inventory_item_by_id(id=id)
        print("The response of InventoryApi->get_inventory_item_by_id:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_by_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | [optional] 

### Return type

[**StockItemInv**](StockItemInv.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_channel_skus**
> List[StockItemChannelSKU] get_inventory_item_channel_skus(inventory_item_id=inventory_item_id)

GetInventoryItemChannelSKUs

Use this call to get stockitem channel skus <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_channel_sku import StockItemChannelSKU
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_item_id = 'inventory_item_id_example' # str | stockitem id (optional)

    try:
        # GetInventoryItemChannelSKUs
        api_response = api_instance.get_inventory_item_channel_skus(inventory_item_id=inventory_item_id)
        print("The response of InventoryApi->get_inventory_item_channel_skus:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_channel_skus: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_item_id** | **str**| stockitem id | [optional] 

### Return type

[**List[StockItemChannelSKU]**](StockItemChannelSKU.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_channel_skus_with_location**
> List[StockItemChannelSKUWithLocation] get_inventory_item_channel_skus_with_location(channel_sku_row_id=channel_sku_row_id)

GetInventoryItemChannelSKUsWithLocation

Use this call to retrieve all stock item channel sku's with location for a given channel sku RowId <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_channel_sku_with_location import StockItemChannelSKUWithLocation
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    channel_sku_row_id = 'channel_sku_row_id_example' # str | ChannelSKU record Id (optional)

    try:
        # GetInventoryItemChannelSKUsWithLocation
        api_response = api_instance.get_inventory_item_channel_skus_with_location(channel_sku_row_id=channel_sku_row_id)
        print("The response of InventoryApi->get_inventory_item_channel_skus_with_location:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_channel_skus_with_location: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **channel_sku_row_id** | **str**| ChannelSKU record Id | [optional] 

### Return type

[**List[StockItemChannelSKUWithLocation]**](StockItemChannelSKUWithLocation.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_compositions**
> List[StockItemComposition] get_inventory_item_compositions(inventory_item_id=inventory_item_id, get_full_detail=get_full_detail)

GetInventoryItemCompositions

Use this call to get all StockItem Compositions <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_composition import StockItemComposition
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_item_id = 'inventory_item_id_example' # str | Id of StockItem (optional)
    get_full_detail = True # bool | Indicate if the method has to be recursive, going throw inner composites, getting only real items (optional)

    try:
        # GetInventoryItemCompositions
        api_response = api_instance.get_inventory_item_compositions(inventory_item_id=inventory_item_id, get_full_detail=get_full_detail)
        print("The response of InventoryApi->get_inventory_item_compositions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_compositions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_item_id** | **str**| Id of StockItem | [optional] 
 **get_full_detail** | **bool**| Indicate if the method has to be recursive, going throw inner composites, getting only real items | [optional] 

### Return type

[**List[StockItemComposition]**](StockItemComposition.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_descriptions**
> List[StockItemDescription] get_inventory_item_descriptions(inventory_item_id=inventory_item_id)

GetInventoryItemDescriptions

Use this call to get stockitem Descriptions <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_description import StockItemDescription
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_item_id = 'inventory_item_id_example' # str | stockitem id (optional)

    try:
        # GetInventoryItemDescriptions
        api_response = api_instance.get_inventory_item_descriptions(inventory_item_id=inventory_item_id)
        print("The response of InventoryApi->get_inventory_item_descriptions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_descriptions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_item_id** | **str**| stockitem id | [optional] 

### Return type

[**List[StockItemDescription]**](StockItemDescription.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_extended_properties**
> List[StockItemExtendedProperty] get_inventory_item_extended_properties(inventory_get_inventory_item_extended_properties_request)

GetInventoryItemExtendedProperties

Use this call to get stockitem Extended Properties <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_get_inventory_item_extended_properties_request import InventoryGetInventoryItemExtendedPropertiesRequest
from linnworks_api.generated.inventory.models.stock_item_extended_property import StockItemExtendedProperty
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_inventory_item_extended_properties_request = linnworks_api.generated.inventory.InventoryGetInventoryItemExtendedPropertiesRequest() # InventoryGetInventoryItemExtendedPropertiesRequest | 

    try:
        # GetInventoryItemExtendedProperties
        api_response = api_instance.get_inventory_item_extended_properties(inventory_get_inventory_item_extended_properties_request)
        print("The response of InventoryApi->get_inventory_item_extended_properties:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_extended_properties: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_inventory_item_extended_properties_request** | [**InventoryGetInventoryItemExtendedPropertiesRequest**](InventoryGetInventoryItemExtendedPropertiesRequest.md)|  | 

### Return type

[**List[StockItemExtendedProperty]**](StockItemExtendedProperty.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_images**
> List[StockItemImage] get_inventory_item_images(inventory_item_id=inventory_item_id, item_number=item_number)

GetInventoryItemImages

Use this call to get inventory item images <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_image import StockItemImage
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_item_id = 'inventory_item_id_example' # str | Conditional. If not provided, you must provide ItemNumber (optional)
    item_number = 'item_number_example' # str | Conditional. if InventoryItemId is provided, ItemNumber will be ignored (optional)

    try:
        # GetInventoryItemImages
        api_response = api_instance.get_inventory_item_images(inventory_item_id=inventory_item_id, item_number=item_number)
        print("The response of InventoryApi->get_inventory_item_images:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_images: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_item_id** | **str**| Conditional. If not provided, you must provide ItemNumber | [optional] 
 **item_number** | **str**| Conditional. if InventoryItemId is provided, ItemNumber will be ignored | [optional] 

### Return type

[**List[StockItemImage]**](StockItemImage.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_locations**
> List[StockItemLocation] get_inventory_item_locations(inventory_item_id=inventory_item_id)

GetInventoryItemLocations

Use this call to get stock item locations bin/rack <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_location import StockItemLocation
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_item_id = 'inventory_item_id_example' # str | Stock item ID (optional)

    try:
        # GetInventoryItemLocations
        api_response = api_instance.get_inventory_item_locations(inventory_item_id=inventory_item_id)
        print("The response of InventoryApi->get_inventory_item_locations:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_locations: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_item_id** | **str**| Stock item ID | [optional] 

### Return type

[**List[StockItemLocation]**](StockItemLocation.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_price_channel_suffixes**
> Dict[str, List[str]] get_inventory_item_price_channel_suffixes()

GetInventoryItemPriceChannelSuffixes

Use this call to get all possible price change subsource suffices for all channels <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetInventoryItemPriceChannelSuffixes
        api_response = api_instance.get_inventory_item_price_channel_suffixes()
        print("The response of InventoryApi->get_inventory_item_price_channel_suffixes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_price_channel_suffixes: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**Dict[str, List[str]]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_price_rules_by_id**
> List[StockItemPricingRule] get_inventory_item_price_rules_by_id(stock_item_price_id=stock_item_price_id)

GetInventoryItemPriceRulesById

Use this call to get stock item price rules by price id <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_pricing_rule import StockItemPricingRule
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    stock_item_price_id = 'stock_item_price_id_example' # str | Price ID of an item (optional)

    try:
        # GetInventoryItemPriceRulesById
        api_response = api_instance.get_inventory_item_price_rules_by_id(stock_item_price_id=stock_item_price_id)
        print("The response of InventoryApi->get_inventory_item_price_rules_by_id:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_price_rules_by_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stock_item_price_id** | **str**| Price ID of an item | [optional] 

### Return type

[**List[StockItemPricingRule]**](StockItemPricingRule.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_price_rules_by_source**
> List[StockItemPricingRule] get_inventory_item_price_rules_by_source(stock_item_id=stock_item_id, source=source, sub_source=sub_source)

GetInventoryItemPriceRulesBySource

Use this call to get stock item price rules by item id, source and subsource <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_pricing_rule import StockItemPricingRule
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    stock_item_id = 'stock_item_id_example' # str | Stock item id (optional)
    source = 'source_example' # str | Channel source (optional)
    sub_source = 'sub_source_example' # str | Channel subsource (optional)

    try:
        # GetInventoryItemPriceRulesBySource
        api_response = api_instance.get_inventory_item_price_rules_by_source(stock_item_id=stock_item_id, source=source, sub_source=sub_source)
        print("The response of InventoryApi->get_inventory_item_price_rules_by_source:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_price_rules_by_source: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stock_item_id** | **str**| Stock item id | [optional] 
 **source** | **str**| Channel source | [optional] 
 **sub_source** | **str**| Channel subsource | [optional] 

### Return type

[**List[StockItemPricingRule]**](StockItemPricingRule.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_price_tags**
> Dict[str, List[str]] get_inventory_item_price_tags()

GetInventoryItemPriceTags

Use this call to get all possible price change tags for all channels <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetInventoryItemPriceTags
        api_response = api_instance.get_inventory_item_price_tags()
        print("The response of InventoryApi->get_inventory_item_price_tags:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_price_tags: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**Dict[str, List[str]]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_prices**
> List[StockItemPrice] get_inventory_item_prices(inventory_item_id=inventory_item_id)

GetInventoryItemPrices

Use this call to get stock item prices by channel <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_price import StockItemPrice
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_item_id = 'inventory_item_id_example' # str | Stock item id (optional)

    try:
        # GetInventoryItemPrices
        api_response = api_instance.get_inventory_item_prices(inventory_item_id=inventory_item_id)
        print("The response of InventoryApi->get_inventory_item_prices:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_prices: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_item_id** | **str**| Stock item id | [optional] 

### Return type

[**List[StockItemPrice]**](StockItemPrice.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_item_titles**
> List[StockItemTitle] get_inventory_item_titles(inventory_item_id=inventory_item_id)

GetInventoryItemTitles

Use this call to get stockitem Titles <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_title import StockItemTitle
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_item_id = 'inventory_item_id_example' # str | stockitem id (optional)

    try:
        # GetInventoryItemTitles
        api_response = api_instance.get_inventory_item_titles(inventory_item_id=inventory_item_id)
        print("The response of InventoryApi->get_inventory_item_titles:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_item_titles: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_item_id** | **str**| stockitem id | [optional] 

### Return type

[**List[StockItemTitle]**](StockItemTitle.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_items_composition_by_ids**
> GetInventoryItemsCompositionByIdsResponse get_inventory_items_composition_by_ids(inventory_get_inventory_items_composition_by_ids_request)

GetInventoryItemsCompositionByIds

Use this call to get all StockItem Compositions <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_inventory_items_composition_by_ids_response import GetInventoryItemsCompositionByIdsResponse
from linnworks_api.generated.inventory.models.inventory_get_inventory_items_composition_by_ids_request import InventoryGetInventoryItemsCompositionByIdsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_inventory_items_composition_by_ids_request = linnworks_api.generated.inventory.InventoryGetInventoryItemsCompositionByIdsRequest() # InventoryGetInventoryItemsCompositionByIdsRequest | 

    try:
        # GetInventoryItemsCompositionByIds
        api_response = api_instance.get_inventory_items_composition_by_ids(inventory_get_inventory_items_composition_by_ids_request)
        print("The response of InventoryApi->get_inventory_items_composition_by_ids:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_items_composition_by_ids: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_inventory_items_composition_by_ids_request** | [**InventoryGetInventoryItemsCompositionByIdsRequest**](InventoryGetInventoryItemsCompositionByIdsRequest.md)|  | 

### Return type

[**GetInventoryItemsCompositionByIdsResponse**](GetInventoryItemsCompositionByIdsResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_inventory_items_count**
> int get_inventory_items_count(include_deleted=include_deleted, include_archived=include_archived)

GetInventoryItemsCount

Use this call to get total items count <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    include_deleted = True # bool | Include deleted items (optional)
    include_archived = True # bool | Include archived items (optional)

    try:
        # GetInventoryItemsCount
        api_response = api_instance.get_inventory_items_count(include_deleted=include_deleted, include_archived=include_archived)
        print("The response of InventoryApi->get_inventory_items_count:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_inventory_items_count: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include_deleted** | **bool**| Include deleted items | [optional] 
 **include_archived** | **bool**| Include archived items | [optional] 

### Return type

**int**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_new_item_number**
> str get_new_item_number()

GetNewItemNumber

Use this call to get next unused SKU <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetNewItemNumber
        api_response = api_instance.get_new_item_number()
        print("The response of InventoryApi->get_new_item_number:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_new_item_number: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**str**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_package_groups**
> List[KeyGuidValue] get_package_groups()

GetPackageGroups

Use this call to get all package groups <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.key_guid_value import KeyGuidValue
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetPackageGroups
        api_response = api_instance.get_package_groups()
        print("The response of InventoryApi->get_package_groups:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_package_groups: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[KeyGuidValue]**](KeyGuidValue.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_postal_services**
> List[KeyGuidValue] get_postal_services()

GetPostalServices

Use this call to get all postal services <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.key_guid_value import KeyGuidValue
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetPostalServices
        api_response = api_instance.get_postal_services()
        print("The response of InventoryApi->get_postal_services:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_postal_services: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[KeyGuidValue]**](KeyGuidValue.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_pre_defined_views**
> List[InventoryView] get_pre_defined_views()

GetPreDefinedViews

Use this call to get pre-defined (standard) views <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_view import InventoryView
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetPreDefinedViews
        api_response = api_instance.get_pre_defined_views()
        print("The response of InventoryApi->get_pre_defined_views:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_pre_defined_views: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[InventoryView]**](InventoryView.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_product_identifier_extended_types**
> GetProductIdentifierExtendedResponse get_product_identifier_extended_types()

GetProductIdentifierExtendedTypes

Use this call to get available Product Identifier types with extended information, eg related sources, scanned at dispatch <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_product_identifier_extended_response import GetProductIdentifierExtendedResponse
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetProductIdentifierExtendedTypes
        api_response = api_instance.get_product_identifier_extended_types()
        print("The response of InventoryApi->get_product_identifier_extended_types:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_product_identifier_extended_types: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**GetProductIdentifierExtendedResponse**](GetProductIdentifierExtendedResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_product_identifier_types**
> GetProductIdentifierTypesRequest get_product_identifier_types()

GetProductIdentifierTypes

Use this call to get available Product Identifier types <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_product_identifier_types_request import GetProductIdentifierTypesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetProductIdentifierTypes
        api_response = api_instance.get_product_identifier_types()
        print("The response of InventoryApi->get_product_identifier_types:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_product_identifier_types: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**GetProductIdentifierTypesRequest**](GetProductIdentifierTypesRequest.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_product_identifiers_bulk_by_stock_item_id**
> GetProductIdentifiersByStockItemIdResponse get_product_identifiers_bulk_by_stock_item_id(request=request)

GetProductIdentifiersBulkByStockItemId

Used to get product identifiers for multiple stock items <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_product_identifiers_bulk_by_stock_item_id_request import GetProductIdentifiersBulkByStockItemIdRequest
from linnworks_api.generated.inventory.models.get_product_identifiers_by_stock_item_id_response import GetProductIdentifiersByStockItemIdResponse
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    request = linnworks_api.generated.inventory.GetProductIdentifiersBulkByStockItemIdRequest() # GetProductIdentifiersBulkByStockItemIdRequest | Object containing a list of stock item ids (optional)

    try:
        # GetProductIdentifiersBulkByStockItemId
        api_response = api_instance.get_product_identifiers_bulk_by_stock_item_id(request=request)
        print("The response of InventoryApi->get_product_identifiers_bulk_by_stock_item_id:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_product_identifiers_bulk_by_stock_item_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**GetProductIdentifiersBulkByStockItemIdRequest**](GetProductIdentifiersBulkByStockItemIdRequest.md)| Object containing a list of stock item ids | [optional] 

### Return type

[**GetProductIdentifiersByStockItemIdResponse**](GetProductIdentifiersByStockItemIdResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_product_identifiers_by_stock_item_id**
> GetProductIdentifiersByStockItemIdResponse get_product_identifiers_by_stock_item_id(inventory_get_product_identifiers_by_stock_item_id_request)

GetProductIdentifiersByStockItemId

Used to get product identifiers for a stock item <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_product_identifiers_by_stock_item_id_response import GetProductIdentifiersByStockItemIdResponse
from linnworks_api.generated.inventory.models.inventory_get_product_identifiers_by_stock_item_id_request import InventoryGetProductIdentifiersByStockItemIdRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_product_identifiers_by_stock_item_id_request = linnworks_api.generated.inventory.InventoryGetProductIdentifiersByStockItemIdRequest() # InventoryGetProductIdentifiersByStockItemIdRequest | 

    try:
        # GetProductIdentifiersByStockItemId
        api_response = api_instance.get_product_identifiers_by_stock_item_id(inventory_get_product_identifiers_by_stock_item_id_request)
        print("The response of InventoryApi->get_product_identifiers_by_stock_item_id:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_product_identifiers_by_stock_item_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_product_identifiers_by_stock_item_id_request** | [**InventoryGetProductIdentifiersByStockItemIdRequest**](InventoryGetProductIdentifiersByStockItemIdRequest.md)|  | 

### Return type

[**GetProductIdentifiersByStockItemIdResponse**](GetProductIdentifiersByStockItemIdResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_scannable_product_identifiers_by_order_ids**
> GetScannableProductIdentifiersByOrderIdsResponse get_scannable_product_identifiers_by_order_ids(request=request)

GetScannableProductIdentifiersByOrderIds

Use this call to get available Product Identifier types with extended information, eg related sources, scanned at dispatch <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_scannable_product_identifiers_by_order_ids_request import GetScannableProductIdentifiersByOrderIdsRequest
from linnworks_api.generated.inventory.models.get_scannable_product_identifiers_by_order_ids_response import GetScannableProductIdentifiersByOrderIdsResponse
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    request = linnworks_api.generated.inventory.GetScannableProductIdentifiersByOrderIdsRequest() # GetScannableProductIdentifiersByOrderIdsRequest |  (optional)

    try:
        # GetScannableProductIdentifiersByOrderIds
        api_response = api_instance.get_scannable_product_identifiers_by_order_ids(request=request)
        print("The response of InventoryApi->get_scannable_product_identifiers_by_order_ids:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_scannable_product_identifiers_by_order_ids: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**GetScannableProductIdentifiersByOrderIdsRequest**](GetScannableProductIdentifiersByOrderIdsRequest.md)|  | [optional] 

### Return type

[**GetScannableProductIdentifiersByOrderIdsResponse**](GetScannableProductIdentifiersByOrderIdsResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_scrap_categories**
> GetScrapCategoriesResponse get_scrap_categories()

GetScrapCategories

Used to get scrap categories <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItemsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_scrap_categories_response import GetScrapCategoriesResponse
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetScrapCategories
        api_response = api_instance.get_scrap_categories()
        print("The response of InventoryApi->get_scrap_categories:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_scrap_categories: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**GetScrapCategoriesResponse**](GetScrapCategoriesResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_scrap_history**
> GetScrapHistoryResponse get_scrap_history(inventory_get_scrap_history_request)

GetScrapHistory

Used to get scrap history <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapHistoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_scrap_history_response import GetScrapHistoryResponse
from linnworks_api.generated.inventory.models.inventory_get_scrap_history_request import InventoryGetScrapHistoryRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_scrap_history_request = linnworks_api.generated.inventory.InventoryGetScrapHistoryRequest() # InventoryGetScrapHistoryRequest | 

    try:
        # GetScrapHistory
        api_response = api_instance.get_scrap_history(inventory_get_scrap_history_request)
        print("The response of InventoryApi->get_scrap_history:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_scrap_history: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_scrap_history_request** | [**InventoryGetScrapHistoryRequest**](InventoryGetScrapHistoryRequest.md)|  | 

### Return type

[**GetScrapHistoryResponse**](GetScrapHistoryResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_stock_item_batches_by_location**
> GetStockItemBatchesByLocationResponse get_stock_item_batches_by_location(inventory_get_stock_item_batches_by_location_request)

GetStockItemBatchesByLocation

Used to get batch info by stock item id and location id <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_stock_item_batches_by_location_response import GetStockItemBatchesByLocationResponse
from linnworks_api.generated.inventory.models.inventory_get_stock_item_batches_by_location_request import InventoryGetStockItemBatchesByLocationRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_stock_item_batches_by_location_request = linnworks_api.generated.inventory.InventoryGetStockItemBatchesByLocationRequest() # InventoryGetStockItemBatchesByLocationRequest | 

    try:
        # GetStockItemBatchesByLocation
        api_response = api_instance.get_stock_item_batches_by_location(inventory_get_stock_item_batches_by_location_request)
        print("The response of InventoryApi->get_stock_item_batches_by_location:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_stock_item_batches_by_location: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_stock_item_batches_by_location_request** | [**InventoryGetStockItemBatchesByLocationRequest**](InventoryGetStockItemBatchesByLocationRequest.md)|  | 

### Return type

[**GetStockItemBatchesByLocationResponse**](GetStockItemBatchesByLocationResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_stock_item_ids_by_sku**
> GetStockItemIdsBySKU get_stock_item_ids_by_sku(inventory_get_stock_item_ids_by_sku_request)

GetStockItemIdsBySKU

Use this call to Get inventory item images <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockReadNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.get_stock_item_ids_by_sku import GetStockItemIdsBySKU
from linnworks_api.generated.inventory.models.inventory_get_stock_item_ids_by_sku_request import InventoryGetStockItemIdsBySKURequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_stock_item_ids_by_sku_request = linnworks_api.generated.inventory.InventoryGetStockItemIdsBySKURequest() # InventoryGetStockItemIdsBySKURequest | 

    try:
        # GetStockItemIdsBySKU
        api_response = api_instance.get_stock_item_ids_by_sku(inventory_get_stock_item_ids_by_sku_request)
        print("The response of InventoryApi->get_stock_item_ids_by_sku:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_stock_item_ids_by_sku: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_stock_item_ids_by_sku_request** | [**InventoryGetStockItemIdsBySKURequest**](InventoryGetStockItemIdsBySKURequest.md)|  | 

### Return type

[**GetStockItemIdsBySKU**](GetStockItemIdsBySKU.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_stock_item_labels**
> List[StockItemLabel] get_stock_item_labels(inventory_get_stock_item_labels_request)

GetStockItemLabels

Use this call to get labels by search token <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_get_stock_item_labels_request import InventoryGetStockItemLabelsRequest
from linnworks_api.generated.inventory.models.stock_item_label import StockItemLabel
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_get_stock_item_labels_request = linnworks_api.generated.inventory.InventoryGetStockItemLabelsRequest() # InventoryGetStockItemLabelsRequest | 

    try:
        # GetStockItemLabels
        api_response = api_instance.get_stock_item_labels(inventory_get_stock_item_labels_request)
        print("The response of InventoryApi->get_stock_item_labels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_stock_item_labels: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_get_stock_item_labels_request** | [**InventoryGetStockItemLabelsRequest**](InventoryGetStockItemLabelsRequest.md)|  | 

### Return type

[**List[StockItemLabel]**](StockItemLabel.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_stock_locations**
> List[StockLocation] get_stock_locations()

GetStockLocations

Use this call to get all stock locations <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_location import StockLocation
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetStockLocations
        api_response = api_instance.get_stock_locations()
        print("The response of InventoryApi->get_stock_locations:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_stock_locations: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[StockLocation]**](StockLocation.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_stock_supplier_stat**
> List[StockItemSupplierStat] get_stock_supplier_stat(inventory_item_id=inventory_item_id)

GetStockSupplierStat

Use this call to retrieve report about \"item supplier stat\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_supplier_stat import StockItemSupplierStat
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_item_id = 'inventory_item_id_example' # str | Used to specify report stock item id (optional)

    try:
        # GetStockSupplierStat
        api_response = api_instance.get_stock_supplier_stat(inventory_item_id=inventory_item_id)
        print("The response of InventoryApi->get_stock_supplier_stat:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_stock_supplier_stat: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_item_id** | **str**| Used to specify report stock item id | [optional] 

### Return type

[**List[StockItemSupplierStat]**](StockItemSupplierStat.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_stock_supplier_stats_bulk**
> List[StockItemSupplierStat] get_stock_supplier_stats_bulk(inventory_item_ids=inventory_item_ids)

GetStockSupplierStatsBulk

Use this call to retrieve report about \"item supplier stat\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.stock_item_supplier_stat import StockItemSupplierStat
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_item_ids = ['inventory_item_ids_example'] # List[str] | Used to specify report stock item ids (optional)

    try:
        # GetStockSupplierStatsBulk
        api_response = api_instance.get_stock_supplier_stats_bulk(inventory_item_ids=inventory_item_ids)
        print("The response of InventoryApi->get_stock_supplier_stats_bulk:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_stock_supplier_stats_bulk: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_item_ids** | [**List[str]**](str.md)| Used to specify report stock item ids | [optional] 

### Return type

[**List[StockItemSupplierStat]**](StockItemSupplierStat.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_supplier_details**
> Supplier get_supplier_details(supplier_id=supplier_id)

GetSupplierDetails

Use this call to retrieve details of one Supplier <b>Permissions Required: </b> GlobalPermissions.Inventory.InventorySettings.SuppliersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.supplier import Supplier
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    supplier_id = 'supplier_id_example' # str | Supplier ID (optional)

    try:
        # GetSupplierDetails
        api_response = api_instance.get_supplier_details(supplier_id=supplier_id)
        print("The response of InventoryApi->get_supplier_details:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_supplier_details: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **supplier_id** | **str**| Supplier ID | [optional] 

### Return type

[**Supplier**](Supplier.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_suppliers**
> List[Supplier] get_suppliers()

GetSuppliers

Use this call to retrieve list of all Suppliers' names <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.supplier import Supplier
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetSuppliers
        api_response = api_instance.get_suppliers()
        print("The response of InventoryApi->get_suppliers:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_suppliers: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[Supplier]**](Supplier.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_user_specific_views**
> List[InventoryView] get_user_specific_views()

GetUserSpecificViews

Use this call to get user-specific views from database <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_view import InventoryView
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)

    try:
        # GetUserSpecificViews
        api_response = api_instance.get_user_specific_views()
        print("The response of InventoryApi->get_user_specific_views:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->get_user_specific_views: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[InventoryView]**](InventoryView.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **has_stock_item_batches**
> bool has_stock_item_batches(stock_item_id=stock_item_id)

HasStockItemBatches

Used to check if stock item has batches <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    stock_item_id = 'stock_item_id_example' # str | Stock item unique identifier (optional)

    try:
        # HasStockItemBatches
        api_response = api_instance.has_stock_item_batches(stock_item_id=stock_item_id)
        print("The response of InventoryApi->has_stock_item_batches:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->has_stock_item_batches: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stock_item_id** | **str**| Stock item unique identifier | [optional] 

### Return type

**bool**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **has_stock_item_stock_level**
> HasStockItemStockLevelResponse has_stock_item_stock_level(inventory_has_stock_item_stock_level_request)

HasStockItemStockLevel

Used to check has stock item stock level or not <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.has_stock_item_stock_level_response import HasStockItemStockLevelResponse
from linnworks_api.generated.inventory.models.inventory_has_stock_item_stock_level_request import InventoryHasStockItemStockLevelRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_has_stock_item_stock_level_request = linnworks_api.generated.inventory.InventoryHasStockItemStockLevelRequest() # InventoryHasStockItemStockLevelRequest | 

    try:
        # HasStockItemStockLevel
        api_response = api_instance.has_stock_item_stock_level(inventory_has_stock_item_stock_level_request)
        print("The response of InventoryApi->has_stock_item_stock_level:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->has_stock_item_stock_level: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_has_stock_item_stock_level_request** | [**InventoryHasStockItemStockLevelRequest**](InventoryHasStockItemStockLevelRequest.md)|  | 

### Return type

[**HasStockItemStockLevelResponse**](HasStockItemStockLevelResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **insert_update_ebay_compatibility_list**
> InsertUpdateEbayCompatibilityListResponse insert_update_ebay_compatibility_list(inventory_insert_update_ebay_compatibility_list_request)

InsertUpdateEbayCompatibilityList

Use this call to insert and update a list of Ebay Compatibility <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.insert_update_ebay_compatibility_list_response import InsertUpdateEbayCompatibilityListResponse
from linnworks_api.generated.inventory.models.inventory_insert_update_ebay_compatibility_list_request import InventoryInsertUpdateEbayCompatibilityListRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_insert_update_ebay_compatibility_list_request = linnworks_api.generated.inventory.InventoryInsertUpdateEbayCompatibilityListRequest() # InventoryInsertUpdateEbayCompatibilityListRequest | 

    try:
        # InsertUpdateEbayCompatibilityList
        api_response = api_instance.insert_update_ebay_compatibility_list(inventory_insert_update_ebay_compatibility_list_request)
        print("The response of InventoryApi->insert_update_ebay_compatibility_list:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->insert_update_ebay_compatibility_list: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_insert_update_ebay_compatibility_list_request** | [**InventoryInsertUpdateEbayCompatibilityListRequest**](InventoryInsertUpdateEbayCompatibilityListRequest.md)|  | 

### Return type

[**InsertUpdateEbayCompatibilityListResponse**](InsertUpdateEbayCompatibilityListResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **is_inventory_item_channel_sku_linked**
> bool is_inventory_item_channel_sku_linked(channel_sku=channel_sku, source=source, sub_source=sub_source)

IsInventoryItemChannelSKULinked

Use this call to check if ChannelSKU is linked <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    channel_sku = 'channel_sku_example' # str | Product Channel SKU (optional)
    source = 'source_example' # str | ChannelName/Source (e.g. EBAY) (optional)
    sub_source = 'sub_source_example' # str | Subsource (e.g. EBAY1) (optional)

    try:
        # IsInventoryItemChannelSKULinked
        api_response = api_instance.is_inventory_item_channel_sku_linked(channel_sku=channel_sku, source=source, sub_source=sub_source)
        print("The response of InventoryApi->is_inventory_item_channel_sku_linked:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->is_inventory_item_channel_sku_linked: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **channel_sku** | **str**| Product Channel SKU | [optional] 
 **source** | **str**| ChannelName/Source (e.g. EBAY) | [optional] 
 **sub_source** | **str**| Subsource (e.g. EBAY1) | [optional] 

### Return type

**bool**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **is_owned_stock_location**
> bool is_owned_stock_location(location_id=location_id)

IsOwnedStockLocation

Checks whether a location is FBA or has an enabled inventory update import <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    location_id = 'location_id_example' # str | Location ID (optional)

    try:
        # IsOwnedStockLocation
        api_response = api_instance.is_owned_stock_location(location_id=location_id)
        print("The response of InventoryApi->is_owned_stock_location:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->is_owned_stock_location: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **location_id** | **str**| Location ID | [optional] 

### Return type

**bool**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **scrap_batched_item**
> ScrapBatchedItemResponse scrap_batched_item(inventory_scrap_batched_item_request)

ScrapBatchedItem

Used to scrap batched item <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapStockNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_scrap_batched_item_request import InventoryScrapBatchedItemRequest
from linnworks_api.generated.inventory.models.scrap_batched_item_response import ScrapBatchedItemResponse
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_scrap_batched_item_request = linnworks_api.generated.inventory.InventoryScrapBatchedItemRequest() # InventoryScrapBatchedItemRequest | 

    try:
        # ScrapBatchedItem
        api_response = api_instance.scrap_batched_item(inventory_scrap_batched_item_request)
        print("The response of InventoryApi->scrap_batched_item:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->scrap_batched_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_scrap_batched_item_request** | [**InventoryScrapBatchedItemRequest**](InventoryScrapBatchedItemRequest.md)|  | 

### Return type

[**ScrapBatchedItemResponse**](ScrapBatchedItemResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **set_inventory_item_image_as_main**
> set_inventory_item_image_as_main(inventory_set_inventory_item_image_as_main_request)

SetInventoryItemImageAsMain

Use this call to update inventory item main image <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_set_inventory_item_image_as_main_request import InventorySetInventoryItemImageAsMainRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_set_inventory_item_image_as_main_request = linnworks_api.generated.inventory.InventorySetInventoryItemImageAsMainRequest() # InventorySetInventoryItemImageAsMainRequest | 

    try:
        # SetInventoryItemImageAsMain
        api_instance.set_inventory_item_image_as_main(inventory_set_inventory_item_image_as_main_request)
    except Exception as e:
        print("Exception when calling InventoryApi->set_inventory_item_image_as_main: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_set_inventory_item_image_as_main_request** | [**InventorySetInventoryItemImageAsMainRequest**](InventorySetInventoryItemImageAsMainRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **unarchive_inventory_items**
> unarchive_inventory_items(inventory_unarchive_inventory_items_request)

UnarchiveInventoryItems

Use this call to unarchive inventory items <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_unarchive_inventory_items_request import InventoryUnarchiveInventoryItemsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_unarchive_inventory_items_request = linnworks_api.generated.inventory.InventoryUnarchiveInventoryItemsRequest() # InventoryUnarchiveInventoryItemsRequest | 

    try:
        # UnarchiveInventoryItems
        api_instance.unarchive_inventory_items(inventory_unarchive_inventory_items_request)
    except Exception as e:
        print("Exception when calling InventoryApi->unarchive_inventory_items: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_unarchive_inventory_items_request** | [**InventoryUnarchiveInventoryItemsRequest**](InventoryUnarchiveInventoryItemsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **unlink_channel_listing**
> unlink_channel_listing(inventory_unlink_channel_listing_request)

UnlinkChannelListing

Use this call to unlink  inventory listing from inventory item <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_unlink_channel_listing_request import InventoryUnlinkChannelListingRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_unlink_channel_listing_request = linnworks_api.generated.inventory.InventoryUnlinkChannelListingRequest() # InventoryUnlinkChannelListingRequest | 

    try:
        # UnlinkChannelListing
        api_instance.unlink_channel_listing(inventory_unlink_channel_listing_request)
    except Exception as e:
        print("Exception when calling InventoryApi->unlink_channel_listing: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_unlink_channel_listing_request** | [**InventoryUnlinkChannelListingRequest**](InventoryUnlinkChannelListingRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_batch_dates**
> UpdateBatchDatesResponse update_batch_dates(request=request)

UpdateBatchDates

 <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.update_batch_dates_request import UpdateBatchDatesRequest
from linnworks_api.generated.inventory.models.update_batch_dates_response import UpdateBatchDatesResponse
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    request = linnworks_api.generated.inventory.UpdateBatchDatesRequest() # UpdateBatchDatesRequest |  (optional)

    try:
        # UpdateBatchDates
        api_response = api_instance.update_batch_dates(request=request)
        print("The response of InventoryApi->update_batch_dates:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->update_batch_dates: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**UpdateBatchDatesRequest**](UpdateBatchDatesRequest.md)|  | [optional] 

### Return type

[**UpdateBatchDatesResponse**](UpdateBatchDatesResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_batch_details**
> update_batch_details(inventory_update_batch_details_request)

UpdateBatchDetails

Used to update batch details for stock item <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_batch_details_request import InventoryUpdateBatchDetailsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_batch_details_request = linnworks_api.generated.inventory.InventoryUpdateBatchDetailsRequest() # InventoryUpdateBatchDetailsRequest | 

    try:
        # UpdateBatchDetails
        api_instance.update_batch_details(inventory_update_batch_details_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_batch_details: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_batch_details_request** | [**InventoryUpdateBatchDetailsRequest**](InventoryUpdateBatchDetailsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_batches_with_inventory**
> update_batches_with_inventory(inventory_update_batches_with_inventory_request)

UpdateBatchesWithInventory

Used to update batches and batch inventory info <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_batches_with_inventory_request import InventoryUpdateBatchesWithInventoryRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_batches_with_inventory_request = linnworks_api.generated.inventory.InventoryUpdateBatchesWithInventoryRequest() # InventoryUpdateBatchesWithInventoryRequest | 

    try:
        # UpdateBatchesWithInventory
        api_instance.update_batches_with_inventory(inventory_update_batches_with_inventory_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_batches_with_inventory: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_batches_with_inventory_request** | [**InventoryUpdateBatchesWithInventoryRequest**](InventoryUpdateBatchesWithInventoryRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_category**
> update_category(inventory_update_category_request)

UpdateCategory

Use this call to update category name <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_category_request import InventoryUpdateCategoryRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_category_request = linnworks_api.generated.inventory.InventoryUpdateCategoryRequest() # InventoryUpdateCategoryRequest | 

    try:
        # UpdateCategory
        api_instance.update_category(inventory_update_category_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_category: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_category_request** | [**InventoryUpdateCategoryRequest**](InventoryUpdateCategoryRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_composite_parent_stock_level**
> int update_composite_parent_stock_level(inventory_update_composite_parent_stock_level_request)

UpdateCompositeParentStockLevel

Updates the stock level of the composite parent item <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_composite_parent_stock_level_request import InventoryUpdateCompositeParentStockLevelRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_composite_parent_stock_level_request = linnworks_api.generated.inventory.InventoryUpdateCompositeParentStockLevelRequest() # InventoryUpdateCompositeParentStockLevelRequest | 

    try:
        # UpdateCompositeParentStockLevel
        api_response = api_instance.update_composite_parent_stock_level(inventory_update_composite_parent_stock_level_request)
        print("The response of InventoryApi->update_composite_parent_stock_level:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->update_composite_parent_stock_level: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_composite_parent_stock_level_request** | [**InventoryUpdateCompositeParentStockLevelRequest**](InventoryUpdateCompositeParentStockLevelRequest.md)|  | 

### Return type

**int**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_countries**
> update_countries(inventory_update_countries_request)

UpdateCountries

Use this call to udpate countries <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_countries_request import InventoryUpdateCountriesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_countries_request = linnworks_api.generated.inventory.InventoryUpdateCountriesRequest() # InventoryUpdateCountriesRequest | 

    try:
        # UpdateCountries
        api_instance.update_countries(inventory_update_countries_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_countries: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_countries_request** | [**InventoryUpdateCountriesRequest**](InventoryUpdateCountriesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_country_regions**
> update_country_regions(inventory_update_country_regions_request)

UpdateCountryRegions

Update regions for country <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_country_regions_request import InventoryUpdateCountryRegionsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_country_regions_request = linnworks_api.generated.inventory.InventoryUpdateCountryRegionsRequest() # InventoryUpdateCountryRegionsRequest | 

    try:
        # UpdateCountryRegions
        api_instance.update_country_regions(inventory_update_country_regions_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_country_regions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_country_regions_request** | [**InventoryUpdateCountryRegionsRequest**](InventoryUpdateCountryRegionsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_images**
> update_images(inventory_update_images_request)

UpdateImages

Update properties on images <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_images_request import InventoryUpdateImagesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_images_request = linnworks_api.generated.inventory.InventoryUpdateImagesRequest() # InventoryUpdateImagesRequest | 

    try:
        # UpdateImages
        api_instance.update_images(inventory_update_images_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_images: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_images_request** | [**InventoryUpdateImagesRequest**](InventoryUpdateImagesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item**
> update_inventory_item(inventory_update_inventory_item_request)

UpdateInventoryItem

Use this call to update stock items. This acts as a set endpoint, all data for the stock item will be replaced, even if not provided in the request.  The only exception is StockItemId. If left empty, the item to update will be identified by ItemNumber. <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_request import InventoryUpdateInventoryItemRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemRequest() # InventoryUpdateInventoryItemRequest | 

    try:
        # UpdateInventoryItem
        api_instance.update_inventory_item(inventory_update_inventory_item_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_request** | [**InventoryUpdateInventoryItemRequest**](InventoryUpdateInventoryItemRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_channel_skus**
> update_inventory_item_channel_skus(inventory_update_inventory_item_channel_skus_request)

UpdateInventoryItemChannelSKUs

Update inventory Channel SKU's properties, such as Max Listed Quantity <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_channel_skus_request import InventoryUpdateInventoryItemChannelSKUsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_channel_skus_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemChannelSKUsRequest() # InventoryUpdateInventoryItemChannelSKUsRequest | 

    try:
        # UpdateInventoryItemChannelSKUs
        api_instance.update_inventory_item_channel_skus(inventory_update_inventory_item_channel_skus_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_channel_skus: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_channel_skus_request** | [**InventoryUpdateInventoryItemChannelSKUsRequest**](InventoryUpdateInventoryItemChannelSKUsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_channel_skus_with_location**
> update_inventory_item_channel_skus_with_location(inventory_update_inventory_item_channel_skus_with_location_request)

UpdateInventoryItemChannelSKUsWithLocation

Update inventory Channel SKU's with location properties, such as Max Listed Quantity <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_channel_skus_with_location_request import InventoryUpdateInventoryItemChannelSKUsWithLocationRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_channel_skus_with_location_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemChannelSKUsWithLocationRequest() # InventoryUpdateInventoryItemChannelSKUsWithLocationRequest | 

    try:
        # UpdateInventoryItemChannelSKUsWithLocation
        api_instance.update_inventory_item_channel_skus_with_location(inventory_update_inventory_item_channel_skus_with_location_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_channel_skus_with_location: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_channel_skus_with_location_request** | [**InventoryUpdateInventoryItemChannelSKUsWithLocationRequest**](InventoryUpdateInventoryItemChannelSKUsWithLocationRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_compositions**
> update_inventory_item_compositions(inventory_update_inventory_item_compositions_request)

UpdateInventoryItemCompositions

Use this call to update stockItem compositions <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_compositions_request import InventoryUpdateInventoryItemCompositionsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_compositions_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemCompositionsRequest() # InventoryUpdateInventoryItemCompositionsRequest | 

    try:
        # UpdateInventoryItemCompositions
        api_instance.update_inventory_item_compositions(inventory_update_inventory_item_compositions_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_compositions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_compositions_request** | [**InventoryUpdateInventoryItemCompositionsRequest**](InventoryUpdateInventoryItemCompositionsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_descriptions**
> update_inventory_item_descriptions(inventory_update_inventory_item_descriptions_request)

UpdateInventoryItemDescriptions

Use this call to update stockitem Descriptions <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_descriptions_request import InventoryUpdateInventoryItemDescriptionsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_descriptions_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemDescriptionsRequest() # InventoryUpdateInventoryItemDescriptionsRequest | 

    try:
        # UpdateInventoryItemDescriptions
        api_instance.update_inventory_item_descriptions(inventory_update_inventory_item_descriptions_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_descriptions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_descriptions_request** | [**InventoryUpdateInventoryItemDescriptionsRequest**](InventoryUpdateInventoryItemDescriptionsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_extended_properties**
> update_inventory_item_extended_properties(inventory_update_inventory_item_extended_properties_request)

UpdateInventoryItemExtendedProperties

Use this call to update stockitem Extended Properties <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_extended_properties_request import InventoryUpdateInventoryItemExtendedPropertiesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_extended_properties_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemExtendedPropertiesRequest() # InventoryUpdateInventoryItemExtendedPropertiesRequest | 

    try:
        # UpdateInventoryItemExtendedProperties
        api_instance.update_inventory_item_extended_properties(inventory_update_inventory_item_extended_properties_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_extended_properties: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_extended_properties_request** | [**InventoryUpdateInventoryItemExtendedPropertiesRequest**](InventoryUpdateInventoryItemExtendedPropertiesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_field**
> Dict[str, object] update_inventory_item_field(inventory_update_inventory_item_field_request)

UpdateInventoryItemField

 <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_field_request import InventoryUpdateInventoryItemFieldRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_field_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemFieldRequest() # InventoryUpdateInventoryItemFieldRequest | 

    try:
        # UpdateInventoryItemField
        api_response = api_instance.update_inventory_item_field(inventory_update_inventory_item_field_request)
        print("The response of InventoryApi->update_inventory_item_field:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_field: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_field_request** | [**InventoryUpdateInventoryItemFieldRequest**](InventoryUpdateInventoryItemFieldRequest.md)|  | 

### Return type

**Dict[str, object]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_levels**
> Dict[str, Dict[str, object]] update_inventory_item_levels(inventory_update_inventory_item_levels_request)

UpdateInventoryItemLevels

Update and return stock level records for the stock item and any composite related items <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockLevelsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_levels_request import InventoryUpdateInventoryItemLevelsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_levels_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemLevelsRequest() # InventoryUpdateInventoryItemLevelsRequest | 

    try:
        # UpdateInventoryItemLevels
        api_response = api_instance.update_inventory_item_levels(inventory_update_inventory_item_levels_request)
        print("The response of InventoryApi->update_inventory_item_levels:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_levels: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_levels_request** | [**InventoryUpdateInventoryItemLevelsRequest**](InventoryUpdateInventoryItemLevelsRequest.md)|  | 

### Return type

**Dict[str, Dict[str, object]]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_location_field**
> Dict[str, object] update_inventory_item_location_field(inventory_update_inventory_item_location_field_request)

UpdateInventoryItemLocationField

Update and return stock level records for the stock item <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemBinRackNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_location_field_request import InventoryUpdateInventoryItemLocationFieldRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_location_field_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemLocationFieldRequest() # InventoryUpdateInventoryItemLocationFieldRequest | 

    try:
        # UpdateInventoryItemLocationField
        api_response = api_instance.update_inventory_item_location_field(inventory_update_inventory_item_location_field_request)
        print("The response of InventoryApi->update_inventory_item_location_field:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_location_field: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_location_field_request** | [**InventoryUpdateInventoryItemLocationFieldRequest**](InventoryUpdateInventoryItemLocationFieldRequest.md)|  | 

### Return type

**Dict[str, object]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_prices**
> update_inventory_item_prices(inventory_update_inventory_item_prices_request)

UpdateInventoryItemPrices

Use this call to update stock item prices <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_prices_request import InventoryUpdateInventoryItemPricesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_prices_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemPricesRequest() # InventoryUpdateInventoryItemPricesRequest | 

    try:
        # UpdateInventoryItemPrices
        api_instance.update_inventory_item_prices(inventory_update_inventory_item_prices_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_prices: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_prices_request** | [**InventoryUpdateInventoryItemPricesRequest**](InventoryUpdateInventoryItemPricesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_pricing_rules**
> update_inventory_item_pricing_rules(inventory_update_inventory_item_pricing_rules_request)

UpdateInventoryItemPricingRules

Use this call to update stock item price rules <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_pricing_rules_request import InventoryUpdateInventoryItemPricingRulesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_pricing_rules_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemPricingRulesRequest() # InventoryUpdateInventoryItemPricingRulesRequest | 

    try:
        # UpdateInventoryItemPricingRules
        api_instance.update_inventory_item_pricing_rules(inventory_update_inventory_item_pricing_rules_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_pricing_rules: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_pricing_rules_request** | [**InventoryUpdateInventoryItemPricingRulesRequest**](InventoryUpdateInventoryItemPricingRulesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_stock_field**
> Dict[str, object] update_inventory_item_stock_field(inventory_update_inventory_item_stock_field_request)

UpdateInventoryItemStockField

Update and return stock level <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_stock_field_request import InventoryUpdateInventoryItemStockFieldRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_stock_field_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemStockFieldRequest() # InventoryUpdateInventoryItemStockFieldRequest | 

    try:
        # UpdateInventoryItemStockField
        api_response = api_instance.update_inventory_item_stock_field(inventory_update_inventory_item_stock_field_request)
        print("The response of InventoryApi->update_inventory_item_stock_field:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_stock_field: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_stock_field_request** | [**InventoryUpdateInventoryItemStockFieldRequest**](InventoryUpdateInventoryItemStockFieldRequest.md)|  | 

### Return type

**Dict[str, object]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_inventory_item_titles**
> update_inventory_item_titles(inventory_update_inventory_item_titles_request)

UpdateInventoryItemTitles

Use this call to update stockitem Titles <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_inventory_item_titles_request import InventoryUpdateInventoryItemTitlesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_inventory_item_titles_request = linnworks_api.generated.inventory.InventoryUpdateInventoryItemTitlesRequest() # InventoryUpdateInventoryItemTitlesRequest | 

    try:
        # UpdateInventoryItemTitles
        api_instance.update_inventory_item_titles(inventory_update_inventory_item_titles_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_inventory_item_titles: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_inventory_item_titles_request** | [**InventoryUpdateInventoryItemTitlesRequest**](InventoryUpdateInventoryItemTitlesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_item_locations**
> update_item_locations(inventory_update_item_locations_request)

UpdateItemLocations

Use this call to update stock item locations bin/rack <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemBinRackNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_item_locations_request import InventoryUpdateItemLocationsRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_item_locations_request = linnworks_api.generated.inventory.InventoryUpdateItemLocationsRequest() # InventoryUpdateItemLocationsRequest | 

    try:
        # UpdateItemLocations
        api_instance.update_item_locations(inventory_update_item_locations_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_item_locations: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_item_locations_request** | [**InventoryUpdateItemLocationsRequest**](InventoryUpdateItemLocationsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_product_identifiers**
> update_product_identifiers(inventory_update_product_identifiers_request)

UpdateProductIdentifiers

Used to update product identifiers <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_product_identifiers_request import InventoryUpdateProductIdentifiersRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_product_identifiers_request = linnworks_api.generated.inventory.InventoryUpdateProductIdentifiersRequest() # InventoryUpdateProductIdentifiersRequest | 

    try:
        # UpdateProductIdentifiers
        api_instance.update_product_identifiers(inventory_update_product_identifiers_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_product_identifiers: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_product_identifiers_request** | [**InventoryUpdateProductIdentifiersRequest**](InventoryUpdateProductIdentifiersRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_scrap_categories**
> update_scrap_categories(inventory_update_scrap_categories_request)

UpdateScrapCategories

Used to update scrap categories <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapCategoriesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_scrap_categories_request import InventoryUpdateScrapCategoriesRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_scrap_categories_request = linnworks_api.generated.inventory.InventoryUpdateScrapCategoriesRequest() # InventoryUpdateScrapCategoriesRequest | 

    try:
        # UpdateScrapCategories
        api_instance.update_scrap_categories(inventory_update_scrap_categories_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_scrap_categories: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_scrap_categories_request** | [**InventoryUpdateScrapCategoriesRequest**](InventoryUpdateScrapCategoriesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_stock_supplier_stat**
> update_stock_supplier_stat(inventory_update_stock_supplier_stat_request)

UpdateStockSupplierStat

Use this call to update item supplier stat <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_stock_supplier_stat_request import InventoryUpdateStockSupplierStatRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_stock_supplier_stat_request = linnworks_api.generated.inventory.InventoryUpdateStockSupplierStatRequest() # InventoryUpdateStockSupplierStatRequest | 

    try:
        # UpdateStockSupplierStat
        api_instance.update_stock_supplier_stat(inventory_update_stock_supplier_stat_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_stock_supplier_stat: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_stock_supplier_stat_request** | [**InventoryUpdateStockSupplierStatRequest**](InventoryUpdateStockSupplierStatRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_supplier**
> update_supplier(inventory_update_supplier_request)

UpdateSupplier

Use this call to update supplier <b>Permissions Required: </b> GlobalPermissions.Inventory.InventorySettings.SuppliersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_supplier_request import InventoryUpdateSupplierRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_supplier_request = linnworks_api.generated.inventory.InventoryUpdateSupplierRequest() # InventoryUpdateSupplierRequest | 

    try:
        # UpdateSupplier
        api_instance.update_supplier(inventory_update_supplier_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_supplier: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_supplier_request** | [**InventoryUpdateSupplierRequest**](InventoryUpdateSupplierRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_user_specific_view**
> update_user_specific_view(inventory_update_user_specific_view_request)

UpdateUserSpecificView

Use this call to update an existing user-specific view <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_update_user_specific_view_request import InventoryUpdateUserSpecificViewRequest
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_update_user_specific_view_request = linnworks_api.generated.inventory.InventoryUpdateUserSpecificViewRequest() # InventoryUpdateUserSpecificViewRequest | 

    try:
        # UpdateUserSpecificView
        api_instance.update_user_specific_view(inventory_update_user_specific_view_request)
    except Exception as e:
        print("Exception when calling InventoryApi->update_user_specific_view: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_update_user_specific_view_request** | [**InventoryUpdateUserSpecificViewRequest**](InventoryUpdateUserSpecificViewRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **upload_images_to_inventory_item**
> List[PictureSource] upload_images_to_inventory_item(inventory_upload_images_to_inventory_item_request)

UploadImagesToInventoryItem

Use this call to upload images from Uploader to StockItem <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.inventory
from linnworks_api.generated.inventory.models.inventory_upload_images_to_inventory_item_request import InventoryUploadImagesToInventoryItemRequest
from linnworks_api.generated.inventory.models.picture_source import PictureSource
from linnworks_api.generated.inventory.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.inventory.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.inventory.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.inventory.InventoryApi(api_client)
    inventory_upload_images_to_inventory_item_request = linnworks_api.generated.inventory.InventoryUploadImagesToInventoryItemRequest() # InventoryUploadImagesToInventoryItemRequest | 

    try:
        # UploadImagesToInventoryItem
        api_response = api_instance.upload_images_to_inventory_item(inventory_upload_images_to_inventory_item_request)
        print("The response of InventoryApi->upload_images_to_inventory_item:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling InventoryApi->upload_images_to_inventory_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_upload_images_to_inventory_item_request** | [**InventoryUploadImagesToInventoryItemRequest**](InventoryUploadImagesToInventoryItemRequest.md)|  | 

### Return type

[**List[PictureSource]**](PictureSource.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

