# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.inventory.models.custom_attribute_data import CustomAttributeData
from linnworks_api.generated.inventory.models.member_info import MemberInfo
from typing import Optional, Set
from typing_extensions import Self

class ParameterInfo(BaseModel):
    """
    ParameterInfo
    """ # noqa: E501
    parameter_type: Optional[StrictStr] = Field(default=None, alias="ParameterType")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    has_default_value: Optional[StrictBool] = Field(default=None, alias="HasDefaultValue")
    default_value: Optional[Dict[str, Any]] = Field(default=None, alias="DefaultValue")
    raw_default_value: Optional[Dict[str, Any]] = Field(default=None, alias="RawDefaultValue")
    position: Optional[StrictInt] = Field(default=None, alias="Position")
    attributes: Optional[StrictStr] = Field(default=None, alias="Attributes")
    member: Optional[MemberInfo] = Field(default=None, alias="Member")
    is_in: Optional[StrictBool] = Field(default=None, alias="IsIn")
    is_out: Optional[StrictBool] = Field(default=None, alias="IsOut")
    is_lcid: Optional[StrictBool] = Field(default=None, alias="IsLcid")
    is_retval: Optional[StrictBool] = Field(default=None, alias="IsRetval")
    is_optional: Optional[StrictBool] = Field(default=None, alias="IsOptional")
    metadata_token: Optional[StrictInt] = Field(default=None, alias="MetadataToken")
    custom_attributes: Optional[List[CustomAttributeData]] = Field(default=None, alias="CustomAttributes")
    __properties: ClassVar[List[str]] = ["ParameterType", "Name", "HasDefaultValue", "DefaultValue", "RawDefaultValue", "Position", "Attributes", "Member", "IsIn", "IsOut", "IsLcid", "IsRetval", "IsOptional", "MetadataToken", "CustomAttributes"]

    @field_validator('attributes')
    def attributes_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['None', 'In', 'Out', 'Lcid', 'Retval', 'Optional', 'ReservedMask', 'HasDefault', 'HasFieldMarshal', 'Reserved3', 'Reserved4']):
            raise ValueError("must be one of enum values ('None', 'In', 'Out', 'Lcid', 'Retval', 'Optional', 'ReservedMask', 'HasDefault', 'HasFieldMarshal', 'Reserved3', 'Reserved4')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ParameterInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "parameter_type",
            "name",
            "has_default_value",
            "default_value",
            "raw_default_value",
            "position",
            "attributes",
            "is_in",
            "is_out",
            "is_lcid",
            "is_retval",
            "is_optional",
            "metadata_token",
            "custom_attributes",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of member
        if self.member:
            _dict['Member'] = self.member.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in custom_attributes (list)
        _items = []
        if self.custom_attributes:
            for _item_custom_attributes in self.custom_attributes:
                if _item_custom_attributes:
                    _items.append(_item_custom_attributes.to_dict())
            _dict['CustomAttributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ParameterInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ParameterType": obj.get("ParameterType"),
            "Name": obj.get("Name"),
            "HasDefaultValue": obj.get("HasDefaultValue"),
            "DefaultValue": obj.get("DefaultValue"),
            "RawDefaultValue": obj.get("RawDefaultValue"),
            "Position": obj.get("Position"),
            "Attributes": obj.get("Attributes"),
            "Member": MemberInfo.from_dict(obj["Member"]) if obj.get("Member") is not None else None,
            "IsIn": obj.get("IsIn"),
            "IsOut": obj.get("IsOut"),
            "IsLcid": obj.get("IsLcid"),
            "IsRetval": obj.get("IsRetval"),
            "IsOptional": obj.get("IsOptional"),
            "MetadataToken": obj.get("MetadataToken"),
            "CustomAttributes": [CustomAttributeData.from_dict(_item) for _item in obj["CustomAttributes"]] if obj.get("CustomAttributes") is not None else None
        })
        return _obj


