# coding: utf-8

"""
    Listings API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: listings
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.listings.models.amazon_attribute import AmazonAttribute
from linnworks_api.generated.listings.models.amazon_b_node import AmazonBNode
from linnworks_api.generated.listings.models.amazon_variation import AmazonVariation
from linnworks_api.generated.listings.models.key_value_generic_guid_double import KeyValueGenericGuidDouble
from typing import Optional, Set
from typing_extensions import Self

class AmazonListing(BaseModel):
    """
    AmazonListing
    """ # noqa: E501
    template_id: Optional[StrictStr] = Field(default=None, alias="TemplateId")
    inventory_item_id: Optional[StrictStr] = Field(default=None, alias="InventoryItemId")
    variation_group_name: Optional[StrictStr] = Field(default=None, alias="VariationGroupName")
    version: Optional[StrictInt] = Field(default=None, alias="Version")
    merchant_name: Optional[StrictStr] = Field(default=None, alias="MerchantName")
    config_id: Optional[StrictStr] = Field(default=None, alias="ConfigId")
    config_name: Optional[StrictStr] = Field(default=None, alias="ConfigName")
    product_url: Optional[StrictStr] = Field(default=None, alias="ProductURL")
    image_url: Optional[StrictStr] = Field(default=None, alias="ImageURL")
    title: Optional[StrictStr] = Field(default=None, alias="Title")
    description: Optional[StrictStr] = Field(default=None, alias="Description")
    asin: Optional[StrictStr] = Field(default=None, alias="ASIN")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    barcode: Optional[StrictStr] = Field(default=None, alias="Barcode")
    barcode_type: Optional[StrictStr] = Field(default=None, alias="BarcodeType")
    title_source: Optional[StrictStr] = Field(default=None, alias="TitleSource")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Price")
    business_price: Optional[KeyValueGenericGuidDouble] = Field(default=None, alias="BusinessPrice")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    category: Optional[StrictStr] = Field(default=None, alias="Category")
    sub_type: Optional[StrictStr] = Field(default=None, alias="SubType")
    browse_nodes: Optional[List[AmazonBNode]] = Field(default=None, alias="BrowseNodes")
    attributes: Optional[List[AmazonAttribute]] = Field(default=None, alias="Attributes")
    pictures: Optional[List[AmazonAttribute]] = Field(default=None, alias="Pictures")
    use_main_item_images: Optional[StrictBool] = Field(default=None, alias="UseMainItemImages")
    variation_theme: Optional[StrictStr] = Field(default=None, alias="VariationTheme")
    variations: Optional[List[AmazonVariation]] = Field(default=None, alias="Variations")
    old_variations: Optional[List[AmazonVariation]] = Field(default=None, alias="OldVariations")
    status: Optional[StrictStr] = Field(default=None, alias="Status")
    is_read_only: Optional[StrictBool] = Field(default=None, alias="IsReadOnly")
    report_id: Optional[StrictStr] = Field(default=None, alias="ReportId")
    error_msg: Optional[StrictStr] = Field(default=None, alias="ErrorMsg")
    message_ids: Optional[List[StrictStr]] = Field(default=None, alias="MessageIds")
    ship_options: Optional[List[StrictStr]] = Field(default=None, alias="ShipOptions")
    is_catalog: Optional[StrictBool] = Field(default=None, alias="IsCatalog")
    condition_type: Optional[StrictStr] = Field(default=None, alias="ConditionType")
    condition_note: Optional[StrictStr] = Field(default=None, alias="ConditionNote")
    lowest_new_price_formated: Optional[StrictStr] = Field(default=None, alias="LowestNewPriceFormated")
    decimal_sales_rank: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="DecimalSalesRank")
    to_list: Optional[StrictBool] = Field(default=None, alias="ToList")
    matches: Optional[StrictInt] = Field(default=None, alias="Matches")
    no_matches: Optional[StrictBool] = Field(default=None, alias="NoMatches")
    adjustments: Optional[StrictInt] = Field(default=None, alias="Adjustments")
    is_re_feeded: Optional[StrictBool] = Field(default=None, alias="IsReFeeded")
    __properties: ClassVar[List[str]] = ["TemplateId", "InventoryItemId", "VariationGroupName", "Version", "MerchantName", "ConfigId", "ConfigName", "ProductURL", "ImageURL", "Title", "Description", "ASIN", "SKU", "Barcode", "BarcodeType", "TitleSource", "Price", "BusinessPrice", "Quantity", "Category", "SubType", "BrowseNodes", "Attributes", "Pictures", "UseMainItemImages", "VariationTheme", "Variations", "OldVariations", "Status", "IsReadOnly", "ReportId", "ErrorMsg", "MessageIds", "ShipOptions", "IsCatalog", "ConditionType", "ConditionNote", "LowestNewPriceFormated", "DecimalSalesRank", "ToList", "Matches", "NoMatches", "Adjustments", "IsReFeeded"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NOT_LISTED', 'OK', 'CREATING', 'UPDATING', 'UPDATING_PRICE', 'UPDATING_QUANTITY', 'UPDATING_IMAGES', 'CREATING_VARIATION', 'DELETING', 'SEARCHING_FOR_MATCHES', 'UPDATING_SHIPPING']):
            raise ValueError("must be one of enum values ('NOT_LISTED', 'OK', 'CREATING', 'UPDATING', 'UPDATING_PRICE', 'UPDATING_QUANTITY', 'UPDATING_IMAGES', 'CREATING_VARIATION', 'DELETING', 'SEARCHING_FOR_MATCHES', 'UPDATING_SHIPPING')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AmazonListing from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of business_price
        if self.business_price:
            _dict['BusinessPrice'] = self.business_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in browse_nodes (list)
        _items = []
        if self.browse_nodes:
            for _item_browse_nodes in self.browse_nodes:
                if _item_browse_nodes:
                    _items.append(_item_browse_nodes.to_dict())
            _dict['BrowseNodes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['Attributes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pictures (list)
        _items = []
        if self.pictures:
            for _item_pictures in self.pictures:
                if _item_pictures:
                    _items.append(_item_pictures.to_dict())
            _dict['Pictures'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in variations (list)
        _items = []
        if self.variations:
            for _item_variations in self.variations:
                if _item_variations:
                    _items.append(_item_variations.to_dict())
            _dict['Variations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in old_variations (list)
        _items = []
        if self.old_variations:
            for _item_old_variations in self.old_variations:
                if _item_old_variations:
                    _items.append(_item_old_variations.to_dict())
            _dict['OldVariations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AmazonListing from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "TemplateId": obj.get("TemplateId"),
            "InventoryItemId": obj.get("InventoryItemId"),
            "VariationGroupName": obj.get("VariationGroupName"),
            "Version": obj.get("Version"),
            "MerchantName": obj.get("MerchantName"),
            "ConfigId": obj.get("ConfigId"),
            "ConfigName": obj.get("ConfigName"),
            "ProductURL": obj.get("ProductURL"),
            "ImageURL": obj.get("ImageURL"),
            "Title": obj.get("Title"),
            "Description": obj.get("Description"),
            "ASIN": obj.get("ASIN"),
            "SKU": obj.get("SKU"),
            "Barcode": obj.get("Barcode"),
            "BarcodeType": obj.get("BarcodeType"),
            "TitleSource": obj.get("TitleSource"),
            "Price": obj.get("Price"),
            "BusinessPrice": KeyValueGenericGuidDouble.from_dict(obj["BusinessPrice"]) if obj.get("BusinessPrice") is not None else None,
            "Quantity": obj.get("Quantity"),
            "Category": obj.get("Category"),
            "SubType": obj.get("SubType"),
            "BrowseNodes": [AmazonBNode.from_dict(_item) for _item in obj["BrowseNodes"]] if obj.get("BrowseNodes") is not None else None,
            "Attributes": [AmazonAttribute.from_dict(_item) for _item in obj["Attributes"]] if obj.get("Attributes") is not None else None,
            "Pictures": [AmazonAttribute.from_dict(_item) for _item in obj["Pictures"]] if obj.get("Pictures") is not None else None,
            "UseMainItemImages": obj.get("UseMainItemImages"),
            "VariationTheme": obj.get("VariationTheme"),
            "Variations": [AmazonVariation.from_dict(_item) for _item in obj["Variations"]] if obj.get("Variations") is not None else None,
            "OldVariations": [AmazonVariation.from_dict(_item) for _item in obj["OldVariations"]] if obj.get("OldVariations") is not None else None,
            "Status": obj.get("Status"),
            "IsReadOnly": obj.get("IsReadOnly"),
            "ReportId": obj.get("ReportId"),
            "ErrorMsg": obj.get("ErrorMsg"),
            "MessageIds": obj.get("MessageIds"),
            "ShipOptions": obj.get("ShipOptions"),
            "IsCatalog": obj.get("IsCatalog"),
            "ConditionType": obj.get("ConditionType"),
            "ConditionNote": obj.get("ConditionNote"),
            "LowestNewPriceFormated": obj.get("LowestNewPriceFormated"),
            "DecimalSalesRank": obj.get("DecimalSalesRank"),
            "ToList": obj.get("ToList"),
            "Matches": obj.get("Matches"),
            "NoMatches": obj.get("NoMatches"),
            "Adjustments": obj.get("Adjustments"),
            "IsReFeeded": obj.get("IsReFeeded")
        })
        return _obj


