# coding: utf-8

"""
    Listings API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: listings
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class EBayItem(BaseModel):
    """
    EBayItem
    """ # noqa: E501
    item_number: Optional[StrictStr] = Field(default=None, alias="ItemNumber")
    title: Optional[StrictStr] = Field(default=None, alias="Title")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    mapped_by: Optional[StrictStr] = Field(default=None, alias="MappedBy")
    relist_pending: Optional[StrictBool] = Field(default=None, alias="RelistPending")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    is_suggested_to_link: Optional[StrictBool] = Field(default=None, alias="IsSuggestedToLink")
    is_linked: Optional[StrictBool] = Field(default=None, alias="IsLinked")
    channel_sku_row_id: Optional[StrictStr] = Field(default=None, alias="ChannelSKURowId")
    linked_item_id: Optional[StrictStr] = Field(default=None, alias="LinkedItemId")
    max_listed_quantity: Optional[StrictInt] = Field(default=None, alias="MaxListedQuantity")
    end_when_stock: Optional[StrictInt] = Field(default=None, alias="EndWhenStock")
    stock_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="StockPercentage")
    linked_item_sku: Optional[StrictStr] = Field(default=None, alias="LinkedItemSku")
    linked_item_title: Optional[StrictStr] = Field(default=None, alias="LinkedItemTitle")
    ignore_sync: Optional[StrictBool] = Field(default=None, alias="IgnoreSync")
    channel_reference_id: Optional[StrictStr] = Field(default=None, alias="ChannelReferenceId")
    stricken_off: Optional[StrictBool] = Field(default=None, alias="StrickenOff")
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="StockItemId")
    start_time: Optional[datetime] = Field(default=None, alias="StartTime")
    end_time: Optional[datetime] = Field(default=None, alias="EndTime")
    strike_off_date: Optional[datetime] = Field(default=None, alias="StrikeOffDate")
    strike_reason: Optional[StrictStr] = Field(default=None, alias="StrikeReason")
    linked_with: Optional[StrictStr] = Field(default=None, alias="LinkedWith")
    is_variation: Optional[StrictBool] = Field(default=None, alias="IsVariation")
    fixed_price: Optional[StrictBool] = Field(default=None, alias="FixedPrice")
    reslisted_from: Optional[StrictStr] = Field(default=None, alias="ReslistedFrom")
    list_id: Optional[StrictStr] = Field(default=None, alias="ListId")
    listing_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ListingPrice")
    variation_items: Optional[List[EBayItem]] = Field(default=None, alias="VariationItems")
    is_gtc: Optional[StrictBool] = Field(default=None, alias="IsGTC")
    is_active: Optional[StrictBool] = Field(default=None, alias="IsActive")
    is_match_by_title: Optional[StrictBool] = Field(default=None, alias="IsMatchByTitle")
    total_rows: Optional[StrictInt] = Field(default=None, alias="TotalRows")
    __properties: ClassVar[List[str]] = ["ItemNumber", "Title", "SKU", "MappedBy", "RelistPending", "Quantity", "IsSuggestedToLink", "IsLinked", "ChannelSKURowId", "LinkedItemId", "MaxListedQuantity", "EndWhenStock", "StockPercentage", "LinkedItemSku", "LinkedItemTitle", "IgnoreSync", "ChannelReferenceId", "StrickenOff", "StockItemId", "StartTime", "EndTime", "StrikeOffDate", "StrikeReason", "LinkedWith", "IsVariation", "FixedPrice", "ReslistedFrom", "ListId", "ListingPrice", "VariationItems", "IsGTC", "IsActive", "IsMatchByTitle", "TotalRows"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EBayItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "channel_reference_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in variation_items (list)
        _items = []
        if self.variation_items:
            for _item_variation_items in self.variation_items:
                if _item_variation_items:
                    _items.append(_item_variation_items.to_dict())
            _dict['VariationItems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EBayItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ItemNumber": obj.get("ItemNumber"),
            "Title": obj.get("Title"),
            "SKU": obj.get("SKU"),
            "MappedBy": obj.get("MappedBy"),
            "RelistPending": obj.get("RelistPending"),
            "Quantity": obj.get("Quantity"),
            "IsSuggestedToLink": obj.get("IsSuggestedToLink"),
            "IsLinked": obj.get("IsLinked"),
            "ChannelSKURowId": obj.get("ChannelSKURowId"),
            "LinkedItemId": obj.get("LinkedItemId"),
            "MaxListedQuantity": obj.get("MaxListedQuantity"),
            "EndWhenStock": obj.get("EndWhenStock"),
            "StockPercentage": obj.get("StockPercentage"),
            "LinkedItemSku": obj.get("LinkedItemSku"),
            "LinkedItemTitle": obj.get("LinkedItemTitle"),
            "IgnoreSync": obj.get("IgnoreSync"),
            "ChannelReferenceId": obj.get("ChannelReferenceId"),
            "StrickenOff": obj.get("StrickenOff"),
            "StockItemId": obj.get("StockItemId"),
            "StartTime": obj.get("StartTime"),
            "EndTime": obj.get("EndTime"),
            "StrikeOffDate": obj.get("StrikeOffDate"),
            "StrikeReason": obj.get("StrikeReason"),
            "LinkedWith": obj.get("LinkedWith"),
            "IsVariation": obj.get("IsVariation"),
            "FixedPrice": obj.get("FixedPrice"),
            "ReslistedFrom": obj.get("ReslistedFrom"),
            "ListId": obj.get("ListId"),
            "ListingPrice": obj.get("ListingPrice"),
            "VariationItems": [EBayItem.from_dict(_item) for _item in obj["VariationItems"]] if obj.get("VariationItems") is not None else None,
            "IsGTC": obj.get("IsGTC"),
            "IsActive": obj.get("IsActive"),
            "IsMatchByTitle": obj.get("IsMatchByTitle"),
            "TotalRows": obj.get("TotalRows")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
EBayItem.model_rebuild(raise_errors=False)

