# coding: utf-8

"""
    Listings API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: listings
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.listings.models.ebay_seller_profile import EbaySellerProfile
from linnworks_api.generated.listings.models.ebay_specification import EbaySpecification
from linnworks_api.generated.listings.models.key_value import KeyValue
from linnworks_api.generated.listings.models.linnworks_ebay_category import LinnworksEbayCategory
from linnworks_api.generated.listings.models.pickup_location_time import PickupLocationTime
from linnworks_api.generated.listings.models.shipping import Shipping
from typing import Optional, Set
from typing_extensions import Self

class EbayConfig(BaseModel):
    """
    EbayConfig
    """ # noqa: E501
    pk_config_id: Optional[StrictStr] = Field(default=None, alias="pkConfigId")
    config_name: Optional[StrictStr] = Field(default=None, alias="ConfigName")
    ebay_account: Optional[StrictStr] = Field(default=None, alias="EbayAccount")
    site: Optional[StrictStr] = Field(default=None, alias="Site")
    original_config_id: Optional[StrictStr] = Field(default=None, alias="OriginalConfigId")
    original_site: Optional[StrictStr] = Field(default=None, alias="OriginalSite")
    is_out_of_stock_feature_enabled: Optional[StrictBool] = Field(default=None, alias="IsOutOfStockFeatureEnabled")
    max_quantity: Optional[StrictInt] = Field(default=None, alias="MaxQuantity")
    min_quantity: Optional[StrictInt] = Field(default=None, alias="MinQuantity")
    max_quantity_per_buyer: Optional[StrictInt] = Field(default=None, alias="MaxQuantityPerBuyer")
    is_max_quantity_per_buyer_enabled: Optional[StrictBool] = Field(default=None, alias="IsMaxQuantityPerBuyerEnabled")
    show_in_inventory: Optional[StrictBool] = Field(default=None, alias="ShowInInventory")
    associated_templates: Optional[StrictInt] = Field(default=None, alias="AssociatedTemplates")
    associated_variations: Optional[StrictInt] = Field(default=None, alias="AssociatedVariations")
    listing_type: Optional[StrictStr] = Field(default=None, alias="ListingType")
    listing_duration: Optional[StrictStr] = Field(default=None, alias="ListingDuration")
    currency: Optional[StrictStr] = Field(default=None, alias="Currency")
    product_location_country: Optional[StrictStr] = Field(default=None, alias="ProductLocationCountry")
    product_location: Optional[StrictStr] = Field(default=None, alias="ProductLocation")
    postal_code: Optional[StrictStr] = Field(default=None, alias="PostalCode")
    product_location_country_extended_property: Optional[StrictStr] = Field(default=None, alias="ProductLocationCountryExtendedProperty")
    product_location_extended_property: Optional[StrictStr] = Field(default=None, alias="ProductLocationExtendedProperty")
    postal_code_extended_property: Optional[StrictStr] = Field(default=None, alias="PostalCodeExtendedProperty")
    payment_methods: Optional[List[KeyValue]] = Field(default=None, alias="PaymentMethods")
    paypal_email: Optional[StrictStr] = Field(default=None, alias="PaypalEmail")
    cod_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="CODCost")
    is_immediate_payment_required: Optional[StrictBool] = Field(default=None, alias="IsImmediatePaymentRequired")
    in_store_pickup: Optional[StrictBool] = Field(default=None, alias="InStorePickup")
    sold_one_bay: Optional[StrictBool] = Field(default=None, alias="SoldOneBay")
    return_accepted: Optional[KeyValue] = Field(default=None, alias="ReturnAccepted")
    return_refund: Optional[KeyValue] = Field(default=None, alias="ReturnRefund")
    return_paid_by: Optional[KeyValue] = Field(default=None, alias="ReturnPaidBy")
    return_within: Optional[KeyValue] = Field(default=None, alias="ReturnWithin")
    restocking_fee: Optional[KeyValue] = Field(default=None, alias="RestockingFee")
    return_policy: Optional[StrictStr] = Field(default=None, alias="ReturnPolicy")
    additional_checkout_instructions: Optional[StrictStr] = Field(default=None, alias="AdditionalCheckoutInstructions")
    description: Optional[StrictStr] = Field(default=None, alias="Description")
    global_shipping_program: Optional[StrictBool] = Field(default=None, alias="GlobalShippingProgram")
    promotional_shipping_discount: Optional[StrictBool] = Field(default=None, alias="PromotionalShippingDiscount")
    international_promotional_shipping_discount: Optional[StrictBool] = Field(default=None, alias="InternationalPromotionalShippingDiscount")
    domestic_shipping_rate_table: Optional[StrictBool] = Field(default=None, alias="DomesticShippingRateTable")
    international_shipping_rate_table: Optional[StrictBool] = Field(default=None, alias="InternationalShippingRateTable")
    domestic_shipping_profile_id: Optional[StrictStr] = Field(default=None, alias="DomesticShippingProfileId")
    international_shipping_profile_id: Optional[StrictStr] = Field(default=None, alias="InternationalShippingProfileId")
    domestic_shipping_profile_id_extended_property: Optional[StrictStr] = Field(default=None, alias="DomesticShippingProfileId_ExtendedProperty")
    international_shipping_profile_id_extended_property: Optional[StrictStr] = Field(default=None, alias="InternationalShippingProfileId_ExtendedProperty")
    maximum_dispatch_time: Optional[KeyValue] = Field(default=None, alias="MaximumDispatchTime")
    maximum_dispatch_time_extended_property: Optional[StrictStr] = Field(default=None, alias="MaximumDispatchTime_ExtendedProperty")
    domestic_shippings: Optional[List[Shipping]] = Field(default=None, alias="DomesticShippings")
    international_shippings: Optional[List[Shipping]] = Field(default=None, alias="InternationalShippings")
    flat_calculated_shipping: Optional[StrictStr] = Field(default=None, alias="FlatCalculatedShipping")
    shipping_package_type: Optional[StrictStr] = Field(default=None, alias="ShippingPackageType")
    excluded_locations: Optional[List[StrictStr]] = Field(default=None, alias="ExcludedLocations")
    shipping_locations: Optional[List[StrictStr]] = Field(default=None, alias="ShippingLocations")
    free_calculated_shipping_service_id: Optional[StrictStr] = Field(default=None, alias="FreeCalculatedShippingServiceId")
    is_extended_property_splittable: Optional[StrictBool] = Field(default=None, alias="IsExtendedPropertySplittable")
    is_auto_mapping_ext_prop_to_spec_enabled: Optional[StrictBool] = Field(default=None, alias="IsAutoMappingExtPropToSpecEnabled")
    is_variation_specification_limit_increased: Optional[StrictBool] = Field(default=None, alias="IsVariationSpecificationLimitIncreased")
    is_catalog: Optional[StrictBool] = Field(default=None, alias="IsCatalog")
    is_private_listing_enabled: Optional[StrictBool] = Field(default=None, alias="IsPrivateListingEnabled")
    is_list_internationally_enabled: Optional[StrictBool] = Field(default=None, alias="IsListInternationallyEnabled")
    is_best_offer_enabled: Optional[StrictBool] = Field(default=None, alias="IsBestOfferEnabled")
    is_tax_table_enabled: Optional[StrictBool] = Field(default=None, alias="IsTaxTableEnabled")
    is_vat_enabled: Optional[StrictBool] = Field(default=None, alias="IsVATEnabled")
    vat: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="VAT")
    vat_extended_property: Optional[StrictStr] = Field(default=None, alias="VatExtendedProperty")
    categories: Optional[List[LinnworksEbayCategory]] = Field(default=None, alias="Categories")
    store_categories: Optional[List[LinnworksEbayCategory]] = Field(default=None, alias="StoreCategories")
    old_categories: Optional[List[LinnworksEbayCategory]] = Field(default=None, alias="OldCategories")
    use_suggested_category: Optional[StrictBool] = Field(default=None, alias="UseSuggestedCategory")
    auto_convert_categories: Optional[StrictBool] = Field(default=None, alias="AutoConvertCategories")
    primary_category_extended_property: Optional[StrictStr] = Field(default=None, alias="PrimaryCategory_ExtendedProperty")
    secondary_category_extended_property: Optional[StrictStr] = Field(default=None, alias="SecondaryCategory_ExtendedProperty")
    store_primary_category_extended_property: Optional[StrictStr] = Field(default=None, alias="StorePrimaryCategory_ExtendedProperty")
    store_secondary_category_extended_property: Optional[StrictStr] = Field(default=None, alias="StoreSecondaryCategory_ExtendedProperty")
    variation_title_extended_property: Optional[StrictStr] = Field(default=None, alias="VariationTitle_ExtendedProperty")
    condition: Optional[KeyValue] = Field(default=None, alias="Condition")
    condition_extended_property: Optional[StrictStr] = Field(default=None, alias="Condition_ExtendedProperty")
    condition_note_extended_property: Optional[StrictStr] = Field(default=None, alias="ConditionNote_ExtendedProperty")
    barcode_extended_property: Optional[StrictStr] = Field(default=None, alias="Barcode_ExtendedProperty")
    multiple_identifiers_enabled: Optional[StrictBool] = Field(default=None, alias="MultipleIdentifiersEnabled")
    multiple_product_identifiers: Optional[List[StrictStr]] = Field(default=None, alias="MultipleProductIdentifiers")
    specifications: Optional[List[EbaySpecification]] = Field(default=None, alias="Specifications")
    variations: Optional[List[EbaySpecification]] = Field(default=None, alias="Variations")
    dont_use_variation_pictures: Optional[StrictBool] = Field(default=None, alias="DontUseVariationPictures")
    photo_display_code_type: Optional[StrictStr] = Field(default=None, alias="PhotoDisplayCodeType")
    auto_select_images: Optional[StrictBool] = Field(default=None, alias="AutoSelectImages")
    charity_organisation_id: Optional[StrictStr] = Field(default=None, alias="CharityOrganisationId")
    charity_donation_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="CharityDonationPercent")
    last_update_time: Optional[StrictInt] = Field(default=None, alias="LastUpdateTime")
    last_update_session_id: Optional[StrictStr] = Field(default=None, alias="LastUpdateSessionId")
    payment_profile: Optional[EbaySellerProfile] = Field(default=None, alias="PaymentProfile")
    return_profile: Optional[EbaySellerProfile] = Field(default=None, alias="ReturnProfile")
    shipping_profile: Optional[EbaySellerProfile] = Field(default=None, alias="ShippingProfile")
    pickup_location_times: Optional[List[PickupLocationTime]] = Field(default=None, alias="PickupLocationTimes")
    is_configurator_edited: Optional[StrictBool] = Field(default=None, alias="IsConfiguratorEdited")
    is_mapping_configurator: Optional[StrictBool] = Field(default=None, alias="IsMappingConfigurator")
    scheduling_enabled: Optional[StrictBool] = Field(default=None, alias="SchedulingEnabled")
    use_lots_enabled: Optional[StrictBool] = Field(default=None, alias="UseLotsEnabled")
    use_new_api: Optional[StrictBool] = Field(default=None, alias="UseNewApi")
    channel_location_identifier: Optional[StrictStr] = Field(default=None, alias="ChannelLocationIdentifier")
    dimension_measure: Optional[StrictStr] = Field(default=None, alias="DimensionMeasure")
    __properties: ClassVar[List[str]] = ["pkConfigId", "ConfigName", "EbayAccount", "Site", "OriginalConfigId", "OriginalSite", "IsOutOfStockFeatureEnabled", "MaxQuantity", "MinQuantity", "MaxQuantityPerBuyer", "IsMaxQuantityPerBuyerEnabled", "ShowInInventory", "AssociatedTemplates", "AssociatedVariations", "ListingType", "ListingDuration", "Currency", "ProductLocationCountry", "ProductLocation", "PostalCode", "ProductLocationCountryExtendedProperty", "ProductLocationExtendedProperty", "PostalCodeExtendedProperty", "PaymentMethods", "PaypalEmail", "CODCost", "IsImmediatePaymentRequired", "InStorePickup", "SoldOneBay", "ReturnAccepted", "ReturnRefund", "ReturnPaidBy", "ReturnWithin", "RestockingFee", "ReturnPolicy", "AdditionalCheckoutInstructions", "Description", "GlobalShippingProgram", "PromotionalShippingDiscount", "InternationalPromotionalShippingDiscount", "DomesticShippingRateTable", "InternationalShippingRateTable", "DomesticShippingProfileId", "InternationalShippingProfileId", "DomesticShippingProfileId_ExtendedProperty", "InternationalShippingProfileId_ExtendedProperty", "MaximumDispatchTime", "MaximumDispatchTime_ExtendedProperty", "DomesticShippings", "InternationalShippings", "FlatCalculatedShipping", "ShippingPackageType", "ExcludedLocations", "ShippingLocations", "FreeCalculatedShippingServiceId", "IsExtendedPropertySplittable", "IsAutoMappingExtPropToSpecEnabled", "IsVariationSpecificationLimitIncreased", "IsCatalog", "IsPrivateListingEnabled", "IsListInternationallyEnabled", "IsBestOfferEnabled", "IsTaxTableEnabled", "IsVATEnabled", "VAT", "VatExtendedProperty", "Categories", "StoreCategories", "OldCategories", "UseSuggestedCategory", "AutoConvertCategories", "PrimaryCategory_ExtendedProperty", "SecondaryCategory_ExtendedProperty", "StorePrimaryCategory_ExtendedProperty", "StoreSecondaryCategory_ExtendedProperty", "VariationTitle_ExtendedProperty", "Condition", "Condition_ExtendedProperty", "ConditionNote_ExtendedProperty", "Barcode_ExtendedProperty", "MultipleIdentifiersEnabled", "MultipleProductIdentifiers", "Specifications", "Variations", "DontUseVariationPictures", "PhotoDisplayCodeType", "AutoSelectImages", "CharityOrganisationId", "CharityDonationPercent", "LastUpdateTime", "LastUpdateSessionId", "PaymentProfile", "ReturnProfile", "ShippingProfile", "PickupLocationTimes", "IsConfiguratorEdited", "IsMappingConfigurator", "SchedulingEnabled", "UseLotsEnabled", "UseNewApi", "ChannelLocationIdentifier", "DimensionMeasure"]

    @field_validator('photo_display_code_type')
    def photo_display_code_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['None', 'SuperSize']):
            raise ValueError("must be one of enum values ('None', 'SuperSize')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EbayConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in payment_methods (list)
        _items = []
        if self.payment_methods:
            for _item_payment_methods in self.payment_methods:
                if _item_payment_methods:
                    _items.append(_item_payment_methods.to_dict())
            _dict['PaymentMethods'] = _items
        # override the default output from pydantic by calling `to_dict()` of return_accepted
        if self.return_accepted:
            _dict['ReturnAccepted'] = self.return_accepted.to_dict()
        # override the default output from pydantic by calling `to_dict()` of return_refund
        if self.return_refund:
            _dict['ReturnRefund'] = self.return_refund.to_dict()
        # override the default output from pydantic by calling `to_dict()` of return_paid_by
        if self.return_paid_by:
            _dict['ReturnPaidBy'] = self.return_paid_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of return_within
        if self.return_within:
            _dict['ReturnWithin'] = self.return_within.to_dict()
        # override the default output from pydantic by calling `to_dict()` of restocking_fee
        if self.restocking_fee:
            _dict['RestockingFee'] = self.restocking_fee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maximum_dispatch_time
        if self.maximum_dispatch_time:
            _dict['MaximumDispatchTime'] = self.maximum_dispatch_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in domestic_shippings (list)
        _items = []
        if self.domestic_shippings:
            for _item_domestic_shippings in self.domestic_shippings:
                if _item_domestic_shippings:
                    _items.append(_item_domestic_shippings.to_dict())
            _dict['DomesticShippings'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in international_shippings (list)
        _items = []
        if self.international_shippings:
            for _item_international_shippings in self.international_shippings:
                if _item_international_shippings:
                    _items.append(_item_international_shippings.to_dict())
            _dict['InternationalShippings'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in categories (list)
        _items = []
        if self.categories:
            for _item_categories in self.categories:
                if _item_categories:
                    _items.append(_item_categories.to_dict())
            _dict['Categories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in store_categories (list)
        _items = []
        if self.store_categories:
            for _item_store_categories in self.store_categories:
                if _item_store_categories:
                    _items.append(_item_store_categories.to_dict())
            _dict['StoreCategories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in old_categories (list)
        _items = []
        if self.old_categories:
            for _item_old_categories in self.old_categories:
                if _item_old_categories:
                    _items.append(_item_old_categories.to_dict())
            _dict['OldCategories'] = _items
        # override the default output from pydantic by calling `to_dict()` of condition
        if self.condition:
            _dict['Condition'] = self.condition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in specifications (list)
        _items = []
        if self.specifications:
            for _item_specifications in self.specifications:
                if _item_specifications:
                    _items.append(_item_specifications.to_dict())
            _dict['Specifications'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in variations (list)
        _items = []
        if self.variations:
            for _item_variations in self.variations:
                if _item_variations:
                    _items.append(_item_variations.to_dict())
            _dict['Variations'] = _items
        # override the default output from pydantic by calling `to_dict()` of payment_profile
        if self.payment_profile:
            _dict['PaymentProfile'] = self.payment_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of return_profile
        if self.return_profile:
            _dict['ReturnProfile'] = self.return_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of shipping_profile
        if self.shipping_profile:
            _dict['ShippingProfile'] = self.shipping_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in pickup_location_times (list)
        _items = []
        if self.pickup_location_times:
            for _item_pickup_location_times in self.pickup_location_times:
                if _item_pickup_location_times:
                    _items.append(_item_pickup_location_times.to_dict())
            _dict['PickupLocationTimes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EbayConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkConfigId": obj.get("pkConfigId"),
            "ConfigName": obj.get("ConfigName"),
            "EbayAccount": obj.get("EbayAccount"),
            "Site": obj.get("Site"),
            "OriginalConfigId": obj.get("OriginalConfigId"),
            "OriginalSite": obj.get("OriginalSite"),
            "IsOutOfStockFeatureEnabled": obj.get("IsOutOfStockFeatureEnabled"),
            "MaxQuantity": obj.get("MaxQuantity"),
            "MinQuantity": obj.get("MinQuantity"),
            "MaxQuantityPerBuyer": obj.get("MaxQuantityPerBuyer"),
            "IsMaxQuantityPerBuyerEnabled": obj.get("IsMaxQuantityPerBuyerEnabled"),
            "ShowInInventory": obj.get("ShowInInventory"),
            "AssociatedTemplates": obj.get("AssociatedTemplates"),
            "AssociatedVariations": obj.get("AssociatedVariations"),
            "ListingType": obj.get("ListingType"),
            "ListingDuration": obj.get("ListingDuration"),
            "Currency": obj.get("Currency"),
            "ProductLocationCountry": obj.get("ProductLocationCountry"),
            "ProductLocation": obj.get("ProductLocation"),
            "PostalCode": obj.get("PostalCode"),
            "ProductLocationCountryExtendedProperty": obj.get("ProductLocationCountryExtendedProperty"),
            "ProductLocationExtendedProperty": obj.get("ProductLocationExtendedProperty"),
            "PostalCodeExtendedProperty": obj.get("PostalCodeExtendedProperty"),
            "PaymentMethods": [KeyValue.from_dict(_item) for _item in obj["PaymentMethods"]] if obj.get("PaymentMethods") is not None else None,
            "PaypalEmail": obj.get("PaypalEmail"),
            "CODCost": obj.get("CODCost"),
            "IsImmediatePaymentRequired": obj.get("IsImmediatePaymentRequired"),
            "InStorePickup": obj.get("InStorePickup"),
            "SoldOneBay": obj.get("SoldOneBay"),
            "ReturnAccepted": KeyValue.from_dict(obj["ReturnAccepted"]) if obj.get("ReturnAccepted") is not None else None,
            "ReturnRefund": KeyValue.from_dict(obj["ReturnRefund"]) if obj.get("ReturnRefund") is not None else None,
            "ReturnPaidBy": KeyValue.from_dict(obj["ReturnPaidBy"]) if obj.get("ReturnPaidBy") is not None else None,
            "ReturnWithin": KeyValue.from_dict(obj["ReturnWithin"]) if obj.get("ReturnWithin") is not None else None,
            "RestockingFee": KeyValue.from_dict(obj["RestockingFee"]) if obj.get("RestockingFee") is not None else None,
            "ReturnPolicy": obj.get("ReturnPolicy"),
            "AdditionalCheckoutInstructions": obj.get("AdditionalCheckoutInstructions"),
            "Description": obj.get("Description"),
            "GlobalShippingProgram": obj.get("GlobalShippingProgram"),
            "PromotionalShippingDiscount": obj.get("PromotionalShippingDiscount"),
            "InternationalPromotionalShippingDiscount": obj.get("InternationalPromotionalShippingDiscount"),
            "DomesticShippingRateTable": obj.get("DomesticShippingRateTable"),
            "InternationalShippingRateTable": obj.get("InternationalShippingRateTable"),
            "DomesticShippingProfileId": obj.get("DomesticShippingProfileId"),
            "InternationalShippingProfileId": obj.get("InternationalShippingProfileId"),
            "DomesticShippingProfileId_ExtendedProperty": obj.get("DomesticShippingProfileId_ExtendedProperty"),
            "InternationalShippingProfileId_ExtendedProperty": obj.get("InternationalShippingProfileId_ExtendedProperty"),
            "MaximumDispatchTime": KeyValue.from_dict(obj["MaximumDispatchTime"]) if obj.get("MaximumDispatchTime") is not None else None,
            "MaximumDispatchTime_ExtendedProperty": obj.get("MaximumDispatchTime_ExtendedProperty"),
            "DomesticShippings": [Shipping.from_dict(_item) for _item in obj["DomesticShippings"]] if obj.get("DomesticShippings") is not None else None,
            "InternationalShippings": [Shipping.from_dict(_item) for _item in obj["InternationalShippings"]] if obj.get("InternationalShippings") is not None else None,
            "FlatCalculatedShipping": obj.get("FlatCalculatedShipping"),
            "ShippingPackageType": obj.get("ShippingPackageType"),
            "ExcludedLocations": obj.get("ExcludedLocations"),
            "ShippingLocations": obj.get("ShippingLocations"),
            "FreeCalculatedShippingServiceId": obj.get("FreeCalculatedShippingServiceId"),
            "IsExtendedPropertySplittable": obj.get("IsExtendedPropertySplittable"),
            "IsAutoMappingExtPropToSpecEnabled": obj.get("IsAutoMappingExtPropToSpecEnabled"),
            "IsVariationSpecificationLimitIncreased": obj.get("IsVariationSpecificationLimitIncreased"),
            "IsCatalog": obj.get("IsCatalog"),
            "IsPrivateListingEnabled": obj.get("IsPrivateListingEnabled"),
            "IsListInternationallyEnabled": obj.get("IsListInternationallyEnabled"),
            "IsBestOfferEnabled": obj.get("IsBestOfferEnabled"),
            "IsTaxTableEnabled": obj.get("IsTaxTableEnabled"),
            "IsVATEnabled": obj.get("IsVATEnabled"),
            "VAT": obj.get("VAT"),
            "VatExtendedProperty": obj.get("VatExtendedProperty"),
            "Categories": [LinnworksEbayCategory.from_dict(_item) for _item in obj["Categories"]] if obj.get("Categories") is not None else None,
            "StoreCategories": [LinnworksEbayCategory.from_dict(_item) for _item in obj["StoreCategories"]] if obj.get("StoreCategories") is not None else None,
            "OldCategories": [LinnworksEbayCategory.from_dict(_item) for _item in obj["OldCategories"]] if obj.get("OldCategories") is not None else None,
            "UseSuggestedCategory": obj.get("UseSuggestedCategory"),
            "AutoConvertCategories": obj.get("AutoConvertCategories"),
            "PrimaryCategory_ExtendedProperty": obj.get("PrimaryCategory_ExtendedProperty"),
            "SecondaryCategory_ExtendedProperty": obj.get("SecondaryCategory_ExtendedProperty"),
            "StorePrimaryCategory_ExtendedProperty": obj.get("StorePrimaryCategory_ExtendedProperty"),
            "StoreSecondaryCategory_ExtendedProperty": obj.get("StoreSecondaryCategory_ExtendedProperty"),
            "VariationTitle_ExtendedProperty": obj.get("VariationTitle_ExtendedProperty"),
            "Condition": KeyValue.from_dict(obj["Condition"]) if obj.get("Condition") is not None else None,
            "Condition_ExtendedProperty": obj.get("Condition_ExtendedProperty"),
            "ConditionNote_ExtendedProperty": obj.get("ConditionNote_ExtendedProperty"),
            "Barcode_ExtendedProperty": obj.get("Barcode_ExtendedProperty"),
            "MultipleIdentifiersEnabled": obj.get("MultipleIdentifiersEnabled"),
            "MultipleProductIdentifiers": obj.get("MultipleProductIdentifiers"),
            "Specifications": [EbaySpecification.from_dict(_item) for _item in obj["Specifications"]] if obj.get("Specifications") is not None else None,
            "Variations": [EbaySpecification.from_dict(_item) for _item in obj["Variations"]] if obj.get("Variations") is not None else None,
            "DontUseVariationPictures": obj.get("DontUseVariationPictures"),
            "PhotoDisplayCodeType": obj.get("PhotoDisplayCodeType"),
            "AutoSelectImages": obj.get("AutoSelectImages"),
            "CharityOrganisationId": obj.get("CharityOrganisationId"),
            "CharityDonationPercent": obj.get("CharityDonationPercent"),
            "LastUpdateTime": obj.get("LastUpdateTime"),
            "LastUpdateSessionId": obj.get("LastUpdateSessionId"),
            "PaymentProfile": EbaySellerProfile.from_dict(obj["PaymentProfile"]) if obj.get("PaymentProfile") is not None else None,
            "ReturnProfile": EbaySellerProfile.from_dict(obj["ReturnProfile"]) if obj.get("ReturnProfile") is not None else None,
            "ShippingProfile": EbaySellerProfile.from_dict(obj["ShippingProfile"]) if obj.get("ShippingProfile") is not None else None,
            "PickupLocationTimes": [PickupLocationTime.from_dict(_item) for _item in obj["PickupLocationTimes"]] if obj.get("PickupLocationTimes") is not None else None,
            "IsConfiguratorEdited": obj.get("IsConfiguratorEdited"),
            "IsMappingConfigurator": obj.get("IsMappingConfigurator"),
            "SchedulingEnabled": obj.get("SchedulingEnabled"),
            "UseLotsEnabled": obj.get("UseLotsEnabled"),
            "UseNewApi": obj.get("UseNewApi"),
            "ChannelLocationIdentifier": obj.get("ChannelLocationIdentifier"),
            "DimensionMeasure": obj.get("DimensionMeasure")
        })
        return _obj


