# coding: utf-8

"""
    Locations API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: locations
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetWarehouseTotesRequest(BaseModel):
    """
    GetWarehouseTotesRequest
    """ # noqa: E501
    location_id: Optional[StrictStr] = Field(default=None, description="Location Id of the TOTs", alias="LocationId")
    tote_barcode: Optional[StrictStr] = Field(default=None, description="(Optional) Barcode of the TOT. If provided the response will contain one record that matches exactly to the TotBarcode or returns an empty response if nothing is found. If not provided, empty string or null and TotId is null or not specified all TOTs for the warehouse will be returned.", alias="ToteBarcode")
    tot_id: Optional[StrictInt] = Field(default=None, description="(Optional) Id of the TOT, if specified TotBarcode is ignored. If null and TotBarcode not specified then returns all tots in the warehouse", alias="TotId")
    __properties: ClassVar[List[str]] = ["LocationId", "ToteBarcode", "TotId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetWarehouseTotesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetWarehouseTotesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "LocationId": obj.get("LocationId"),
            "ToteBarcode": obj.get("ToteBarcode"),
            "TotId": obj.get("TotId")
        })
        return _obj


