# coding: utf-8

"""
    Macros API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: macro
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.macro.models.macro_parameter import MacroParameter
from linnworks_api.generated.macro.models.named_schedule_configuration import NamedScheduleConfiguration
from typing import Optional, Set
from typing_extensions import Self

class MacroRegister(BaseModel):
    """
    MacroRegister
    """ # noqa: E501
    macro_id: Optional[StrictInt] = Field(default=None, alias="MacroId")
    application_name: Optional[StrictStr] = Field(default=None, alias="ApplicationName")
    macro_name: Optional[StrictStr] = Field(default=None, alias="MacroName")
    friendly_name: Optional[StrictStr] = Field(default=None, alias="FriendlyName")
    enabled: Optional[StrictBool] = Field(default=None, alias="Enabled")
    started: Optional[datetime] = Field(default=None, alias="Started")
    completed: Optional[datetime] = Field(default=None, alias="Completed")
    executing: Optional[StrictBool] = Field(default=None, alias="Executing")
    current_state: Optional[StrictStr] = Field(default=None, alias="CurrentState")
    parameters: Optional[List[MacroParameter]] = Field(default=None, alias="Parameters")
    specification: Optional[List[NamedScheduleConfiguration]] = Field(default=None, alias="Specification")
    time_zone_offset: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TimeZoneOffset")
    macro_type: Optional[StrictStr] = Field(default=None, alias="MacroType")
    migrated: Optional[StrictInt] = Field(default=None, alias="Migrated")
    __properties: ClassVar[List[str]] = ["MacroId", "ApplicationName", "MacroName", "FriendlyName", "Enabled", "Started", "Completed", "Executing", "CurrentState", "Parameters", "Specification", "TimeZoneOffset", "MacroType", "Migrated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MacroRegister from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item_parameters in self.parameters:
                if _item_parameters:
                    _items.append(_item_parameters.to_dict())
            _dict['Parameters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in specification (list)
        _items = []
        if self.specification:
            for _item_specification in self.specification:
                if _item_specification:
                    _items.append(_item_specification.to_dict())
            _dict['Specification'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MacroRegister from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "MacroId": obj.get("MacroId"),
            "ApplicationName": obj.get("ApplicationName"),
            "MacroName": obj.get("MacroName"),
            "FriendlyName": obj.get("FriendlyName"),
            "Enabled": obj.get("Enabled"),
            "Started": obj.get("Started"),
            "Completed": obj.get("Completed"),
            "Executing": obj.get("Executing"),
            "CurrentState": obj.get("CurrentState"),
            "Parameters": [MacroParameter.from_dict(_item) for _item in obj["Parameters"]] if obj.get("Parameters") is not None else None,
            "Specification": [NamedScheduleConfiguration.from_dict(_item) for _item in obj["Specification"]] if obj.get("Specification") is not None else None,
            "TimeZoneOffset": obj.get("TimeZoneOffset"),
            "MacroType": obj.get("MacroType"),
            "Migrated": obj.get("Migrated")
        })
        return _obj


