# coding: utf-8

"""
    Open Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: openorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.openorders.models.order_item_base import OrderItemBase
from linnworks_api.generated.openorders.models.product_identifier import ProductIdentifier
from typing import Optional, Set
from typing_extensions import Self

class OpenOrderItem(BaseModel):
    """
    OpenOrderItem
    """ # noqa: E501
    composite_child: Optional[List[OrderItemBase]] = Field(default=None, alias="CompositeChild")
    product_identifiers: Optional[List[ProductIdentifier]] = Field(default=None, alias="ProductIdentifiers")
    contains_composites: Optional[StrictBool] = Field(default=None, alias="ContainsComposites")
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="StockItemId")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    barcode_number: Optional[StrictStr] = Field(default=None, alias="BarcodeNumber")
    item_title: Optional[StrictStr] = Field(default=None, alias="ItemTitle")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    __properties: ClassVar[List[str]] = ["CompositeChild", "ProductIdentifiers", "ContainsComposites", "StockItemId", "SKU", "BarcodeNumber", "ItemTitle", "Quantity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OpenOrderItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "contains_composites",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in composite_child (list)
        _items = []
        if self.composite_child:
            for _item_composite_child in self.composite_child:
                if _item_composite_child:
                    _items.append(_item_composite_child.to_dict())
            _dict['CompositeChild'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in product_identifiers (list)
        _items = []
        if self.product_identifiers:
            for _item_product_identifiers in self.product_identifiers:
                if _item_product_identifiers:
                    _items.append(_item_product_identifiers.to_dict())
            _dict['ProductIdentifiers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OpenOrderItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CompositeChild": [OrderItemBase.from_dict(_item) for _item in obj["CompositeChild"]] if obj.get("CompositeChild") is not None else None,
            "ProductIdentifiers": [ProductIdentifier.from_dict(_item) for _item in obj["ProductIdentifiers"]] if obj.get("ProductIdentifiers") is not None else None,
            "ContainsComposites": obj.get("ContainsComposites"),
            "StockItemId": obj.get("StockItemId"),
            "SKU": obj.get("SKU"),
            "BarcodeNumber": obj.get("BarcodeNumber"),
            "ItemTitle": obj.get("ItemTitle"),
            "Quantity": obj.get("Quantity")
        })
        return _obj


