# coding: utf-8

"""
    Open Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: openorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.openorders.models.open_order_item import OpenOrderItem
from typing import Optional, Set
from typing_extensions import Self

class OpenOrderLowFidelity(BaseModel):
    """
    OpenOrderLowFidelity
    """ # noqa: E501
    items: Optional[List[OpenOrderItem]] = Field(default=None, alias="Items")
    order_id: Optional[StrictInt] = Field(default=None, alias="OrderId")
    pk_order_id: Optional[StrictStr] = Field(default=None, alias="pkOrderID")
    status: Optional[StrictInt] = Field(default=None, alias="Status")
    reference_num: Optional[StrictStr] = Field(default=None, alias="ReferenceNum")
    external_reference: Optional[StrictStr] = Field(default=None, alias="ExternalReference")
    postal_tracking_number: Optional[StrictStr] = Field(default=None, alias="PostalTrackingNumber")
    order_date: Optional[datetime] = Field(default=None, alias="OrderDate")
    dispatch_by: Optional[datetime] = Field(default=None, alias="DispatchBy")
    __properties: ClassVar[List[str]] = ["Items", "OrderId", "pkOrderID", "Status", "ReferenceNum", "ExternalReference", "PostalTrackingNumber", "OrderDate", "DispatchBy"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OpenOrderLowFidelity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['Items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OpenOrderLowFidelity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Items": [OpenOrderItem.from_dict(_item) for _item in obj["Items"]] if obj.get("Items") is not None else None,
            "OrderId": obj.get("OrderId"),
            "pkOrderID": obj.get("pkOrderID"),
            "Status": obj.get("Status"),
            "ReferenceNum": obj.get("ReferenceNum"),
            "ExternalReference": obj.get("ExternalReference"),
            "PostalTrackingNumber": obj.get("PostalTrackingNumber"),
            "OrderDate": obj.get("OrderDate"),
            "DispatchBy": obj.get("DispatchBy")
        })
        return _obj


