# coding: utf-8

"""
    Open Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: openorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.openorders.models.view_group import ViewGroup
from linnworks_api.generated.openorders.models.view_user import ViewUser
from typing import Optional, Set
from typing_extensions import Self

class ViewUserManagement(BaseModel):
    """
    ViewUserManagement
    """ # noqa: E501
    view_id: Optional[StrictInt] = Field(default=None, alias="ViewId")
    view_users: Optional[List[ViewUser]] = Field(default=None, alias="ViewUsers")
    view_groups: Optional[List[ViewGroup]] = Field(default=None, alias="ViewGroups")
    __properties: ClassVar[List[str]] = ["ViewId", "ViewUsers", "ViewGroups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ViewUserManagement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "view_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in view_users (list)
        _items = []
        if self.view_users:
            for _item_view_users in self.view_users:
                if _item_view_users:
                    _items.append(_item_view_users.to_dict())
            _dict['ViewUsers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in view_groups (list)
        _items = []
        if self.view_groups:
            for _item_view_groups in self.view_groups:
                if _item_view_groups:
                    _items.append(_item_view_groups.to_dict())
            _dict['ViewGroups'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ViewUserManagement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ViewId": obj.get("ViewId"),
            "ViewUsers": [ViewUser.from_dict(_item) for _item in obj["ViewUsers"]] if obj.get("ViewUsers") is not None else None,
            "ViewGroups": [ViewGroup.from_dict(_item) for _item in obj["ViewGroups"]] if obj.get("ViewGroups") is not None else None
        })
        return _obj


