# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.orders.models.calc_bin_item import CalcBinItem
from typing import Optional, Set
from typing_extensions import Self

class CalcBin(BaseModel):
    """
    CalcBin
    """ # noqa: E501
    pk_bin_id: Optional[StrictStr] = Field(default=None, alias="pkBinId")
    tracking_number: Optional[StrictStr] = Field(default=None, alias="TrackingNumber")
    label_id: Optional[StrictStr] = Field(default=None, alias="LabelId")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Weight")
    print_date: Optional[datetime] = Field(default=None, alias="PrintDate")
    cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Cost")
    fk_packaging_type_id: Optional[StrictStr] = Field(default=None, alias="fkPackagingTypeId")
    width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Width")
    height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Height")
    depth: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Depth")
    packaging_weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PackagingWeight")
    item_weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ItemWeight")
    manual_adjust: Optional[StrictBool] = Field(default=None, alias="ManualAdjust")
    items: Optional[List[CalcBinItem]] = Field(default=None, alias="Items")
    __properties: ClassVar[List[str]] = ["pkBinId", "TrackingNumber", "LabelId", "Weight", "PrintDate", "Cost", "fkPackagingTypeId", "Width", "Height", "Depth", "PackagingWeight", "ItemWeight", "ManualAdjust", "Items"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CalcBin from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['Items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CalcBin from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkBinId": obj.get("pkBinId"),
            "TrackingNumber": obj.get("TrackingNumber"),
            "LabelId": obj.get("LabelId"),
            "Weight": obj.get("Weight"),
            "PrintDate": obj.get("PrintDate"),
            "Cost": obj.get("Cost"),
            "fkPackagingTypeId": obj.get("fkPackagingTypeId"),
            "Width": obj.get("Width"),
            "Height": obj.get("Height"),
            "Depth": obj.get("Depth"),
            "PackagingWeight": obj.get("PackagingWeight"),
            "ItemWeight": obj.get("ItemWeight"),
            "ManualAdjust": obj.get("ManualAdjust"),
            "Items": [CalcBinItem.from_dict(_item) for _item in obj["Items"]] if obj.get("Items") is not None else None
        })
        return _obj


