# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.orders.models.channel_address import ChannelAddress
from linnworks_api.generated.orders.models.channel_order_extended_property import ChannelOrderExtendedProperty
from linnworks_api.generated.orders.models.channel_order_item import ChannelOrderItem
from linnworks_api.generated.orders.models.channel_order_location import ChannelOrderLocation
from linnworks_api.generated.orders.models.channel_order_note import ChannelOrderNote
from typing import Optional, Set
from typing_extensions import Self

class ChannelOrder(BaseModel):
    """
    ChannelOrder
    """ # noqa: E501
    use_channel_tax: Optional[StrictBool] = Field(default=None, alias="UseChannelTax")
    pk_order_id: Optional[StrictStr] = Field(default=None, alias="pkOrderId")
    automatically_link_by_sku: Optional[StrictBool] = Field(default=None, alias="AutomaticallyLinkBySKU")
    automatically_link_by_barcode: Optional[StrictBool] = Field(default=None, alias="AutomaticallyLinkByBarcode")
    automatically_link_by_asin: Optional[StrictBool] = Field(default=None, alias="AutomaticallyLinkByASIN")
    site: Optional[StrictStr] = Field(default=None, alias="Site")
    match_postal_service_tag: Optional[StrictStr] = Field(default=None, alias="MatchPostalServiceTag")
    postal_service_name: Optional[StrictStr] = Field(default=None, alias="PostalServiceName")
    save_postal_service_if_not_exist: Optional[StrictBool] = Field(default=None, alias="SavePostalServiceIfNotExist")
    match_payment_method_tag: Optional[StrictStr] = Field(default=None, alias="MatchPaymentMethodTag")
    payment_method_name: Optional[StrictStr] = Field(default=None, alias="PaymentMethodName")
    save_payment_method_if_not_exist: Optional[StrictBool] = Field(default=None, alias="SavePaymentMethodIfNotExist")
    mapping_source: Optional[StrictStr] = Field(default=None, alias="MappingSource")
    order_state: Optional[StrictStr] = Field(default=None, alias="OrderState")
    order_fulfilment_type: Optional[StrictStr] = Field(default=None, alias="OrderFulfilmentType")
    order_status_type: Optional[StrictStr] = Field(default=None, alias="OrderStatusType")
    order_status: Optional[StrictStr] = Field(default=None, alias="OrderStatus")
    payment_status: Optional[StrictStr] = Field(default=None, alias="PaymentStatus")
    order_items: Optional[List[ChannelOrderItem]] = Field(default=None, alias="OrderItems")
    locations: Optional[List[ChannelOrderLocation]] = Field(default=None, alias="Locations")
    extended_properties: Optional[List[ChannelOrderExtendedProperty]] = Field(default=None, alias="ExtendedProperties")
    notes: Optional[List[ChannelOrderNote]] = Field(default=None, alias="Notes")
    source: Optional[StrictStr] = Field(default=None, alias="Source")
    sub_source: Optional[StrictStr] = Field(default=None, alias="SubSource")
    channel_buyer_name: Optional[StrictStr] = Field(default=None, alias="ChannelBuyerName")
    reference_number: Optional[StrictStr] = Field(default=None, alias="ReferenceNumber")
    external_reference: Optional[StrictStr] = Field(default=None, alias="ExternalReference")
    secondary_reference_number: Optional[StrictStr] = Field(default=None, alias="SecondaryReferenceNumber")
    currency: Optional[StrictStr] = Field(default=None, alias="Currency")
    conversion_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ConversionRate")
    received_date: Optional[datetime] = Field(default=None, alias="ReceivedDate")
    updated_date: Optional[datetime] = Field(default=None, alias="UpdatedDate")
    dispatch_by: Optional[datetime] = Field(default=None, alias="DispatchBy")
    paid_on: Optional[datetime] = Field(default=None, alias="PaidOn")
    postal_service_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PostalServiceCost")
    postal_service_tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PostalServiceTaxRate")
    postal_service_discount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PostalServiceDiscount")
    discount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Discount")
    items_refund: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ItemsRefund")
    shipping_refund: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ShippingRefund")
    total_refund: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TotalRefund")
    line_refund_allocation: Optional[StrictStr] = Field(default=None, alias="LineRefundAllocation")
    shipping_refund_allocation: Optional[StrictStr] = Field(default=None, alias="ShippingRefundAllocation")
    buyer_tax_number: Optional[StrictStr] = Field(default=None, alias="BuyerTaxNumber")
    discount_type: Optional[StrictStr] = Field(default=None, alias="DiscountType")
    discount_tax_type: Optional[StrictStr] = Field(default=None, alias="DiscountTaxType")
    billing_address: Optional[ChannelAddress] = Field(default=None, alias="BillingAddress")
    delivery_address: Optional[ChannelAddress] = Field(default=None, alias="DeliveryAddress")
    delivery_start_date: Optional[datetime] = Field(default=None, alias="DeliveryStartDate")
    delivery_end_date: Optional[datetime] = Field(default=None, alias="DeliveryEndDate")
    order_identifier_tags: Optional[List[StrictStr]] = Field(default=None, alias="OrderIdentifierTags")
    force_re_save_fulfilled_order: Optional[StrictBool] = Field(default=None, alias="ForceReSaveFulfilledOrder")
    __properties: ClassVar[List[str]] = ["UseChannelTax", "pkOrderId", "AutomaticallyLinkBySKU", "AutomaticallyLinkByBarcode", "AutomaticallyLinkByASIN", "Site", "MatchPostalServiceTag", "PostalServiceName", "SavePostalServiceIfNotExist", "MatchPaymentMethodTag", "PaymentMethodName", "SavePaymentMethodIfNotExist", "MappingSource", "OrderState", "OrderFulfilmentType", "OrderStatusType", "OrderStatus", "PaymentStatus", "OrderItems", "Locations", "ExtendedProperties", "Notes", "Source", "SubSource", "ChannelBuyerName", "ReferenceNumber", "ExternalReference", "SecondaryReferenceNumber", "Currency", "ConversionRate", "ReceivedDate", "UpdatedDate", "DispatchBy", "PaidOn", "PostalServiceCost", "PostalServiceTaxRate", "PostalServiceDiscount", "Discount", "ItemsRefund", "ShippingRefund", "TotalRefund", "LineRefundAllocation", "ShippingRefundAllocation", "BuyerTaxNumber", "DiscountType", "DiscountTaxType", "BillingAddress", "DeliveryAddress", "DeliveryStartDate", "DeliveryEndDate", "OrderIdentifierTags", "ForceReSaveFulfilledOrder"]

    @field_validator('order_state')
    def order_state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['None', 'Hold', 'Park']):
            raise ValueError("must be one of enum values ('None', 'Hold', 'Park')")
        return value

    @field_validator('order_fulfilment_type')
    def order_fulfilment_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Manual', 'POS', 'DigitalOnly', 'FulfilmentByChannel']):
            raise ValueError("must be one of enum values ('Manual', 'POS', 'DigitalOnly', 'FulfilmentByChannel')")
        return value

    @field_validator('order_status_type')
    def order_status_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Unknown', 'Pending', 'Unshipped', 'PartiallyShipped', 'Shipped', 'PartiallyCancelled', 'Cancelled', 'PartiallyRefunded', 'Refunded']):
            raise ValueError("must be one of enum values ('Unknown', 'Pending', 'Unshipped', 'PartiallyShipped', 'Shipped', 'PartiallyCancelled', 'Cancelled', 'PartiallyRefunded', 'Refunded')")
        return value

    @field_validator('payment_status')
    def payment_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Unpaid', 'Paid', 'Cancelled']):
            raise ValueError("must be one of enum values ('Unpaid', 'Paid', 'Cancelled')")
        return value

    @field_validator('line_refund_allocation')
    def line_refund_allocation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Unknown', 'OrderLevel', 'LineLevel', 'Both']):
            raise ValueError("must be one of enum values ('Unknown', 'OrderLevel', 'LineLevel', 'Both')")
        return value

    @field_validator('shipping_refund_allocation')
    def shipping_refund_allocation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Unknown', 'OrderLevel', 'LineLevel', 'Both']):
            raise ValueError("must be one of enum values ('Unknown', 'OrderLevel', 'LineLevel', 'Both')")
        return value

    @field_validator('discount_type')
    def discount_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['AllEvenly', 'ItemsThenPostage', 'PostageThenItems']):
            raise ValueError("must be one of enum values ('AllEvenly', 'ItemsThenPostage', 'PostageThenItems')")
        return value

    @field_validator('discount_tax_type')
    def discount_tax_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DeductAfterTax', 'DeductBeforeTax']):
            raise ValueError("must be one of enum values ('DeductAfterTax', 'DeductBeforeTax')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChannelOrder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pk_order_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in order_items (list)
        _items = []
        if self.order_items:
            for _item_order_items in self.order_items:
                if _item_order_items:
                    _items.append(_item_order_items.to_dict())
            _dict['OrderItems'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in locations (list)
        _items = []
        if self.locations:
            for _item_locations in self.locations:
                if _item_locations:
                    _items.append(_item_locations.to_dict())
            _dict['Locations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in extended_properties (list)
        _items = []
        if self.extended_properties:
            for _item_extended_properties in self.extended_properties:
                if _item_extended_properties:
                    _items.append(_item_extended_properties.to_dict())
            _dict['ExtendedProperties'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in notes (list)
        _items = []
        if self.notes:
            for _item_notes in self.notes:
                if _item_notes:
                    _items.append(_item_notes.to_dict())
            _dict['Notes'] = _items
        # override the default output from pydantic by calling `to_dict()` of billing_address
        if self.billing_address:
            _dict['BillingAddress'] = self.billing_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of delivery_address
        if self.delivery_address:
            _dict['DeliveryAddress'] = self.delivery_address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChannelOrder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "UseChannelTax": obj.get("UseChannelTax"),
            "pkOrderId": obj.get("pkOrderId"),
            "AutomaticallyLinkBySKU": obj.get("AutomaticallyLinkBySKU"),
            "AutomaticallyLinkByBarcode": obj.get("AutomaticallyLinkByBarcode"),
            "AutomaticallyLinkByASIN": obj.get("AutomaticallyLinkByASIN"),
            "Site": obj.get("Site"),
            "MatchPostalServiceTag": obj.get("MatchPostalServiceTag"),
            "PostalServiceName": obj.get("PostalServiceName"),
            "SavePostalServiceIfNotExist": obj.get("SavePostalServiceIfNotExist"),
            "MatchPaymentMethodTag": obj.get("MatchPaymentMethodTag"),
            "PaymentMethodName": obj.get("PaymentMethodName"),
            "SavePaymentMethodIfNotExist": obj.get("SavePaymentMethodIfNotExist"),
            "MappingSource": obj.get("MappingSource"),
            "OrderState": obj.get("OrderState"),
            "OrderFulfilmentType": obj.get("OrderFulfilmentType"),
            "OrderStatusType": obj.get("OrderStatusType"),
            "OrderStatus": obj.get("OrderStatus"),
            "PaymentStatus": obj.get("PaymentStatus"),
            "OrderItems": [ChannelOrderItem.from_dict(_item) for _item in obj["OrderItems"]] if obj.get("OrderItems") is not None else None,
            "Locations": [ChannelOrderLocation.from_dict(_item) for _item in obj["Locations"]] if obj.get("Locations") is not None else None,
            "ExtendedProperties": [ChannelOrderExtendedProperty.from_dict(_item) for _item in obj["ExtendedProperties"]] if obj.get("ExtendedProperties") is not None else None,
            "Notes": [ChannelOrderNote.from_dict(_item) for _item in obj["Notes"]] if obj.get("Notes") is not None else None,
            "Source": obj.get("Source"),
            "SubSource": obj.get("SubSource"),
            "ChannelBuyerName": obj.get("ChannelBuyerName"),
            "ReferenceNumber": obj.get("ReferenceNumber"),
            "ExternalReference": obj.get("ExternalReference"),
            "SecondaryReferenceNumber": obj.get("SecondaryReferenceNumber"),
            "Currency": obj.get("Currency"),
            "ConversionRate": obj.get("ConversionRate"),
            "ReceivedDate": obj.get("ReceivedDate"),
            "UpdatedDate": obj.get("UpdatedDate"),
            "DispatchBy": obj.get("DispatchBy"),
            "PaidOn": obj.get("PaidOn"),
            "PostalServiceCost": obj.get("PostalServiceCost"),
            "PostalServiceTaxRate": obj.get("PostalServiceTaxRate"),
            "PostalServiceDiscount": obj.get("PostalServiceDiscount"),
            "Discount": obj.get("Discount"),
            "ItemsRefund": obj.get("ItemsRefund"),
            "ShippingRefund": obj.get("ShippingRefund"),
            "TotalRefund": obj.get("TotalRefund"),
            "LineRefundAllocation": obj.get("LineRefundAllocation"),
            "ShippingRefundAllocation": obj.get("ShippingRefundAllocation"),
            "BuyerTaxNumber": obj.get("BuyerTaxNumber"),
            "DiscountType": obj.get("DiscountType"),
            "DiscountTaxType": obj.get("DiscountTaxType"),
            "BillingAddress": ChannelAddress.from_dict(obj["BillingAddress"]) if obj.get("BillingAddress") is not None else None,
            "DeliveryAddress": ChannelAddress.from_dict(obj["DeliveryAddress"]) if obj.get("DeliveryAddress") is not None else None,
            "DeliveryStartDate": obj.get("DeliveryStartDate"),
            "DeliveryEndDate": obj.get("DeliveryEndDate"),
            "OrderIdentifierTags": obj.get("OrderIdentifierTags"),
            "ForceReSaveFulfilledOrder": obj.get("ForceReSaveFulfilledOrder")
        })
        return _obj


