# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.orders.models.order_item_batch import OrderItemBatch
from typing import Optional, Set
from typing_extensions import Self

class OrderItemBatchExtended(BaseModel):
    """
    OrderItemBatchExtended
    """ # noqa: E501
    pk_order_id: Optional[StrictStr] = Field(default=None, alias="pkOrderId")
    order_id: Optional[StrictStr] = Field(default=None, alias="OrderId")
    batches: Optional[List[OrderItemBatch]] = Field(default=None, alias="Batches")
    __properties: ClassVar[List[str]] = ["pkOrderId", "OrderId", "Batches"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderItemBatchExtended from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "order_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in batches (list)
        _items = []
        if self.batches:
            for _item_batches in self.batches:
                if _item_batches:
                    _items.append(_item_batches.to_dict())
            _dict['Batches'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderItemBatchExtended from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkOrderId": obj.get("pkOrderId"),
            "OrderId": obj.get("OrderId"),
            "Batches": [OrderItemBatch.from_dict(_item) for _item in obj["Batches"]] if obj.get("Batches") is not None else None
        })
        return _obj


