# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.orders.models.line_pricing_request import LinePricingRequest
from typing import Optional, Set
from typing_extensions import Self

class OrdersAddOrderItemRequest(BaseModel):
    """
    OrdersAddOrderItemRequest
    """ # noqa: E501
    order_id: Optional[StrictStr] = Field(default=None, description="Order id", alias="orderId")
    item_id: Optional[StrictStr] = Field(default=None, description="Item id to be added", alias="itemId")
    channel_sku: Optional[StrictStr] = Field(default=None, description="Channel SKU of the item", alias="channelSKU")
    fulfilment_center: Optional[StrictStr] = Field(default=None, description="Current fulfilment center", alias="fulfilmentCenter")
    quantity: Optional[StrictInt] = Field(default=None, description="Item quantity")
    line_pricing: Optional[LinePricingRequest] = Field(default=None, alias="linePricing")
    created_date: Optional[datetime] = Field(default=None, description="The datetime that the item was added to the order", alias="createdDate")
    __properties: ClassVar[List[str]] = ["orderId", "itemId", "channelSKU", "fulfilmentCenter", "quantity", "linePricing", "createdDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrdersAddOrderItemRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of line_pricing
        if self.line_pricing:
            _dict['linePricing'] = self.line_pricing.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrdersAddOrderItemRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderId": obj.get("orderId"),
            "itemId": obj.get("itemId"),
            "channelSKU": obj.get("channelSKU"),
            "fulfilmentCenter": obj.get("fulfilmentCenter"),
            "quantity": obj.get("quantity"),
            "linePricing": LinePricingRequest.from_dict(obj["linePricing"]) if obj.get("linePricing") is not None else None,
            "createdDate": obj.get("createdDate")
        })
        return _obj


