# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class OrdersAddOrderServiceRequest(BaseModel):
    """
    OrdersAddOrderServiceRequest
    """ # noqa: E501
    order_id: Optional[StrictStr] = Field(default=None, description="Order id", alias="OrderId")
    service: Optional[StrictStr] = Field(default=None, description="Service", alias="Service")
    cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Price Per Unit of each service item", alias="Cost")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Tax rate. Optional, defaults to 0.", alias="TaxRate")
    fulfilment_center: Optional[StrictStr] = Field(default=None, description="Current fulfilment center", alias="FulfilmentCenter")
    quantity: Optional[StrictInt] = Field(default=None, description="Quantity of the service item. Optional, defaults to 1.", alias="Quantity")
    discount_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Discount percentage applied to the service item. Optional, defaults to 0.", alias="DiscountPercentage")
    added_date: Optional[datetime] = Field(default=None, description="Holds the datetime that the service was added to the order", alias="AddedDate")
    __properties: ClassVar[List[str]] = ["OrderId", "Service", "Cost", "TaxRate", "FulfilmentCenter", "Quantity", "DiscountPercentage", "AddedDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrdersAddOrderServiceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrdersAddOrderServiceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "OrderId": obj.get("OrderId"),
            "Service": obj.get("Service"),
            "Cost": obj.get("Cost"),
            "TaxRate": obj.get("TaxRate"),
            "FulfilmentCenter": obj.get("FulfilmentCenter"),
            "Quantity": obj.get("Quantity"),
            "DiscountPercentage": obj.get("DiscountPercentage"),
            "AddedDate": obj.get("AddedDate")
        })
        return _obj


