# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.orders.models.face import Face
from linnworks_api.generated.orders.models.packed_item import PackedItem
from typing import Optional, Set
from typing_extensions import Self

class PackageResult(BaseModel):
    """
    PackageResult
    """ # noqa: E501
    packaging_id: Optional[StrictStr] = Field(default=None, alias="PackagingId")
    width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Width")
    height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Height")
    depth: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Depth")
    item_weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ItemWeight")
    packaging_weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PackagingWeight")
    faces: Optional[List[Face]] = Field(default=None, alias="Faces")
    items: Optional[List[PackedItem]] = Field(default=None, alias="Items")
    layer_count: Optional[StrictInt] = Field(default=None, alias="LayerCount")
    layer_face: Optional[Dict[str, Face]] = Field(default=None, alias="LayerFace")
    is_manual_package: Optional[StrictBool] = Field(default=None, alias="IsManualPackage")
    __properties: ClassVar[List[str]] = ["PackagingId", "Width", "Height", "Depth", "ItemWeight", "PackagingWeight", "Faces", "Items", "LayerCount", "LayerFace", "IsManualPackage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PackageResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in faces (list)
        _items = []
        if self.faces:
            for _item_faces in self.faces:
                if _item_faces:
                    _items.append(_item_faces.to_dict())
            _dict['Faces'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['Items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in layer_face (dict)
        _field_dict = {}
        if self.layer_face:
            for _key_layer_face in self.layer_face:
                if self.layer_face[_key_layer_face]:
                    _field_dict[_key_layer_face] = self.layer_face[_key_layer_face].to_dict()
            _dict['LayerFace'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PackageResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PackagingId": obj.get("PackagingId"),
            "Width": obj.get("Width"),
            "Height": obj.get("Height"),
            "Depth": obj.get("Depth"),
            "ItemWeight": obj.get("ItemWeight"),
            "PackagingWeight": obj.get("PackagingWeight"),
            "Faces": [Face.from_dict(_item) for _item in obj["Faces"]] if obj.get("Faces") is not None else None,
            "Items": [PackedItem.from_dict(_item) for _item in obj["Items"]] if obj.get("Items") is not None else None,
            "LayerCount": obj.get("LayerCount"),
            "LayerFace": dict(
                (_k, Face.from_dict(_v))
                for _k, _v in obj["LayerFace"].items()
            )
            if obj.get("LayerFace") is not None
            else None,
            "IsManualPackage": obj.get("IsManualPackage")
        })
        return _obj


