# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.orders.models.order_item_option_update import OrderItemOptionUpdate
from typing import Optional, Set
from typing_extensions import Self

class UpdateAdditionalInfoRequest(BaseModel):
    """
    UpdateAdditionalInfoRequest
    """ # noqa: E501
    order_id: Optional[StrictStr] = Field(default=None, description="Linnworks Order Id", alias="OrderId")
    order_item_row_id: Optional[StrictStr] = Field(default=None, description="The Row Id for the order item", alias="OrderItemRowId")
    additional_info: Optional[List[OrderItemOptionUpdate]] = Field(default=None, description="A list of additional information to update or delete from the order item", alias="AdditionalInfo")
    __properties: ClassVar[List[str]] = ["OrderId", "OrderItemRowId", "AdditionalInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateAdditionalInfoRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in additional_info (list)
        _items = []
        if self.additional_info:
            for _item_additional_info in self.additional_info:
                if _item_additional_info:
                    _items.append(_item_additional_info.to_dict())
            _dict['AdditionalInfo'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateAdditionalInfoRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "OrderId": obj.get("OrderId"),
            "OrderItemRowId": obj.get("OrderItemRowId"),
            "AdditionalInfo": [OrderItemOptionUpdate.from_dict(_item) for _item in obj["AdditionalInfo"]] if obj.get("AdditionalInfo") is not None else None
        })
        return _obj


