# coding: utf-8

"""
    Picking API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: picking
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class BinRackStockItem(BaseModel):
    """
    Bin Rack
    """ # noqa: E501
    bin_rack_id: Optional[StrictInt] = Field(default=None, description="Unique id for the binrack", alias="BinRackId")
    standard_type: Optional[StrictInt] = Field(default=None, description="Bin Rack type name", alias="StandardType")
    batch_id: Optional[StrictInt] = Field(default=None, description="Batch id", alias="BatchId")
    batch_inventory_id: Optional[StrictInt] = Field(default=None, description="Batch inventory id", alias="BatchInventoryId")
    priority_sequence: Optional[StrictInt] = Field(default=None, description="Consume priority sequence", alias="PrioritySequence")
    batch_status: Optional[StrictStr] = Field(default=None, description="Batch status, \"Available\", \"Restricted\", \"Damaged\", \"Expired\"", alias="BatchStatus")
    bin_rack: Optional[StrictStr] = Field(default=None, description="BinRack name", alias="BinRack")
    current_full_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Maximum volumetric capacity of the location WxDxH = volumetric", alias="CurrentFullPercentage")
    quantity: Optional[StrictInt] = Field(default=None, description="Quantity available in the location", alias="Quantity")
    in_transit: Optional[StrictInt] = Field(default=None, description="Quantity of items currently in transit", alias="InTransit")
    picked_quantity: Optional[StrictInt] = Field(default=None, description="Indicate how many units are now allocated in open orders", alias="PickedQuantity")
    inventory_tracking_type: Optional[StrictInt] = Field(default=None, description="0 - None, 1 - Order by sell by date, 2 - Ordered by priority sequence", alias="InventoryTrackingType")
    stock_item_id: Optional[StrictStr] = Field(default=None, description="Product ID", alias="StockItemId")
    batch_number: Optional[StrictStr] = Field(default=None, description="Batch number", alias="BatchNumber")
    expires_on: Optional[datetime] = Field(default=None, description="Batch expiry date", alias="ExpiresOn")
    sell_by: Optional[datetime] = Field(default=None, description="Batch sell by date", alias="SellBy")
    binrack_type_name: Optional[StrictStr] = Field(default=None, alias="BinrackTypeName")
    location_id: Optional[StrictStr] = Field(default=None, alias="LocationId")
    __properties: ClassVar[List[str]] = ["BinRackId", "StandardType", "BatchId", "BatchInventoryId", "PrioritySequence", "BatchStatus", "BinRack", "CurrentFullPercentage", "Quantity", "InTransit", "PickedQuantity", "InventoryTrackingType", "StockItemId", "BatchNumber", "ExpiresOn", "SellBy", "BinrackTypeName", "LocationId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BinRackStockItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BinRackStockItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "BinRackId": obj.get("BinRackId"),
            "StandardType": obj.get("StandardType"),
            "BatchId": obj.get("BatchId"),
            "BatchInventoryId": obj.get("BatchInventoryId"),
            "PrioritySequence": obj.get("PrioritySequence"),
            "BatchStatus": obj.get("BatchStatus"),
            "BinRack": obj.get("BinRack"),
            "CurrentFullPercentage": obj.get("CurrentFullPercentage"),
            "Quantity": obj.get("Quantity"),
            "InTransit": obj.get("InTransit"),
            "PickedQuantity": obj.get("PickedQuantity"),
            "InventoryTrackingType": obj.get("InventoryTrackingType"),
            "StockItemId": obj.get("StockItemId"),
            "BatchNumber": obj.get("BatchNumber"),
            "ExpiresOn": obj.get("ExpiresOn"),
            "SellBy": obj.get("SellBy"),
            "BinrackTypeName": obj.get("BinrackTypeName"),
            "LocationId": obj.get("LocationId")
        })
        return _obj


