# coding: utf-8

"""
    Picking API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: picking
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.picking.models.bin_rack_stock_item import BinRackStockItem
from linnworks_api.generated.picking.models.stock_item_batch import StockItemBatch
from typing import Optional, Set
from typing_extensions import Self

class GetItemBinracksResponse(BaseModel):
    """
    GetItemBinracksResponse
    """ # noqa: E501
    alternate_locations: Optional[List[StockItemBatch]] = Field(default=None, description="A list of other batches that are available in the given linnworks stock location", alias="AlternateLocations")
    pickable_bins: Optional[List[BinRackStockItem]] = Field(default=None, description="A list of stock that is available to pick from", alias="PickableBins")
    non_pickable_bins: Optional[List[BinRackStockItem]] = Field(default=None, description="A list of stock that cannot directly be picked from", alias="NonPickableBins")
    __properties: ClassVar[List[str]] = ["AlternateLocations", "PickableBins", "NonPickableBins"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetItemBinracksResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in alternate_locations (list)
        _items = []
        if self.alternate_locations:
            for _item_alternate_locations in self.alternate_locations:
                if _item_alternate_locations:
                    _items.append(_item_alternate_locations.to_dict())
            _dict['AlternateLocations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pickable_bins (list)
        _items = []
        if self.pickable_bins:
            for _item_pickable_bins in self.pickable_bins:
                if _item_pickable_bins:
                    _items.append(_item_pickable_bins.to_dict())
            _dict['PickableBins'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in non_pickable_bins (list)
        _items = []
        if self.non_pickable_bins:
            for _item_non_pickable_bins in self.non_pickable_bins:
                if _item_non_pickable_bins:
                    _items.append(_item_non_pickable_bins.to_dict())
            _dict['NonPickableBins'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetItemBinracksResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AlternateLocations": [StockItemBatch.from_dict(_item) for _item in obj["AlternateLocations"]] if obj.get("AlternateLocations") is not None else None,
            "PickableBins": [BinRackStockItem.from_dict(_item) for _item in obj["PickableBins"]] if obj.get("PickableBins") is not None else None,
            "NonPickableBins": [BinRackStockItem.from_dict(_item) for _item in obj["NonPickableBins"]] if obj.get("NonPickableBins") is not None else None
        })
        return _obj


