# coding: utf-8

"""
    Picking API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: picking
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.picking.models.pick_wave_allocate_check_result_error import PickWaveAllocateCheckResultError
from linnworks_api.generated.picking.models.pick_wave_allocate_check_result_order_details import PickWaveAllocateCheckResultOrderDetails
from typing import Optional, Set
from typing_extensions import Self

class PickWaveAllocateCheckResult(BaseModel):
    """
    PickWaveAllocateCheckResult
    """ # noqa: E501
    sort_order: Optional[StrictInt] = Field(default=None, alias="SortOrder")
    order_id: Optional[StrictInt] = Field(default=None, alias="OrderId")
    order_id_guid: Optional[StrictStr] = Field(default=None, alias="OrderId_Guid")
    errors: Optional[List[PickWaveAllocateCheckResultError]] = Field(default=None, alias="Errors")
    has_errors: Optional[StrictBool] = Field(default=None, alias="HasErrors")
    order_details: Optional[List[PickWaveAllocateCheckResultOrderDetails]] = Field(default=None, alias="OrderDetails")
    __properties: ClassVar[List[str]] = ["SortOrder", "OrderId", "OrderId_Guid", "Errors", "HasErrors", "OrderDetails"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PickWaveAllocateCheckResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "has_errors",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['Errors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in order_details (list)
        _items = []
        if self.order_details:
            for _item_order_details in self.order_details:
                if _item_order_details:
                    _items.append(_item_order_details.to_dict())
            _dict['OrderDetails'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PickWaveAllocateCheckResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SortOrder": obj.get("SortOrder"),
            "OrderId": obj.get("OrderId"),
            "OrderId_Guid": obj.get("OrderId_Guid"),
            "Errors": [PickWaveAllocateCheckResultError.from_dict(_item) for _item in obj["Errors"]] if obj.get("Errors") is not None else None,
            "HasErrors": obj.get("HasErrors"),
            "OrderDetails": [PickWaveAllocateCheckResultOrderDetails.from_dict(_item) for _item in obj["OrderDetails"]] if obj.get("OrderDetails") is not None else None
        })
        return _obj


