# coding: utf-8

"""
    Picking API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: picking
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.picking.models.picking_wave_item_composition import PickingWaveItemComposition
from linnworks_api.generated.picking.models.picking_wave_item_detailed import PickingWaveItemDetailed
from typing import Optional, Set
from typing_extensions import Self

class PickingWaveOrderDetailed(BaseModel):
    """
    PickingWaveOrderDetailed
    """ # noqa: E501
    picking_wave_orders_row_id: Optional[StrictInt] = Field(default=None, description="Pickwave order id", alias="PickingWaveOrdersRowId")
    picking_wave_id: Optional[StrictInt] = Field(default=None, description="Pickwave id", alias="PickingWaveId")
    order_id: Optional[StrictInt] = Field(default=None, description="Order Id", alias="OrderId")
    pick_state: Optional[StrictStr] = Field(default=None, description="Pick state", alias="PickState")
    sort_order: Optional[StrictInt] = Field(default=None, description="Sort order", alias="SortOrder")
    item_count: Optional[StrictInt] = Field(default=None, description="Items count", alias="ItemCount")
    picked_items_count: Optional[StrictInt] = Field(default=None, description="Picked items count", alias="PickedItemsCount")
    items: Optional[List[PickingWaveItemDetailed]] = Field(default=None, description="Pickwave order items.", alias="Items")
    composition: Optional[List[PickingWaveItemComposition]] = Field(default=None, description="Relationship between pickwave items and composite parent rows.", alias="Composition")
    order_id_guid: Optional[StrictStr] = Field(default=None, description="Internal guid orderid", alias="OrderId_Guid")
    is_processed: Optional[StrictBool] = Field(default=None, description="Is order processed", alias="IsProcessed")
    is_cancelled: Optional[StrictBool] = Field(default=None, description="Is order hold or cancelled", alias="IsCancelled")
    is_on_hold: Optional[StrictBool] = Field(default=None, description="Is order on hold status", alias="IsOnHold")
    is_locked: Optional[StrictBool] = Field(default=None, description="Is order locked.", alias="IsLocked")
    is_paid: Optional[StrictBool] = Field(default=None, description="Is order paid", alias="IsPaid")
    __properties: ClassVar[List[str]] = ["PickingWaveOrdersRowId", "PickingWaveId", "OrderId", "PickState", "SortOrder", "ItemCount", "PickedItemsCount", "Items", "Composition", "OrderId_Guid", "IsProcessed", "IsCancelled", "IsOnHold", "IsLocked", "IsPaid"]

    @field_validator('pick_state')
    def pick_state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Unpicked', 'PartialPicked', 'Picked', 'Processed', 'LockedOrParked', 'Cancelled', 'Deleted']):
            raise ValueError("must be one of enum values ('Unpicked', 'PartialPicked', 'Picked', 'Processed', 'LockedOrParked', 'Cancelled', 'Deleted')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PickingWaveOrderDetailed from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['Items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in composition (list)
        _items = []
        if self.composition:
            for _item_composition in self.composition:
                if _item_composition:
                    _items.append(_item_composition.to_dict())
            _dict['Composition'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PickingWaveOrderDetailed from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PickingWaveOrdersRowId": obj.get("PickingWaveOrdersRowId"),
            "PickingWaveId": obj.get("PickingWaveId"),
            "OrderId": obj.get("OrderId"),
            "PickState": obj.get("PickState"),
            "SortOrder": obj.get("SortOrder"),
            "ItemCount": obj.get("ItemCount"),
            "PickedItemsCount": obj.get("PickedItemsCount"),
            "Items": [PickingWaveItemDetailed.from_dict(_item) for _item in obj["Items"]] if obj.get("Items") is not None else None,
            "Composition": [PickingWaveItemComposition.from_dict(_item) for _item in obj["Composition"]] if obj.get("Composition") is not None else None,
            "OrderId_Guid": obj.get("OrderId_Guid"),
            "IsProcessed": obj.get("IsProcessed"),
            "IsCancelled": obj.get("IsCancelled"),
            "IsOnHold": obj.get("IsOnHold"),
            "IsLocked": obj.get("IsLocked"),
            "IsPaid": obj.get("IsPaid")
        })
        return _obj


