# coding: utf-8

"""
    Postal Services API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: postalservices
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.postalservices.models.channel import Channel
from linnworks_api.generated.postalservices.models.shipping_service import ShippingService
from typing import Optional, Set
from typing_extensions import Self

class PostalServiceWithChannelAndShippingLinks(BaseModel):
    """
    Class which exposes only those elements required by linnworks.net front end
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Postal service ID")
    has_mapped_shipping_service: Optional[StrictBool] = Field(default=None, description="If there is channel linking with shipping service", alias="hasMappedShippingService")
    channels: Optional[List[Channel]] = Field(default=None, description="Channel information", alias="Channels")
    shipping_services: Optional[List[ShippingService]] = Field(default=None, description="Shipping service information", alias="ShippingServices")
    postal_service_name: Optional[StrictStr] = Field(default=None, alias="PostalServiceName")
    postal_service_tag: Optional[StrictStr] = Field(default=None, alias="PostalServiceTag")
    service_country: Optional[StrictStr] = Field(default=None, alias="ServiceCountry")
    postal_service_code: Optional[StrictStr] = Field(default=None, alias="PostalServiceCode")
    vendor: Optional[StrictStr] = Field(default=None, alias="Vendor")
    print_module: Optional[StrictStr] = Field(default=None, alias="PrintModule")
    print_module_title: Optional[StrictStr] = Field(default=None, alias="PrintModuleTitle")
    pk_postal_service_id: Optional[StrictStr] = Field(default=None, alias="pkPostalServiceId")
    tracking_number_required: Optional[StrictBool] = Field(default=None, alias="TrackingNumberRequired")
    weight_required: Optional[StrictBool] = Field(default=None, alias="WeightRequired")
    ignore_packaging_group: Optional[StrictBool] = Field(default=None, alias="IgnorePackagingGroup")
    fk_shipping_api_config_id: Optional[StrictInt] = Field(default=None, alias="fkShippingAPIConfigId")
    integrated_service_id: Optional[StrictStr] = Field(default=None, alias="IntegratedServiceId")
    __properties: ClassVar[List[str]] = ["id", "hasMappedShippingService", "Channels", "ShippingServices", "PostalServiceName", "PostalServiceTag", "ServiceCountry", "PostalServiceCode", "Vendor", "PrintModule", "PrintModuleTitle", "pkPostalServiceId", "TrackingNumberRequired", "WeightRequired", "IgnorePackagingGroup", "fkShippingAPIConfigId", "IntegratedServiceId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostalServiceWithChannelAndShippingLinks from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in channels (list)
        _items = []
        if self.channels:
            for _item_channels in self.channels:
                if _item_channels:
                    _items.append(_item_channels.to_dict())
            _dict['Channels'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shipping_services (list)
        _items = []
        if self.shipping_services:
            for _item_shipping_services in self.shipping_services:
                if _item_shipping_services:
                    _items.append(_item_shipping_services.to_dict())
            _dict['ShippingServices'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostalServiceWithChannelAndShippingLinks from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "hasMappedShippingService": obj.get("hasMappedShippingService"),
            "Channels": [Channel.from_dict(_item) for _item in obj["Channels"]] if obj.get("Channels") is not None else None,
            "ShippingServices": [ShippingService.from_dict(_item) for _item in obj["ShippingServices"]] if obj.get("ShippingServices") is not None else None,
            "PostalServiceName": obj.get("PostalServiceName"),
            "PostalServiceTag": obj.get("PostalServiceTag"),
            "ServiceCountry": obj.get("ServiceCountry"),
            "PostalServiceCode": obj.get("PostalServiceCode"),
            "Vendor": obj.get("Vendor"),
            "PrintModule": obj.get("PrintModule"),
            "PrintModuleTitle": obj.get("PrintModuleTitle"),
            "pkPostalServiceId": obj.get("pkPostalServiceId"),
            "TrackingNumberRequired": obj.get("TrackingNumberRequired"),
            "WeightRequired": obj.get("WeightRequired"),
            "IgnorePackagingGroup": obj.get("IgnorePackagingGroup"),
            "fkShippingAPIConfigId": obj.get("fkShippingAPIConfigId"),
            "IntegratedServiceId": obj.get("IntegratedServiceId")
        })
        return _obj


