# coding: utf-8

"""
    Post Sale (Cancellations) API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: postsale
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.postsale.models.channel_reason import ChannelReason
from linnworks_api.generated.postsale.models.order_details import OrderDetails
from linnworks_api.generated.postsale.models.order_refund_header import OrderRefundHeader
from typing import Optional, Set
from typing_extensions import Self

class CancellationOptions(BaseModel):
    """
    CancellationOptions
    """ # noqa: E501
    can_cancel_internally: Optional[StrictBool] = Field(default=None, alias="CanCancelInternally")
    automatic_refund_on_cancel: Optional[StrictBool] = Field(default=None, alias="AutomaticRefundOnCancel")
    can_cancel: Optional[StrictBool] = Field(default=None, alias="CanCancel")
    can_cancel_order_lines: Optional[StrictBool] = Field(default=None, alias="CanCancelOrderLines")
    can_cancel_partially: Optional[StrictBool] = Field(default=None, alias="CanCancelPartially")
    can_cancel_free_text: Optional[StrictBool] = Field(default=None, alias="CanCancelFreeText")
    cancel_free_text_or_note_max_length: Optional[StrictInt] = Field(default=None, alias="CancelFreeTextOrNoteMaxLength")
    cancellation_reasons: Optional[List[ChannelReason]] = Field(default=None, alias="CancellationReasons")
    order: Optional[OrderDetails] = Field(default=None, alias="Order")
    cancellation_header: Optional[OrderRefundHeader] = Field(default=None, alias="CancellationHeader")
    allow_refund_on_cancel: Optional[StrictBool] = Field(default=None, alias="AllowRefundOnCancel")
    errors: Optional[List[StrictStr]] = Field(default=None, alias="Errors")
    order_is_locked_on_unhandled_error: Optional[StrictBool] = Field(default=None, alias="OrderIsLockedOnUnhandledError")
    __properties: ClassVar[List[str]] = ["CanCancelInternally", "AutomaticRefundOnCancel", "CanCancel", "CanCancelOrderLines", "CanCancelPartially", "CanCancelFreeText", "CancelFreeTextOrNoteMaxLength", "CancellationReasons", "Order", "CancellationHeader", "AllowRefundOnCancel", "Errors", "OrderIsLockedOnUnhandledError"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CancellationOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "can_cancel_internally",
            "automatic_refund_on_cancel",
            "can_cancel",
            "can_cancel_order_lines",
            "can_cancel_partially",
            "can_cancel_free_text",
            "cancel_free_text_or_note_max_length",
            "cancellation_reasons",
            "allow_refund_on_cancel",
            "errors",
            "order_is_locked_on_unhandled_error",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cancellation_reasons (list)
        _items = []
        if self.cancellation_reasons:
            for _item_cancellation_reasons in self.cancellation_reasons:
                if _item_cancellation_reasons:
                    _items.append(_item_cancellation_reasons.to_dict())
            _dict['CancellationReasons'] = _items
        # override the default output from pydantic by calling `to_dict()` of order
        if self.order:
            _dict['Order'] = self.order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cancellation_header
        if self.cancellation_header:
            _dict['CancellationHeader'] = self.cancellation_header.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CancellationOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CanCancelInternally": obj.get("CanCancelInternally"),
            "AutomaticRefundOnCancel": obj.get("AutomaticRefundOnCancel"),
            "CanCancel": obj.get("CanCancel"),
            "CanCancelOrderLines": obj.get("CanCancelOrderLines"),
            "CanCancelPartially": obj.get("CanCancelPartially"),
            "CanCancelFreeText": obj.get("CanCancelFreeText"),
            "CancelFreeTextOrNoteMaxLength": obj.get("CancelFreeTextOrNoteMaxLength"),
            "CancellationReasons": [ChannelReason.from_dict(_item) for _item in obj["CancellationReasons"]] if obj.get("CancellationReasons") is not None else None,
            "Order": OrderDetails.from_dict(obj["Order"]) if obj.get("Order") is not None else None,
            "CancellationHeader": OrderRefundHeader.from_dict(obj["CancellationHeader"]) if obj.get("CancellationHeader") is not None else None,
            "AllowRefundOnCancel": obj.get("AllowRefundOnCancel"),
            "Errors": obj.get("Errors"),
            "OrderIsLockedOnUnhandledError": obj.get("OrderIsLockedOnUnhandledError")
        })
        return _obj


