# coding: utf-8

"""
    Post Sale (Cancellations) API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: postsale
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.postsale.models.identifier import Identifier
from linnworks_api.generated.postsale.models.scheduled_delivery import ScheduledDelivery
from typing import Optional, Set
from typing_extensions import Self

class OrderGeneralInfo(BaseModel):
    """
    OrderGeneralInfo
    """ # noqa: E501
    status: Optional[StrictInt] = Field(default=None, alias="Status")
    label_printed: Optional[StrictBool] = Field(default=None, alias="LabelPrinted")
    label_error: Optional[StrictStr] = Field(default=None, alias="LabelError")
    invoice_printed: Optional[StrictBool] = Field(default=None, alias="InvoicePrinted")
    invoice_print_error: Optional[StrictStr] = Field(default=None, alias="InvoicePrintError")
    pick_list_printed: Optional[StrictBool] = Field(default=None, alias="PickListPrinted")
    pick_list_print_error: Optional[StrictStr] = Field(default=None, alias="PickListPrintError")
    is_rule_run: Optional[StrictBool] = Field(default=None, alias="IsRuleRun")
    notes: Optional[StrictInt] = Field(default=None, alias="Notes")
    part_shipped: Optional[StrictBool] = Field(default=None, alias="PartShipped")
    marker: Optional[StrictInt] = Field(default=None, alias="Marker")
    is_parked: Optional[StrictBool] = Field(default=None, alias="IsParked")
    identifiers: Optional[List[Identifier]] = Field(default=None, alias="Identifiers")
    reference_num: Optional[StrictStr] = Field(default=None, alias="ReferenceNum")
    secondary_reference: Optional[StrictStr] = Field(default=None, alias="SecondaryReference")
    external_reference_num: Optional[StrictStr] = Field(default=None, alias="ExternalReferenceNum")
    received_date: Optional[datetime] = Field(default=None, alias="ReceivedDate")
    source: Optional[StrictStr] = Field(default=None, alias="Source")
    sub_source: Optional[StrictStr] = Field(default=None, alias="SubSource")
    site_code: Optional[StrictStr] = Field(default=None, alias="SiteCode")
    hold_or_cancel: Optional[StrictBool] = Field(default=None, alias="HoldOrCancel")
    despatch_by_date: Optional[datetime] = Field(default=None, alias="DespatchByDate")
    scheduled_delivery: Optional[ScheduledDelivery] = Field(default=None, alias="ScheduledDelivery")
    has_scheduled_delivery: Optional[StrictBool] = Field(default=None, alias="HasScheduledDelivery")
    location: Optional[StrictStr] = Field(default=None, alias="Location")
    num_items: Optional[StrictInt] = Field(default=None, alias="NumItems")
    pickwave_ids: Optional[List[StrictInt]] = Field(default=None, alias="PickwaveIds")
    stock_allocation_type: Optional[StrictStr] = Field(default=None, alias="StockAllocationType")
    __properties: ClassVar[List[str]] = ["Status", "LabelPrinted", "LabelError", "InvoicePrinted", "InvoicePrintError", "PickListPrinted", "PickListPrintError", "IsRuleRun", "Notes", "PartShipped", "Marker", "IsParked", "Identifiers", "ReferenceNum", "SecondaryReference", "ExternalReferenceNum", "ReceivedDate", "Source", "SubSource", "SiteCode", "HoldOrCancel", "DespatchByDate", "ScheduledDelivery", "HasScheduledDelivery", "Location", "NumItems", "PickwaveIds", "StockAllocationType"]

    @field_validator('stock_allocation_type')
    def stock_allocation_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NotAllocated', 'Insuffient', 'Partial', 'Full', 'OverAllocated']):
            raise ValueError("must be one of enum values ('NotAllocated', 'Insuffient', 'Partial', 'Full', 'OverAllocated')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderGeneralInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "has_scheduled_delivery",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in identifiers (list)
        _items = []
        if self.identifiers:
            for _item_identifiers in self.identifiers:
                if _item_identifiers:
                    _items.append(_item_identifiers.to_dict())
            _dict['Identifiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of scheduled_delivery
        if self.scheduled_delivery:
            _dict['ScheduledDelivery'] = self.scheduled_delivery.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderGeneralInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Status": obj.get("Status"),
            "LabelPrinted": obj.get("LabelPrinted"),
            "LabelError": obj.get("LabelError"),
            "InvoicePrinted": obj.get("InvoicePrinted"),
            "InvoicePrintError": obj.get("InvoicePrintError"),
            "PickListPrinted": obj.get("PickListPrinted"),
            "PickListPrintError": obj.get("PickListPrintError"),
            "IsRuleRun": obj.get("IsRuleRun"),
            "Notes": obj.get("Notes"),
            "PartShipped": obj.get("PartShipped"),
            "Marker": obj.get("Marker"),
            "IsParked": obj.get("IsParked"),
            "Identifiers": [Identifier.from_dict(_item) for _item in obj["Identifiers"]] if obj.get("Identifiers") is not None else None,
            "ReferenceNum": obj.get("ReferenceNum"),
            "SecondaryReference": obj.get("SecondaryReference"),
            "ExternalReferenceNum": obj.get("ExternalReferenceNum"),
            "ReceivedDate": obj.get("ReceivedDate"),
            "Source": obj.get("Source"),
            "SubSource": obj.get("SubSource"),
            "SiteCode": obj.get("SiteCode"),
            "HoldOrCancel": obj.get("HoldOrCancel"),
            "DespatchByDate": obj.get("DespatchByDate"),
            "ScheduledDelivery": ScheduledDelivery.from_dict(obj["ScheduledDelivery"]) if obj.get("ScheduledDelivery") is not None else None,
            "HasScheduledDelivery": obj.get("HasScheduledDelivery"),
            "Location": obj.get("Location"),
            "NumItems": obj.get("NumItems"),
            "PickwaveIds": obj.get("PickwaveIds"),
            "StockAllocationType": obj.get("StockAllocationType")
        })
        return _obj


