# coding: utf-8

"""
    Post Sale (Cancellations) API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: postsale
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.postsale.models.post_sale_status import PostSaleStatus
from linnworks_api.generated.postsale.models.verified_refund import VerifiedRefund
from typing import Optional, Set
from typing_extensions import Self

class OrderRefundHeader(BaseModel):
    """
    OrderRefundHeader
    """ # noqa: E501
    refund_header_id: Optional[StrictInt] = Field(default=None, alias="RefundHeaderId")
    currency: Optional[StrictStr] = Field(default=None, alias="Currency")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Amount")
    refund_lines: Optional[List[VerifiedRefund]] = Field(default=None, alias="RefundLines")
    refund_link: Optional[StrictStr] = Field(default=None, alias="RefundLink")
    order_id: Optional[StrictStr] = Field(default=None, alias="OrderId")
    num_order_id: Optional[StrictInt] = Field(default=None, alias="NumOrderId")
    status: Optional[PostSaleStatus] = Field(default=None, alias="Status")
    order_source: Optional[StrictStr] = Field(default=None, alias="OrderSource")
    order_sub_source: Optional[StrictStr] = Field(default=None, alias="OrderSubSource")
    external_reference: Optional[StrictStr] = Field(default=None, alias="ExternalReference")
    channel_initiated: Optional[StrictBool] = Field(default=None, alias="ChannelInitiated")
    created_date: Optional[datetime] = Field(default=None, alias="CreatedDate")
    actioned: Optional[StrictBool] = Field(default=None, alias="Actioned")
    last_action_date: Optional[datetime] = Field(default=None, alias="LastActionDate")
    __properties: ClassVar[List[str]] = ["RefundHeaderId", "Currency", "Amount", "RefundLines", "RefundLink", "OrderId", "NumOrderId", "Status", "OrderSource", "OrderSubSource", "ExternalReference", "ChannelInitiated", "CreatedDate", "Actioned", "LastActionDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderRefundHeader from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in refund_lines (list)
        _items = []
        if self.refund_lines:
            for _item_refund_lines in self.refund_lines:
                if _item_refund_lines:
                    _items.append(_item_refund_lines.to_dict())
            _dict['RefundLines'] = _items
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['Status'] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderRefundHeader from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "RefundHeaderId": obj.get("RefundHeaderId"),
            "Currency": obj.get("Currency"),
            "Amount": obj.get("Amount"),
            "RefundLines": [VerifiedRefund.from_dict(_item) for _item in obj["RefundLines"]] if obj.get("RefundLines") is not None else None,
            "RefundLink": obj.get("RefundLink"),
            "OrderId": obj.get("OrderId"),
            "NumOrderId": obj.get("NumOrderId"),
            "Status": PostSaleStatus.from_dict(obj["Status"]) if obj.get("Status") is not None else None,
            "OrderSource": obj.get("OrderSource"),
            "OrderSubSource": obj.get("OrderSubSource"),
            "ExternalReference": obj.get("ExternalReference"),
            "ChannelInitiated": obj.get("ChannelInitiated"),
            "CreatedDate": obj.get("CreatedDate"),
            "Actioned": obj.get("Actioned"),
            "LastActionDate": obj.get("LastActionDate")
        })
        return _obj


