# coding: utf-8

"""
    Post Sale (Cancellations) API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: postsale
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.postsale.models.channel_existing_cancellation import ChannelExistingCancellation
from linnworks_api.generated.postsale.models.order_details import OrderDetails
from linnworks_api.generated.postsale.models.order_refund_header import OrderRefundHeader
from linnworks_api.generated.postsale.models.post_sale_sub_status import PostSaleSubStatus
from typing import Optional, Set
from typing_extensions import Self

class ValidatedCancellation(BaseModel):
    """
    ValidatedCancellation
    """ # noqa: E501
    status: Optional[StrictStr] = Field(default=None, alias="Status")
    sub_status: Optional[PostSaleSubStatus] = Field(default=None, alias="SubStatus")
    channel_existing_cancellations: Optional[List[ChannelExistingCancellation]] = Field(default=None, alias="ChannelExistingCancellations")
    needs_confirmation: Optional[StrictBool] = Field(default=None, alias="NeedsConfirmation")
    refund_reference: Optional[StrictStr] = Field(default=None, alias="RefundReference")
    errors: Optional[List[StrictStr]] = Field(default=None, alias="Errors")
    order: Optional[OrderDetails] = Field(default=None, alias="Order")
    cancellation_header: Optional[OrderRefundHeader] = Field(default=None, alias="CancellationHeader")
    allow_refund_on_cancel: Optional[StrictBool] = Field(default=None, alias="AllowRefundOnCancel")
    order_is_locked_on_unhandled_error: Optional[StrictBool] = Field(default=None, alias="OrderIsLockedOnUnhandledError")
    __properties: ClassVar[List[str]] = ["Status", "SubStatus", "ChannelExistingCancellations", "NeedsConfirmation", "RefundReference", "Errors", "Order", "CancellationHeader", "AllowRefundOnCancel", "OrderIsLockedOnUnhandledError"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['OPEN', 'PROCESSED', 'ERROR', 'ERROR_ACKED', 'PENDING']):
            raise ValueError("must be one of enum values ('OPEN', 'PROCESSED', 'ERROR', 'ERROR_ACKED', 'PENDING')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ValidatedCancellation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "status",
            "channel_existing_cancellations",
            "needs_confirmation",
            "refund_reference",
            "errors",
            "allow_refund_on_cancel",
            "order_is_locked_on_unhandled_error",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of sub_status
        if self.sub_status:
            _dict['SubStatus'] = self.sub_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in channel_existing_cancellations (list)
        _items = []
        if self.channel_existing_cancellations:
            for _item_channel_existing_cancellations in self.channel_existing_cancellations:
                if _item_channel_existing_cancellations:
                    _items.append(_item_channel_existing_cancellations.to_dict())
            _dict['ChannelExistingCancellations'] = _items
        # override the default output from pydantic by calling `to_dict()` of order
        if self.order:
            _dict['Order'] = self.order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cancellation_header
        if self.cancellation_header:
            _dict['CancellationHeader'] = self.cancellation_header.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ValidatedCancellation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Status": obj.get("Status"),
            "SubStatus": PostSaleSubStatus.from_dict(obj["SubStatus"]) if obj.get("SubStatus") is not None else None,
            "ChannelExistingCancellations": [ChannelExistingCancellation.from_dict(_item) for _item in obj["ChannelExistingCancellations"]] if obj.get("ChannelExistingCancellations") is not None else None,
            "NeedsConfirmation": obj.get("NeedsConfirmation"),
            "RefundReference": obj.get("RefundReference"),
            "Errors": obj.get("Errors"),
            "Order": OrderDetails.from_dict(obj["Order"]) if obj.get("Order") is not None else None,
            "CancellationHeader": OrderRefundHeader.from_dict(obj["CancellationHeader"]) if obj.get("CancellationHeader") is not None else None,
            "AllowRefundOnCancel": obj.get("AllowRefundOnCancel"),
            "OrderIsLockedOnUnhandledError": obj.get("OrderIsLockedOnUnhandledError")
        })
        return _obj


