# coding: utf-8

"""
    Print Service API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: printservice
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.printservice.models.key_value_guid_int32 import KeyValueGuidInt32
from linnworks_api.generated.printservice.models.key_value_string_string import KeyValueStringString
from typing import Optional, Set
from typing_extensions import Self

class PrintServiceCreatePDFfromJobForceTemplateWithQuantitiesRequest(BaseModel):
    """
    PrintServiceCreatePDFfromJobForceTemplateWithQuantitiesRequest
    """ # noqa: E501
    template_type: Optional[StrictStr] = Field(default=None, description="The template type", alias="templateType")
    ids_and_quantities: Optional[List[KeyValueGuidInt32]] = Field(default=None, description="Stock Id and quantity of stock", alias="IDsAndQuantities")
    template_id: Optional[StrictInt] = Field(default=None, description="The ID of the template to use", alias="templateID")
    parameters: Optional[List[KeyValueStringString]] = None
    printer_name: Optional[StrictStr] = Field(default=None, description="Printer name of the virtual printer to use. If null then the sepecified in the template", alias="printerName")
    print_zone_code: Optional[StrictStr] = Field(default=None, description="Print zone code, if present, will override the printer used if the template has a set printer for that zone", alias="printZoneCode")
    __properties: ClassVar[List[str]] = ["templateType", "IDsAndQuantities", "templateID", "parameters", "printerName", "printZoneCode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrintServiceCreatePDFfromJobForceTemplateWithQuantitiesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in ids_and_quantities (list)
        _items = []
        if self.ids_and_quantities:
            for _item_ids_and_quantities in self.ids_and_quantities:
                if _item_ids_and_quantities:
                    _items.append(_item_ids_and_quantities.to_dict())
            _dict['IDsAndQuantities'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item_parameters in self.parameters:
                if _item_parameters:
                    _items.append(_item_parameters.to_dict())
            _dict['parameters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrintServiceCreatePDFfromJobForceTemplateWithQuantitiesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "templateType": obj.get("templateType"),
            "IDsAndQuantities": [KeyValueGuidInt32.from_dict(_item) for _item in obj["IDsAndQuantities"]] if obj.get("IDsAndQuantities") is not None else None,
            "templateID": obj.get("templateID"),
            "parameters": [KeyValueStringString.from_dict(_item) for _item in obj["parameters"]] if obj.get("parameters") is not None else None,
            "printerName": obj.get("printerName"),
            "printZoneCode": obj.get("printZoneCode")
        })
        return _obj


