# coding: utf-8

"""
    Processed Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: processedorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.processedorders.models.search_filters import SearchFilters
from linnworks_api.generated.processedorders.models.search_sorting import SearchSorting
from typing import Optional, Set
from typing_extensions import Self

class DownloadOrdersToCSVRequest(BaseModel):
    """
    DownloadOrdersToCSVRequest
    """ # noqa: E501
    search_term: Optional[StrictStr] = Field(default=None, description="Search Term", alias="SearchTerm")
    search_filters: Optional[List[SearchFilters]] = Field(default=None, description="Search Filters", alias="SearchFilters")
    date_field: Optional[StrictStr] = Field(default=None, description="Date Field Type", alias="DateField")
    from_date: Optional[datetime] = Field(default=None, description="From Date", alias="FromDate")
    to_date: Optional[datetime] = Field(default=None, description="To Date", alias="ToDate")
    search_sorting: Optional[SearchSorting] = Field(default=None, alias="SearchSorting")
    __properties: ClassVar[List[str]] = ["SearchTerm", "SearchFilters", "DateField", "FromDate", "ToDate", "SearchSorting"]

    @field_validator('date_field')
    def date_field_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['processed', 'payment', 'cancelled', 'received']):
            raise ValueError("must be one of enum values ('processed', 'payment', 'cancelled', 'received')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DownloadOrdersToCSVRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in search_filters (list)
        _items = []
        if self.search_filters:
            for _item_search_filters in self.search_filters:
                if _item_search_filters:
                    _items.append(_item_search_filters.to_dict())
            _dict['SearchFilters'] = _items
        # override the default output from pydantic by calling `to_dict()` of search_sorting
        if self.search_sorting:
            _dict['SearchSorting'] = self.search_sorting.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DownloadOrdersToCSVRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SearchTerm": obj.get("SearchTerm"),
            "SearchFilters": [SearchFilters.from_dict(_item) for _item in obj["SearchFilters"]] if obj.get("SearchFilters") is not None else None,
            "DateField": obj.get("DateField"),
            "FromDate": obj.get("FromDate"),
            "ToDate": obj.get("ToDate"),
            "SearchSorting": SearchSorting.from_dict(obj["SearchSorting"]) if obj.get("SearchSorting") is not None else None
        })
        return _obj


