# coding: utf-8

"""
    Processed Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: processedorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ProcessedOrdersSearchProcessedOrdersPagedRequest(BaseModel):
    """
    ProcessedOrdersSearchProcessedOrdersPagedRequest
    """ # noqa: E501
    var_from: Optional[datetime] = Field(default=None, description="The lower end of the date range to search. Can be null if searching for 'all dates'. Maximum range is 3 months.", alias="from")
    to: Optional[datetime] = Field(default=None, description="The upper end of the date range to search. Can be null if searching for 'all dates'. Maximum range is 3 months.")
    date_type: Optional[StrictStr] = Field(default=None, description="The search type (e.g. ALLDATES)", alias="dateType")
    search_field: Optional[StrictStr] = Field(default=None, description="The field to search by. Can be found by calling GetSearchTypes.", alias="searchField")
    exact_match: Optional[StrictBool] = Field(default=None, description="Set to true if an exact match is required for the search data.", alias="exactMatch")
    search_term: Optional[StrictStr] = Field(default=None, description="The term which you are searching for.", alias="searchTerm")
    page_num: Optional[StrictInt] = Field(default=None, description="The page number of the request.", alias="pageNum")
    num_entries_per_page: Optional[StrictInt] = Field(default=None, description="The number of entries required on a page. Maximum 200.", alias="numEntriesPerPage")
    __properties: ClassVar[List[str]] = ["from", "to", "dateType", "searchField", "exactMatch", "searchTerm", "pageNum", "numEntriesPerPage"]

    @field_validator('date_type')
    def date_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ALLDATES', 'RECEIVED', 'PROCESSED', 'PAYMENTRECEIVED', 'CANCELLED']):
            raise ValueError("must be one of enum values ('ALLDATES', 'RECEIVED', 'PROCESSED', 'PAYMENTRECEIVED', 'CANCELLED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProcessedOrdersSearchProcessedOrdersPagedRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProcessedOrdersSearchProcessedOrdersPagedRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "from": obj.get("from"),
            "to": obj.get("to"),
            "dateType": obj.get("dateType"),
            "searchField": obj.get("searchField"),
            "exactMatch": obj.get("exactMatch"),
            "searchTerm": obj.get("searchTerm"),
            "pageNum": obj.get("pageNum"),
            "numEntriesPerPage": obj.get("numEntriesPerPage")
        })
        return _obj


