# coding: utf-8

"""
    Processed Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: processedorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ReturnInfo(BaseModel):
    """
    ReturnInfo
    """ # noqa: E501
    pk_return_id: Optional[StrictInt] = Field(default=None, alias="pkReturnId")
    row_type: Optional[StrictStr] = Field(default=None, alias="RowType")
    return_reference: Optional[StrictStr] = Field(default=None, alias="ReturnReference")
    fk_order_id: Optional[StrictStr] = Field(default=None, alias="fkOrderId")
    fk_order_item_row_id: Optional[StrictStr] = Field(default=None, alias="fkOrderItemRowId")
    order_item_batch_id: Optional[StrictInt] = Field(default=None, alias="OrderItemBatchId")
    n_order_id: Optional[StrictInt] = Field(default=None, alias="nOrderId")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    item_title: Optional[StrictStr] = Field(default=None, alias="ItemTitle")
    batch_number: Optional[StrictStr] = Field(default=None, alias="BatchNumber")
    reason: Optional[StrictStr] = Field(default=None, alias="Reason")
    channel_reason: Optional[StrictStr] = Field(default=None, alias="ChannelReason")
    channel_reason_sec: Optional[StrictStr] = Field(default=None, alias="ChannelReasonSec")
    category: Optional[StrictStr] = Field(default=None, alias="Category")
    return_qty: Optional[StrictInt] = Field(default=None, alias="ReturnQty")
    fk_return_location_id: Optional[StrictStr] = Field(default=None, alias="fkReturnLocationId")
    scrapped: Optional[StrictBool] = Field(default=None, alias="Scrapped")
    scrap_qty: Optional[StrictInt] = Field(default=None, alias="ScrapQty")
    last_state: Optional[StrictStr] = Field(default=None, alias="LastState")
    last_date: Optional[datetime] = Field(default=None, alias="LastDate")
    completed: Optional[StrictBool] = Field(default=None, alias="Completed")
    fk_new_order_id: Optional[StrictStr] = Field(default=None, alias="fkNewOrderId")
    fk_new_order_item_row_id: Optional[StrictStr] = Field(default=None, alias="fkNewOrderItemRowId")
    fk_new_stock_item_id: Optional[StrictStr] = Field(default=None, alias="fkNewStockItemId")
    new_qty: Optional[StrictInt] = Field(default=None, alias="NewQty")
    new_order_id: Optional[StrictInt] = Field(default=None, alias="NewOrderId")
    new_order_cancelled: Optional[StrictBool] = Field(default=None, alias="NewOrderCancelled")
    new_sku: Optional[StrictStr] = Field(default=None, alias="NewSKU")
    new_item_title: Optional[StrictStr] = Field(default=None, alias="NewItemTitle")
    new_order_processed_on: Optional[datetime] = Field(default=None, alias="NewOrderProcessedOn")
    additional_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="AdditionalCost")
    fk_refund_row_id: Optional[StrictStr] = Field(default=None, alias="fkRefundRowId")
    refunded_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="RefundedAmount")
    pending_refund: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PendingRefund")
    return_date: Optional[datetime] = Field(default=None, alias="ReturnDate")
    __properties: ClassVar[List[str]] = ["pkReturnId", "RowType", "ReturnReference", "fkOrderId", "fkOrderItemRowId", "OrderItemBatchId", "nOrderId", "SKU", "ItemTitle", "BatchNumber", "Reason", "ChannelReason", "ChannelReasonSec", "Category", "ReturnQty", "fkReturnLocationId", "Scrapped", "ScrapQty", "LastState", "LastDate", "Completed", "fkNewOrderId", "fkNewOrderItemRowId", "fkNewStockItemId", "NewQty", "NewOrderId", "NewOrderCancelled", "NewSKU", "NewItemTitle", "NewOrderProcessedOn", "AdditionalCost", "fkRefundRowId", "RefundedAmount", "PendingRefund", "ReturnDate"]

    @field_validator('row_type')
    def row_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['UNKNOWN', 'RETURN', 'RETURNREFUND', 'EXCHANGE', 'RESEND', 'RETURNBOOKING', 'EXCHANGEBOOKING']):
            raise ValueError("must be one of enum values ('UNKNOWN', 'RETURN', 'RETURNREFUND', 'EXCHANGE', 'RESEND', 'RETURNBOOKING', 'EXCHANGEBOOKING')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReturnInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReturnInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkReturnId": obj.get("pkReturnId"),
            "RowType": obj.get("RowType"),
            "ReturnReference": obj.get("ReturnReference"),
            "fkOrderId": obj.get("fkOrderId"),
            "fkOrderItemRowId": obj.get("fkOrderItemRowId"),
            "OrderItemBatchId": obj.get("OrderItemBatchId"),
            "nOrderId": obj.get("nOrderId"),
            "SKU": obj.get("SKU"),
            "ItemTitle": obj.get("ItemTitle"),
            "BatchNumber": obj.get("BatchNumber"),
            "Reason": obj.get("Reason"),
            "ChannelReason": obj.get("ChannelReason"),
            "ChannelReasonSec": obj.get("ChannelReasonSec"),
            "Category": obj.get("Category"),
            "ReturnQty": obj.get("ReturnQty"),
            "fkReturnLocationId": obj.get("fkReturnLocationId"),
            "Scrapped": obj.get("Scrapped"),
            "ScrapQty": obj.get("ScrapQty"),
            "LastState": obj.get("LastState"),
            "LastDate": obj.get("LastDate"),
            "Completed": obj.get("Completed"),
            "fkNewOrderId": obj.get("fkNewOrderId"),
            "fkNewOrderItemRowId": obj.get("fkNewOrderItemRowId"),
            "fkNewStockItemId": obj.get("fkNewStockItemId"),
            "NewQty": obj.get("NewQty"),
            "NewOrderId": obj.get("NewOrderId"),
            "NewOrderCancelled": obj.get("NewOrderCancelled"),
            "NewSKU": obj.get("NewSKU"),
            "NewItemTitle": obj.get("NewItemTitle"),
            "NewOrderProcessedOn": obj.get("NewOrderProcessedOn"),
            "AdditionalCost": obj.get("AdditionalCost"),
            "fkRefundRowId": obj.get("fkRefundRowId"),
            "RefundedAmount": obj.get("RefundedAmount"),
            "PendingRefund": obj.get("PendingRefund"),
            "ReturnDate": obj.get("ReturnDate")
        })
        return _obj


