# coding: utf-8

"""
    Processed Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: processedorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.processedorders.models.order_item_batch import OrderItemBatch
from typing import Optional, Set
from typing_extensions import Self

class RowQty(BaseModel):
    """
    RowQty
    """ # noqa: E501
    order_item_row_id: Optional[StrictStr] = Field(default=None, alias="OrderItemRowId")
    order_item_batch_id: Optional[StrictInt] = Field(default=None, alias="OrderItemBatchId")
    refund: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Refund")
    qty: Optional[StrictInt] = Field(default=None, alias="Qty")
    scrap_qty: Optional[StrictInt] = Field(default=None, alias="ScrapQty")
    batch: Optional[OrderItemBatch] = Field(default=None, alias="Batch")
    additional_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="AdditionalCost")
    new_stock_item_id: Optional[StrictStr] = Field(default=None, alias="NewStockItemId")
    new_qty: Optional[StrictInt] = Field(default=None, alias="NewQty")
    __properties: ClassVar[List[str]] = ["OrderItemRowId", "OrderItemBatchId", "Refund", "Qty", "ScrapQty", "Batch", "AdditionalCost", "NewStockItemId", "NewQty"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RowQty from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of batch
        if self.batch:
            _dict['Batch'] = self.batch.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RowQty from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "OrderItemRowId": obj.get("OrderItemRowId"),
            "OrderItemBatchId": obj.get("OrderItemBatchId"),
            "Refund": obj.get("Refund"),
            "Qty": obj.get("Qty"),
            "ScrapQty": obj.get("ScrapQty"),
            "Batch": OrderItemBatch.from_dict(obj["Batch"]) if obj.get("Batch") is not None else None,
            "AdditionalCost": obj.get("AdditionalCost"),
            "NewStockItemId": obj.get("NewStockItemId"),
            "NewQty": obj.get("NewQty")
        })
        return _obj


