# coding: utf-8

"""
    Processed Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: processedorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.processedorders.models.refund_item import RefundItem
from typing import Optional, Set
from typing_extensions import Self

class ValidationResult(BaseModel):
    """
    ValidationResult
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, alias="Type")
    invalid_items: Optional[List[RefundItem]] = Field(default=None, alias="InvalidItems")
    additional_information: Optional[StrictStr] = Field(default=None, alias="AdditionalInformation")
    __properties: ClassVar[List[str]] = ["Type", "InvalidItems", "AdditionalInformation"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Success', 'Unknown', 'RefundAutomationDisabled', 'NotAllowedByChannel', 'InvalidRefundAmounts', 'NotImplementedForChannel']):
            raise ValueError("must be one of enum values ('Success', 'Unknown', 'RefundAutomationDisabled', 'NotAllowedByChannel', 'InvalidRefundAmounts', 'NotImplementedForChannel')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ValidationResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in invalid_items (list)
        _items = []
        if self.invalid_items:
            for _item_invalid_items in self.invalid_items:
                if _item_invalid_items:
                    _items.append(_item_invalid_items.to_dict())
            _dict['InvalidItems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ValidationResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Type": obj.get("Type"),
            "InvalidItems": [RefundItem.from_dict(_item) for _item in obj["InvalidItems"]] if obj.get("InvalidItems") is not None else None,
            "AdditionalInformation": obj.get("AdditionalInformation")
        })
        return _obj


