# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AddAdditionalCostItem(BaseModel):
    """
    Add additional cost item Id
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Each item in the request can have unique Id supplied (uniqueidentifier) this Id will be returned to you in the response so you can match request item with the response", alias="Id")
    additional_cost_type_id: Optional[StrictInt] = Field(default=None, alias="AdditionalCostTypeId")
    reference: Optional[StrictStr] = Field(default=None, description="Additional cost reference", alias="Reference")
    sub_total_line_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Line Subtotal (Total less tax)", alias="SubTotalLineCost")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Tax rate", alias="TaxRate")
    currency: Optional[StrictStr] = Field(default=None, description="Currency code", alias="Currency")
    conversion_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Conversion rate from system currency, i.e. system currency rate to additional cost currency. For example if your system currency is GBP and additional cost is in USD the converted value is USD / Rate, example calculation, Rate 1.27, Additional cost total is 100, converted value = 100 USD / 1.27 = 78.98 GBP", alias="ConversionRate")
    allocation_locked: Optional[StrictBool] = Field(default=None, description="If this flag is set, new items added to PO will not be part of the allocation cost", alias="AllocationLocked")
    var_print: Optional[StrictBool] = Field(default=None, description="Indicate if the type will appear on prints and emaisl", alias="Print")
    allocation_method: Optional[StrictStr] = Field(default=None, alias="AllocationMethod")
    __properties: ClassVar[List[str]] = ["Id", "AdditionalCostTypeId", "Reference", "SubTotalLineCost", "TaxRate", "Currency", "ConversionRate", "AllocationLocked", "Print", "AllocationMethod"]

    @field_validator('allocation_method')
    def allocation_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ByValue', 'ByCBM']):
            raise ValueError("must be one of enum values ('ByValue', 'ByCBM')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddAdditionalCostItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddAdditionalCostItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Id": obj.get("Id"),
            "AdditionalCostTypeId": obj.get("AdditionalCostTypeId"),
            "Reference": obj.get("Reference"),
            "SubTotalLineCost": obj.get("SubTotalLineCost"),
            "TaxRate": obj.get("TaxRate"),
            "Currency": obj.get("Currency"),
            "ConversionRate": obj.get("ConversionRate"),
            "AllocationLocked": obj.get("AllocationLocked"),
            "Print": obj.get("Print"),
            "AllocationMethod": obj.get("AllocationMethod")
        })
        return _obj


