# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.purchaseorder.models.common_purchase_order_header import CommonPurchaseOrderHeader
from linnworks_api.generated.purchaseorder.models.common_purchase_order_item import CommonPurchaseOrderItem
from typing import Optional, Set
from typing_extensions import Self

class DeliverPurchaseOrderItemAllResponse(BaseModel):
    """
    Response from delivering all items in an open/partial PO
    """ # noqa: E501
    purchase_order_items: Optional[List[CommonPurchaseOrderItem]] = Field(default=None, description="Delivered items", alias="PurchaseOrderItems")
    purchase_order_header: Optional[CommonPurchaseOrderHeader] = Field(default=None, alias="PurchaseOrderHeader")
    __properties: ClassVar[List[str]] = ["PurchaseOrderItems", "PurchaseOrderHeader"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeliverPurchaseOrderItemAllResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in purchase_order_items (list)
        _items = []
        if self.purchase_order_items:
            for _item_purchase_order_items in self.purchase_order_items:
                if _item_purchase_order_items:
                    _items.append(_item_purchase_order_items.to_dict())
            _dict['PurchaseOrderItems'] = _items
        # override the default output from pydantic by calling `to_dict()` of purchase_order_header
        if self.purchase_order_header:
            _dict['PurchaseOrderHeader'] = self.purchase_order_header.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeliverPurchaseOrderItemAllResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PurchaseOrderItems": [CommonPurchaseOrderItem.from_dict(_item) for _item in obj["PurchaseOrderItems"]] if obj.get("PurchaseOrderItems") is not None else None,
            "PurchaseOrderHeader": CommonPurchaseOrderHeader.from_dict(obj["PurchaseOrderHeader"]) if obj.get("PurchaseOrderHeader") is not None else None
        })
        return _obj


