# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.purchaseorder.models.add_purchase_order_item import AddPurchaseOrderItem
from linnworks_api.generated.purchaseorder.models.update_purchase_order_item import UpdatePurchaseOrderItem
from typing import Optional, Set
from typing_extensions import Self

class ModifyPurchaseOrderItemsBulkRequest(BaseModel):
    """
    Request that contains lists to delete, add and update purchase order items
    """ # noqa: E501
    purchase_id: Optional[StrictStr] = Field(default=None, description="Purchase order id", alias="PurchaseId")
    items_to_add: Optional[List[AddPurchaseOrderItem]] = Field(default=None, description="New purchase order items to add", alias="ItemsToAdd")
    items_to_update: Optional[List[UpdatePurchaseOrderItem]] = Field(default=None, description="Purchase order items to update", alias="ItemsToUpdate")
    items_to_delete: Optional[List[StrictStr]] = Field(default=None, description="Purchase order items to delete. PurchaseOrderItemId(s)", alias="ItemsToDelete")
    __properties: ClassVar[List[str]] = ["PurchaseId", "ItemsToAdd", "ItemsToUpdate", "ItemsToDelete"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModifyPurchaseOrderItemsBulkRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items_to_add (list)
        _items = []
        if self.items_to_add:
            for _item_items_to_add in self.items_to_add:
                if _item_items_to_add:
                    _items.append(_item_items_to_add.to_dict())
            _dict['ItemsToAdd'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in items_to_update (list)
        _items = []
        if self.items_to_update:
            for _item_items_to_update in self.items_to_update:
                if _item_items_to_update:
                    _items.append(_item_items_to_update.to_dict())
            _dict['ItemsToUpdate'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModifyPurchaseOrderItemsBulkRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PurchaseId": obj.get("PurchaseId"),
            "ItemsToAdd": [AddPurchaseOrderItem.from_dict(_item) for _item in obj["ItemsToAdd"]] if obj.get("ItemsToAdd") is not None else None,
            "ItemsToUpdate": [UpdatePurchaseOrderItem.from_dict(_item) for _item in obj["ItemsToUpdate"]] if obj.get("ItemsToUpdate") is not None else None,
            "ItemsToDelete": obj.get("ItemsToDelete")
        })
        return _obj


