# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class MyInventoryPOCreationItems(BaseModel):
    """
    MyInventoryPOCreationItems
    """ # noqa: E501
    is_new: Optional[StrictBool] = Field(default=None, alias="IsNew")
    purchase_order_id: Optional[StrictStr] = Field(default=None, alias="PurchaseOrderId")
    open_order_items_bound: Optional[List[StrictStr]] = Field(default=None, alias="OpenOrderItemsBound")
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="StockItemId")
    supplier_id: Optional[StrictStr] = Field(default=None, alias="SupplierId")
    supplier_name: Optional[StrictStr] = Field(default=None, alias="SupplierName")
    oustanding_po_quantity: Optional[StrictInt] = Field(default=None, alias="OustandingPOQuantity")
    suggested_reorder_amount: Optional[StrictInt] = Field(default=None, alias="SuggestedReorderAmount")
    quantity_in_draft_pos: Optional[StrictInt] = Field(default=None, alias="QuantityInDraftPOs")
    item_title: Optional[StrictStr] = Field(default=None, alias="ItemTitle")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    image_url: Optional[StrictStr] = Field(default=None, alias="ImageURL")
    supplier_assigned: Optional[StrictBool] = Field(default=None, alias="SupplierAssigned")
    calculation_method: Optional[StrictStr] = Field(default=None, alias="CalculationMethod")
    error_message: Optional[StrictStr] = Field(default=None, alias="ErrorMessage")
    can_be_ordered: Optional[StrictBool] = Field(default=None, alias="CanBeOrdered")
    error_code: Optional[StrictStr] = Field(default=None, alias="ErrorCode")
    supplier_pack_size: Optional[StrictInt] = Field(default=None, alias="SupplierPackSize")
    minimum_order_quantity: Optional[StrictInt] = Field(default=None, alias="MinimumOrderQuantity")
    requested_supplier_id: Optional[StrictStr] = Field(default=None, alias="RequestedSupplierId")
    __properties: ClassVar[List[str]] = ["IsNew", "PurchaseOrderId", "OpenOrderItemsBound", "StockItemId", "SupplierId", "SupplierName", "OustandingPOQuantity", "SuggestedReorderAmount", "QuantityInDraftPOs", "ItemTitle", "SKU", "ImageURL", "SupplierAssigned", "CalculationMethod", "ErrorMessage", "CanBeOrdered", "ErrorCode", "SupplierPackSize", "MinimumOrderQuantity", "RequestedSupplierId"]

    @field_validator('calculation_method')
    def calculation_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Error', 'MinimumLevel', 'PreviousPOs', 'ReorderPoint', 'OpenOrders']):
            raise ValueError("must be one of enum values ('Error', 'MinimumLevel', 'PreviousPOs', 'ReorderPoint', 'OpenOrders')")
        return value

    @field_validator('error_code')
    def error_code_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NO_ERROR', 'ABOVE_MIN_LEVEL', 'SUPPLIER_NOT_FOUND', 'NO_DEFAULT_SUPPLIER', 'STOCK_LEVEL_UNKNOWN', 'UNSPECIFIED_RP_ERROR', 'NO_PREVIOUS_POS', 'BELOW_SUPPLIER_MINIMUM', 'NO_MINIMUM_LEVEL', 'ITEM_UNTRACKED', 'UNSUPPORTED_OO_REQUEST', 'UNSUPPORTED_CALC_TYPE']):
            raise ValueError("must be one of enum values ('NO_ERROR', 'ABOVE_MIN_LEVEL', 'SUPPLIER_NOT_FOUND', 'NO_DEFAULT_SUPPLIER', 'STOCK_LEVEL_UNKNOWN', 'UNSPECIFIED_RP_ERROR', 'NO_PREVIOUS_POS', 'BELOW_SUPPLIER_MINIMUM', 'NO_MINIMUM_LEVEL', 'ITEM_UNTRACKED', 'UNSUPPORTED_OO_REQUEST', 'UNSUPPORTED_CALC_TYPE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MyInventoryPOCreationItems from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MyInventoryPOCreationItems from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "IsNew": obj.get("IsNew"),
            "PurchaseOrderId": obj.get("PurchaseOrderId"),
            "OpenOrderItemsBound": obj.get("OpenOrderItemsBound"),
            "StockItemId": obj.get("StockItemId"),
            "SupplierId": obj.get("SupplierId"),
            "SupplierName": obj.get("SupplierName"),
            "OustandingPOQuantity": obj.get("OustandingPOQuantity"),
            "SuggestedReorderAmount": obj.get("SuggestedReorderAmount"),
            "QuantityInDraftPOs": obj.get("QuantityInDraftPOs"),
            "ItemTitle": obj.get("ItemTitle"),
            "SKU": obj.get("SKU"),
            "ImageURL": obj.get("ImageURL"),
            "SupplierAssigned": obj.get("SupplierAssigned"),
            "CalculationMethod": obj.get("CalculationMethod"),
            "ErrorMessage": obj.get("ErrorMessage"),
            "CanBeOrdered": obj.get("CanBeOrdered"),
            "ErrorCode": obj.get("ErrorCode"),
            "SupplierPackSize": obj.get("SupplierPackSize"),
            "MinimumOrderQuantity": obj.get("MinimumOrderQuantity"),
            "RequestedSupplierId": obj.get("RequestedSupplierId")
        })
        return _obj


