# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class PurchaseOrderHeader(BaseModel):
    """
    PurchaseOrderHeader
    """ # noqa: E501
    external_invoice_number: Optional[StrictStr] = Field(default=None, alias="ExternalInvoiceNumber")
    status: Optional[StrictStr] = Field(default=None, alias="Status")
    currency: Optional[StrictStr] = Field(default=None, alias="Currency")
    supplier_reference_number: Optional[StrictStr] = Field(default=None, alias="SupplierReferenceNumber")
    locked: Optional[StrictBool] = Field(default=None, alias="Locked")
    unit_amount_tax_included_type: Optional[StrictInt] = Field(default=None, alias="UnitAmountTaxIncludedType")
    line_count: Optional[StrictInt] = Field(default=None, alias="LineCount")
    delivered_lines_count: Optional[StrictInt] = Field(default=None, alias="DeliveredLinesCount")
    pk_purchase_id: Optional[StrictStr] = Field(default=None, alias="pkPurchaseID")
    fk_supplier_id: Optional[StrictStr] = Field(default=None, alias="fkSupplierId")
    fk_location_id: Optional[StrictStr] = Field(default=None, alias="fkLocationId")
    date_of_purchase: Optional[datetime] = Field(default=None, alias="DateOfPurchase")
    date_of_delivery: Optional[datetime] = Field(default=None, alias="DateOfDelivery")
    quoted_delivery_date: Optional[datetime] = Field(default=None, alias="QuotedDeliveryDate")
    postage_paid: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PostagePaid")
    total_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TotalCost")
    tax_paid: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="taxPaid")
    shipping_tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ShippingTaxRate")
    conversion_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ConversionRate")
    converted_shipping_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ConvertedShippingCost")
    converted_shipping_tax: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ConvertedShippingTax")
    converted_other_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ConvertedOtherCost")
    converted_other_tax: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ConvertedOtherTax")
    converted_grand_total: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ConvertedGrandTotal")
    __properties: ClassVar[List[str]] = ["ExternalInvoiceNumber", "Status", "Currency", "SupplierReferenceNumber", "Locked", "UnitAmountTaxIncludedType", "LineCount", "DeliveredLinesCount", "pkPurchaseID", "fkSupplierId", "fkLocationId", "DateOfPurchase", "DateOfDelivery", "QuotedDeliveryDate", "PostagePaid", "TotalCost", "taxPaid", "ShippingTaxRate", "ConversionRate", "ConvertedShippingCost", "ConvertedShippingTax", "ConvertedOtherCost", "ConvertedOtherTax", "ConvertedGrandTotal"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PENDING', 'OPEN', 'PARTIAL', 'DELIVERED']):
            raise ValueError("must be one of enum values ('PENDING', 'OPEN', 'PARTIAL', 'DELIVERED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PurchaseOrderHeader from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PurchaseOrderHeader from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ExternalInvoiceNumber": obj.get("ExternalInvoiceNumber"),
            "Status": obj.get("Status"),
            "Currency": obj.get("Currency"),
            "SupplierReferenceNumber": obj.get("SupplierReferenceNumber"),
            "Locked": obj.get("Locked"),
            "UnitAmountTaxIncludedType": obj.get("UnitAmountTaxIncludedType"),
            "LineCount": obj.get("LineCount"),
            "DeliveredLinesCount": obj.get("DeliveredLinesCount"),
            "pkPurchaseID": obj.get("pkPurchaseID"),
            "fkSupplierId": obj.get("fkSupplierId"),
            "fkLocationId": obj.get("fkLocationId"),
            "DateOfPurchase": obj.get("DateOfPurchase"),
            "DateOfDelivery": obj.get("DateOfDelivery"),
            "QuotedDeliveryDate": obj.get("QuotedDeliveryDate"),
            "PostagePaid": obj.get("PostagePaid"),
            "TotalCost": obj.get("TotalCost"),
            "taxPaid": obj.get("taxPaid"),
            "ShippingTaxRate": obj.get("ShippingTaxRate"),
            "ConversionRate": obj.get("ConversionRate"),
            "ConvertedShippingCost": obj.get("ConvertedShippingCost"),
            "ConvertedShippingTax": obj.get("ConvertedShippingTax"),
            "ConvertedOtherCost": obj.get("ConvertedOtherCost"),
            "ConvertedOtherTax": obj.get("ConvertedOtherTax"),
            "ConvertedGrandTotal": obj.get("ConvertedGrandTotal")
        })
        return _obj


