# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.purchaseorder.models.common_purchase_order_header import CommonPurchaseOrderHeader
from typing import Optional, Set
from typing_extensions import Self

class SearchPurchaseOrdersResult(BaseModel):
    """
    Search_PurchaseOrders result class. Contains the Result - the list of returned purchase order headers, and current paging information
    """ # noqa: E501
    result: Optional[List[CommonPurchaseOrderHeader]] = Field(default=None, description="List of purchase order headers", alias="Result")
    total_pages: Optional[StrictInt] = Field(default=None, description="Total number of pages", alias="TotalPages")
    current_page_number: Optional[StrictInt] = Field(default=None, description="Currently request page number", alias="CurrentPageNumber")
    entries_per_page: Optional[StrictInt] = Field(default=None, description="Requested entries per page", alias="EntriesPerPage")
    total_number_of_records: Optional[StrictInt] = Field(default=None, description="Total number of records matching the search request", alias="TotalNumberOfRecords")
    __properties: ClassVar[List[str]] = ["Result", "TotalPages", "CurrentPageNumber", "EntriesPerPage", "TotalNumberOfRecords"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SearchPurchaseOrdersResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in result (list)
        _items = []
        if self.result:
            for _item_result in self.result:
                if _item_result:
                    _items.append(_item_result.to_dict())
            _dict['Result'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SearchPurchaseOrdersResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Result": [CommonPurchaseOrderHeader.from_dict(_item) for _item in obj["Result"]] if obj.get("Result") is not None else None,
            "TotalPages": obj.get("TotalPages"),
            "CurrentPageNumber": obj.get("CurrentPageNumber"),
            "EntriesPerPage": obj.get("EntriesPerPage"),
            "TotalNumberOfRecords": obj.get("TotalNumberOfRecords")
        })
        return _obj


