# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdateAdditionalCostTypesRequest(BaseModel):
    """
    UpdateAdditionalCostTypesRequest
    """ # noqa: E501
    additional_cost_type_id: Optional[StrictInt] = Field(default=None, description="Additional Cost type id to update", alias="AdditionalCostTypeId")
    type_name: Optional[StrictStr] = Field(default=None, description="Additional cost name, if null the field is not updated", alias="TypeName")
    is_shipping_type: Optional[StrictBool] = Field(default=None, description="Type of additional cost is shipping cost, if null, the field is not updated", alias="IsShippingType")
    is_partial_allocation: Optional[StrictBool] = Field(default=None, description="Type must be 100% allocated to PO items, if null, the field is not updated", alias="IsPartialAllocation")
    var_print: Optional[StrictBool] = Field(default=None, description="Type must appear on prints and emails", alias="Print")
    allocation_method: Optional[StrictStr] = Field(default=None, alias="AllocationMethod")
    __properties: ClassVar[List[str]] = ["AdditionalCostTypeId", "TypeName", "IsShippingType", "IsPartialAllocation", "Print", "AllocationMethod"]

    @field_validator('allocation_method')
    def allocation_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ByValue', 'ByCBM']):
            raise ValueError("must be one of enum values ('ByValue', 'ByCBM')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateAdditionalCostTypesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateAdditionalCostTypesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AdditionalCostTypeId": obj.get("AdditionalCostTypeId"),
            "TypeName": obj.get("TypeName"),
            "IsShippingType": obj.get("IsShippingType"),
            "IsPartialAllocation": obj.get("IsPartialAllocation"),
            "Print": obj.get("Print"),
            "AllocationMethod": obj.get("AllocationMethod")
        })
        return _obj


