# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class UpdatePurchaseOrderItemParameter(BaseModel):
    """
    Update purchase order item parameter
    """ # noqa: E501
    pk_purchase_item_id: Optional[StrictStr] = Field(default=None, description="Purchase order item unique row identifier", alias="pkPurchaseItemId")
    pk_purchase_id: Optional[StrictStr] = Field(default=None, description="Purchase order id", alias="pkPurchaseId")
    quantity: Optional[StrictInt] = Field(default=None, description="Quantity to be updated. (optional)", alias="Quantity")
    pack_quantity: Optional[StrictInt] = Field(default=None, description="Number of items in a single pack. This is for reference purposes only. Not used for any calculations. Optional", alias="PackQuantity")
    pack_size: Optional[StrictInt] = Field(default=None, description="Number of packs ordered. This is for reference purposes only. Not used for any calculations. Optional", alias="PackSize")
    cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Line Total cost of all the purchase order item inclusive of tax (unitcost * qty) + tax.   Value should be in the currency of the purchase order  (Optional) if not specified the cost will be recalculated from current cost specified on the PO", alias="Cost")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Tax Rate (Optional)", alias="TaxRate")
    __properties: ClassVar[List[str]] = ["pkPurchaseItemId", "pkPurchaseId", "Quantity", "PackQuantity", "PackSize", "Cost", "TaxRate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdatePurchaseOrderItemParameter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdatePurchaseOrderItemParameter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkPurchaseItemId": obj.get("pkPurchaseItemId"),
            "pkPurchaseId": obj.get("pkPurchaseId"),
            "Quantity": obj.get("Quantity"),
            "PackQuantity": obj.get("PackQuantity"),
            "PackSize": obj.get("PackSize"),
            "Cost": obj.get("Cost"),
            "TaxRate": obj.get("TaxRate")
        })
        return _obj


