# coding: utf-8

"""
    Returns and Refunds API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: returnsrefunds
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.returnsrefunds.models.order_rma_header import OrderRMAHeader
from typing import Optional, Set
from typing_extensions import Self

class GetProcessedOrAckedErrorRMAHeadersResponse(BaseModel):
    """
    GetProcessedOrAckedErrorRMAHeadersResponse
    """ # noqa: E501
    page: Optional[StrictInt] = Field(default=None, description="The page number returned", alias="Page")
    total_headers: Optional[StrictInt] = Field(default=None, description="A count of the total number of RMA headers matching the filter set by the request", alias="TotalHeaders")
    headers_per_page: Optional[StrictInt] = Field(default=None, description="A count of the number of RMA headers returned per page", alias="HeadersPerPage")
    rma_headers: Optional[List[OrderRMAHeader]] = Field(default=None, description="A collection of RMA headers matching the filter set by the request", alias="RMAHeaders")
    __properties: ClassVar[List[str]] = ["Page", "TotalHeaders", "HeadersPerPage", "RMAHeaders"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetProcessedOrAckedErrorRMAHeadersResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in rma_headers (list)
        _items = []
        if self.rma_headers:
            for _item_rma_headers in self.rma_headers:
                if _item_rma_headers:
                    _items.append(_item_rma_headers.to_dict())
            _dict['RMAHeaders'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetProcessedOrAckedErrorRMAHeadersResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Page": obj.get("Page"),
            "TotalHeaders": obj.get("TotalHeaders"),
            "HeadersPerPage": obj.get("HeadersPerPage"),
            "RMAHeaders": [OrderRMAHeader.from_dict(_item) for _item in obj["RMAHeaders"]] if obj.get("RMAHeaders") is not None else None
        })
        return _obj


