# coding: utf-8

"""
    Returns and Refunds API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: returnsrefunds
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class NewRefundLine(BaseModel):
    """
    NewRefundLine
    """ # noqa: E501
    return_row_id: Optional[StrictInt] = Field(default=None, alias="ReturnRowId")
    order_item_row_id: Optional[StrictStr] = Field(default=None, alias="OrderItemRowId")
    refunded_unit: Optional[StrictStr] = Field(default=None, alias="RefundedUnit")
    cancelled_quantity: Optional[StrictInt] = Field(default=None, alias="CancelledQuantity")
    external_reference: Optional[StrictStr] = Field(default=None, alias="ExternalReference")
    is_free_text: Optional[StrictBool] = Field(default=None, alias="IsFreeText")
    free_text_or_note: Optional[StrictStr] = Field(default=None, alias="FreeTextOrNote")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Amount")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    reason_tag: Optional[StrictStr] = Field(default=None, alias="ReasonTag")
    sub_reason_tag: Optional[StrictStr] = Field(default=None, alias="SubReasonTag")
    insufficient_refund_tag: Optional[StrictStr] = Field(default=None, alias="InsufficientRefundTag")
    insufficient_refund_note: Optional[StrictStr] = Field(default=None, alias="InsufficientRefundNote")
    reason_category: Optional[StrictStr] = Field(default=None, alias="ReasonCategory")
    __properties: ClassVar[List[str]] = ["ReturnRowId", "OrderItemRowId", "RefundedUnit", "CancelledQuantity", "ExternalReference", "IsFreeText", "FreeTextOrNote", "Amount", "Quantity", "ReasonTag", "SubReasonTag", "InsufficientRefundTag", "InsufficientRefundNote", "ReasonCategory"]

    @field_validator('refunded_unit')
    def refunded_unit_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Item', 'Shipping', 'Service', 'Additional']):
            raise ValueError("must be one of enum values ('Item', 'Shipping', 'Service', 'Additional')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NewRefundLine from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_free_text",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NewRefundLine from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ReturnRowId": obj.get("ReturnRowId"),
            "OrderItemRowId": obj.get("OrderItemRowId"),
            "RefundedUnit": obj.get("RefundedUnit"),
            "CancelledQuantity": obj.get("CancelledQuantity"),
            "ExternalReference": obj.get("ExternalReference"),
            "IsFreeText": obj.get("IsFreeText"),
            "FreeTextOrNote": obj.get("FreeTextOrNote"),
            "Amount": obj.get("Amount"),
            "Quantity": obj.get("Quantity"),
            "ReasonTag": obj.get("ReasonTag"),
            "SubReasonTag": obj.get("SubReasonTag"),
            "InsufficientRefundTag": obj.get("InsufficientRefundTag"),
            "InsufficientRefundNote": obj.get("InsufficientRefundNote"),
            "ReasonCategory": obj.get("ReasonCategory")
        })
        return _obj


